/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.Preferences;
import com.spacekiller.util.RuntimeContext;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.workbench.AbstractWorkbenchObject;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewEvent;
import com.spacekiller.util.workbench.ViewFocusEvent;
import com.spacekiller.util.workbench.ViewFocusListener;
import com.spacekiller.util.workbench.ViewFocusSupport;
import com.spacekiller.util.workbench.ViewListener;
import com.spacekiller.util.workbench.ViewProvider;
import com.spacekiller.util.workbench.Workbench;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public abstract class Perspective
extends AbstractWorkbenchObject {
    public static final String VIEW_FOCUS_LISTENER_LIST = Perspective.class.getName() + "#viewFocusListenerList";
    private Workbench workbench;
    private boolean activated = false;
    private boolean activating = false;
    private List views = new ArrayList();
    private ViewFocusSupport focusSupport;
    private EventListenerList viewFocusListenerList;
    private ViewFocusHandler viewFocusHandler = new ViewFocusHandler();
    private ToolGroup menuGroup;
    private Component component;
    private View mainView;
    private MainViewHandler mainViewHandler = new MainViewHandler();
    private View selectedView;
    private static final Logger logger = Logger.getLogger(Perspective.class.getName());

    public Perspective() {
        this.initAbstractPerspective();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate() {
        if (this.activated) {
            return;
        }
        Perspective perspective = this;
        synchronized (perspective) {
            if (this.activated) {
                return;
            }
            if (this.activating) {
                return;
            }
            try {
                this.activating = true;
                this.startup();
                this.setActivated(true);
            }
            finally {
                this.activating = false;
            }
        }
    }

    public synchronized void addView(View view) {
        if (view == null) {
            return;
        }
        if (this.views.contains(view)) {
            return;
        }
        this.views.add(view);
        this.installView(view);
        this.getFocusSupport().addView(view);
    }

    protected EventListenerList createViewFocusListenerList() {
        return new EventListenerList();
    }

    protected ViewFocusSupport createFocusSupport() {
        return new ViewFocusSupport(this.getViewFocusListenerList());
    }

    protected ViewFocusHandler getViewFocusHandler() {
        return this.viewFocusHandler;
    }

    protected EventListenerList getViewFocusListenerList() {
        if (this.viewFocusListenerList == null) {
            this.setViewFocusListenerList(this.createViewFocusListenerList());
        }
        return this.viewFocusListenerList;
    }

    protected ViewFocusSupport getFocusSupport() {
        if (this.focusSupport == null) {
            this.setFocusSupport(this.createFocusSupport());
        }
        return this.focusSupport;
    }

    protected void handleException(Throwable e) {
        RuntimeContext rc;
        logger.log(Level.WARNING, e.getMessage(), e);
        Workbench wb = this.getWorkbench();
        if (wb != null && (rc = wb.getRuntimeContext()) != null) {
            String message = e.getMessage();
            if (message == null || message.length() < 1) {
                message = "" + e;
            }
            rc.notify(null, (Object)message);
        }
    }

    protected void handleViewFocusChanged(ViewFocusEvent e) {
        View view = e.getView();
        if (view != null) {
            this.setSelectedView(view);
        }
    }

    protected void initAbstractPerspective() {
        this.getViewFocusListenerList().add(ViewFocusListener.class, this.getViewFocusHandler());
    }

    public boolean isActivated() {
        return this.activated;
    }

    public synchronized void removeView(View view) {
        if (this.views.remove(view)) {
            this.getFocusSupport().removeView(view);
            this.uninstallView(view);
        }
    }

    protected void setActivated(boolean newActivated) {
        this.activated = newActivated;
    }

    protected void setViewFocusListenerList(EventListenerList newViewFocusListenerList) {
        this.viewFocusListenerList = newViewFocusListenerList;
    }

    protected void setFocusSupport(ViewFocusSupport newViewFocusSupport) {
        this.focusSupport = newViewFocusSupport;
    }

    final void shutdown() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("" + this + ".shutdown..");
        }
        ArrayList viewList = new ArrayList();
        viewList.addAll(this.views);
        Iterator i = viewList.iterator();
        while (i.hasNext()) {
            this.removeView((View)i.next());
        }
    }

    protected void startup() {
    }

    public synchronized void refresh() {
        if (this.menuGroup != null) {
            this.menuGroup.refresh();
        }
        if (this.views != null) {
            for (View v : this.views) {
                if (v == null) continue;
                try {
                    v.refresh();
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }
    }

    public Component getComponent() {
        if (this.component == null) {
            this.setComponent(this.createComponent());
        }
        return this.component;
    }

    private void setComponent(Component component) {
        this.component = component;
    }

    public boolean isComponentInitialized() {
        return this.component != null;
    }

    public ToolGroup getMenuGroup() {
        return this.menuGroup;
    }

    public synchronized void setMenuGroup(ToolGroup newGroup) {
        if (this.menuGroup != null) {
            throw new RuntimeException("Menu-Group already initialized.");
        }
        this.menuGroup = newGroup;
    }

    public View getMainView() {
        if (this.mainView == null) {
            this.setMainView(this.createMainView());
            this.mainView.addViewListener(this.mainViewHandler);
        }
        return this.mainView;
    }

    protected abstract View createMainView();

    protected void setMainView(View mainView) {
        this.mainView = mainView;
    }

    protected Component createComponent() {
        View mainView = this.getMainView();
        return mainView.getComponent();
    }

    public View getViewAt(int index) {
        return (View)this.views.get(index);
    }

    public int getViewCount() {
        return this.views.size();
    }

    public View getViewOfType(Class viewType) {
        if (viewType == null) {
            return null;
        }
        int n = this.views.size();
        for (int i = 0; i < n; ++i) {
            View v = (View)this.views.get(i);
            if (v == null || !viewType.isAssignableFrom(v.getClass())) continue;
            return v;
        }
        return null;
    }

    public View getViewOfProvider(ViewProvider provider) {
        if (provider == null) {
            return null;
        }
        int n = this.views.size();
        for (int i = 0; i < n; ++i) {
            View v = (View)this.views.get(i);
            if (v == null || v.getProvider() != provider) continue;
            return v;
        }
        return null;
    }

    protected abstract void installView(View var1);

    protected abstract void uninstallView(View var1);

    public View getSelectedView() {
        return this.selectedView;
    }

    protected void setSelectedView(View selectedView) {
        this.selectedView = selectedView;
    }

    public void addViewFocusListener(ViewFocusListener l) {
        this.viewFocusListenerList.add(ViewFocusListener.class, l);
    }

    public void removeViewFocusListener(ViewFocusListener l) {
        this.viewFocusListenerList.remove(ViewFocusListener.class, l);
    }

    public Workbench getWorkbench() {
        return this.workbench;
    }

    synchronized void setWorkbench(Workbench workbench) {
        this.workbench = workbench;
    }

    public abstract boolean maximizeView(View var1);

    public abstract boolean minimizeView(View var1);

    public abstract boolean detachView(View var1);

    public abstract boolean restoreView(View var1);

    public abstract void toFront(View var1);

    public abstract void savePreferences(Preferences var1) throws Exception;

    public abstract void loadPreferences(Preferences var1) throws Exception;

    public abstract void workbenchActivated(WindowEvent var1);

    public abstract void workbenchDeactivated(WindowEvent var1);

    public abstract void workbenchIconified(WindowEvent var1);

    public abstract void workbenchDeiconified(WindowEvent var1);

    protected class MainViewHandler
    implements ViewListener {
        protected MainViewHandler() {
        }

        @Override
        public void viewsInserted(ViewEvent ev) {
        }

        @Override
        public void viewsRemoved(ViewEvent ev) {
            View[] views = ev.getChildren();
            if (views != null) {
                int num = views.length;
                for (int c = 0; c < num; ++c) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Perspective.viewRemoved: " + views[c]);
                    }
                    Perspective.this.removeView(views[c]);
                }
            }
        }
    }

    public class ViewFocusHandler
    implements ViewFocusListener {
        @Override
        public void viewFocusChanged(ViewFocusEvent e) {
            Perspective.this.handleViewFocusChanged(e);
        }
    }
}

