/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.swing.TransListCellRenderer;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.ViewProvider;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;

public class PerspectiveChooser
extends JPanel {
    private static final long serialVersionUID = 3809290594821706276L;
    private Workbench workbench;
    private WorkbenchHandler workbenchHandler = new WorkbenchHandler();
    private JComboBox jComboBoxSwitch = null;

    public PerspectiveChooser() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.gridx = 1;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(205, 56));
        this.add((Component)this.getJComboBoxSwitch(), gridBagConstraints);
    }

    private JComboBox getJComboBoxSwitch() {
        if (this.jComboBoxSwitch == null) {
            this.jComboBoxSwitch = new JComboBox();
            this.jComboBoxSwitch.setOpaque(false);
            this.jComboBoxSwitch.setBorder(BorderFactory.createCompoundBorder(null, null));
            this.jComboBoxSwitch.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PerspectiveChooser.this.actionSetPerspective();
                }
            });
        }
        return this.jComboBoxSwitch;
    }

    public Workbench getWorkbench() {
        return this.workbench;
    }

    public synchronized void setWorkbench(Workbench newWorkbench) {
        if (this.workbench != null) {
            this.workbench.removeWorkbenchListener(this.workbenchHandler);
        }
        this.workbench = newWorkbench;
        if (this.workbench != null) {
            this.workbench.addWorkbenchListener(this.workbenchHandler);
        }
        this.refresh();
    }

    protected void refresh() {
        DefaultComboBoxModel<Perspective> model = new DefaultComboBoxModel<Perspective>();
        int num = this.workbench.getPerspectiveCount();
        Perspective activePers = this.workbench.getPerspective();
        for (int c = 0; c < num; ++c) {
            Perspective pers = this.workbench.getPerspectiveAt(c);
            if (pers == null) continue;
            model.addElement(pers);
        }
        this.getJComboBoxSwitch().setModel(model);
        if (activePers != null) {
            this.getJComboBoxSwitch().setSelectedItem(activePers);
        }
    }

    public void initPerspectiveChooser() {
        this.getJComboBoxSwitch().setRenderer(new PerspectiveRenderer());
    }

    protected void makeCompoundComponent(Component comp) {
        Container cont;
        Component[] comps;
        if (comp instanceof JComponent) {
            ((JComponent)comp).setOpaque(false);
        }
        if (comp instanceof JButton) {
            ((JButton)comp).setBorder(new CompoundBorder());
        }
        if (comp instanceof Container && (comps = (cont = (Container)comp).getComponents()) != null) {
            for (int c = 0; c < comps.length; ++c) {
                Component x = comps[c];
                if (x == null) continue;
                this.makeCompoundComponent(x);
            }
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.height = 22;
        return dim;
    }

    protected void actionSetPerspective() {
        Object sel = this.getJComboBoxSwitch().getSelectedItem();
        if (sel == null) {
            return;
        }
        final Perspective pers = (Perspective)sel;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (PerspectiveChooser.this.workbench != null) {
                    PerspectiveChooser.this.workbench.setPerspective(pers);
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.getJComboBoxSwitch().setToolTipText(text);
    }

    protected class PerspectiveRenderer
    extends TransListCellRenderer {
        private static final long serialVersionUID = 2427626367438536562L;
        private Font normalFont;
        private Font activeFont;
        private Color normalBack;
        private Color selectedBack;
        private Color back;

        public PerspectiveRenderer() {
            String name = "dialog";
            int size = 12;
            this.normalFont = new Font(name, 0, size);
            this.activeFont = new Font(name, 1, size);
            this.normalBack = new Color(0.0f, 0.0f, 0.0f, 0.0f);
            this.selectedBack = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            String text = "";
            Icon icon = null;
            String tooltip = null;
            Font font = this.normalFont;
            Color color = this.back = isSelected ? this.selectedBack : this.normalBack;
            if (value instanceof Perspective) {
                Perspective p = (Perspective)value;
                text = p.getTitle();
                icon = p.getIcon();
                tooltip = p.getTooltip();
                if (PerspectiveChooser.this.workbench != null && PerspectiveChooser.this.workbench.isPerspectiveOpened(p)) {
                    font = this.activeFont;
                }
            } else {
                text = "" + value;
            }
            this.setFont(font);
            this.setText(text);
            this.setToolTipText(tooltip);
            this.setIcon(icon);
            this.setOpaque(false);
            return this;
        }

        protected void paintComponent(Graphics g) {
            if (this.back != null) {
                g.setColor(this.back);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paintComponent(g);
        }
    }

    protected class WorkbenchHandler
    implements WorkbenchListener {
        protected WorkbenchHandler() {
        }

        @Override
        public void perspectiveAdded(Perspective p) {
            PerspectiveChooser.this.refresh();
        }

        @Override
        public void perspectiveRemoved(Perspective p) {
            PerspectiveChooser.this.refresh();
        }

        @Override
        public void perspectiveOpened(Perspective p) {
            PerspectiveChooser.this.refresh();
        }

        @Override
        public void perspectiveClosed(Perspective p) {
            PerspectiveChooser.this.refresh();
        }

        @Override
        public void perspectiveActivated(Perspective p) {
            PerspectiveChooser.this.refresh();
        }

        @Override
        public void perspectiveDeactivated(Perspective p) {
            PerspectiveChooser.this.refresh();
        }

        @Override
        public void viewProviderAdded(ViewProvider vp) {
        }

        @Override
        public void viewProviderRemoved(ViewProvider vp) {
        }
    }
}

