/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.PreferencesPage;
import com.spacekiller.util.workbench.PreferencesPanel;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.Workbench;
import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Logger;

public class PreferencesView
extends View {
    private PreferencesPanel preferencesPanel;
    private static final Logger logger = Logger.getLogger(PreferencesView.class.getName());
    private String selectedPreferencesPageId;

    @Override
    protected Component createComponent() {
        return this.getPreferencesPanel();
    }

    @Override
    protected void installChildComponent(View child, Component childComponent) {
    }

    @Override
    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    protected PreferencesPanel createPreferencesPanel() {
        PreferencesPanel panel = new PreferencesPanel();
        panel.setView(this);
        panel.setPreferredSize(new Dimension(800, 500));
        Perspective pers = this.getPerspective();
        logger.fine("Perspective: " + pers);
        if (pers != null) {
            Workbench wb = pers.getWorkbench();
            logger.fine("Workbench: " + wb);
            if (wb != null) {
                int pageCount = wb.getPreferencesPageCount();
                logger.fine("Pref-Pages: " + pageCount);
                for (int c = 0; c < pageCount; ++c) {
                    PreferencesPage pp = wb.getPreferencesPageAt(c);
                    if (pp == null) continue;
                    panel.addPreferencesPage(pp);
                }
            }
        }
        panel.refresh();
        panel.setSelectedPreferencesPageId(this.selectedPreferencesPageId);
        return panel;
    }

    protected PreferencesPanel getPreferencesPanel() {
        if (this.preferencesPanel == null) {
            this.setPreferencesPanel(this.createPreferencesPanel());
        }
        return this.preferencesPanel;
    }

    protected void setPreferencesPanel(PreferencesPanel preferencesPanel) {
        this.preferencesPanel = preferencesPanel;
    }

    public String getSelectedPreferencesPageId() {
        return this.selectedPreferencesPageId;
    }

    public void setSelectedPreferencesPageId(String selectedPreferencesPageId) {
        this.selectedPreferencesPageId = selectedPreferencesPageId;
    }
}

