/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.beans.AnchorlessBeanContext;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.BeanObserver;
import com.spacekiller.util.beans.FeatureDescriptorFilter;
import com.spacekiller.util.beans.Selectable;
import com.spacekiller.util.beans.Selection;
import com.spacekiller.util.beans.model.BeanTreeComparator;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.workbench.BeanTreeView;
import com.spacekiller.util.workbench.ConstructorView;
import com.spacekiller.util.workbench.ProjectTreePanel;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workspace.Project;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.beancontext.BeanContext;

public class ProjectTreeView
extends View
implements BeanObserver,
Selectable {
    private BeanContext rootContext;
    private BeansToolkit beansToolkit;
    private BeanDropSupport beanDropSupport;
    private BeanTreeComparator beanTreeComparator;
    private FeatureDescriptorFilter featureDescriptorFilter;
    private ToolGroup toolbarGroup;
    private ToolGroup popupMenuToolGroup;
    private ProjectTreePanel projectTreePanel;

    public ProjectTreeView() {
        this.initScratchpadView();
    }

    protected void initScratchpadView() {
        AnchorlessBeanContext bc = new AnchorlessBeanContext();
        this.setRootContext((BeanContext)bc);
    }

    @Override
    protected Component createComponent() {
        return this.getProjectTreePanel();
    }

    @Override
    protected void installChildComponent(View child, Component childComponent) {
    }

    @Override
    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    protected ProjectTreePanel createProjectTreePanel() {
        ProjectTreePanel panel = new ProjectTreePanel();
        panel.setProjectTreeView(this);
        panel.setBeansToolkit(this.getBeansToolkit());
        panel.setToolbarGroup(this.toolbarGroup);
        BeanTreeView btv = new BeanTreeView();
        btv.setBeanDropSupport(this.beanDropSupport);
        btv.setBeansToolkit(this.beansToolkit);
        btv.setBeanTreeComparator(this.beanTreeComparator);
        btv.setFeatureDescriptorFilter(this.featureDescriptorFilter);
        btv.setPopupMenuToolGroup(this.popupMenuToolGroup);
        btv.setRootContext(this.rootContext);
        this.addChild(btv);
        panel.setBeanTreeView(btv);
        panel.setPreferredSize(new Dimension(260, 500));
        return panel;
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
        if (this.projectTreePanel != null) {
            this.projectTreePanel.setBeansToolkit(beansToolkit);
        }
    }

    public void actionCreate() {
        ConstructorView cv = new ConstructorView();
        BeansToolkit btk = this.getBeansToolkit();
        ClassRegistry reg = btk == null ? null : btk.getClassRegistry();
        cv.setBeansToolkit(btk);
        cv.setClassRegistry(reg);
        cv.setSelectedBeanObserver(this);
        this.getPerspective().addView(cv);
    }

    public boolean addBean(Object o) throws Exception {
        if (this.rootContext == null) {
            return false;
        }
        return this.rootContext.add(o);
    }

    public void setSelectedProject(Project project) throws Exception {
        this.getProjectTreePanel().setSelectedProject(project);
    }

    public BeanDropSupport getBeanDropSupport() {
        return this.beanDropSupport;
    }

    public void setBeanDropSupport(BeanDropSupport beanDropSupport) {
        this.beanDropSupport = beanDropSupport;
    }

    public BeanTreeComparator getBeanTreeComparator() {
        return this.beanTreeComparator;
    }

    public void setBeanTreeComparator(BeanTreeComparator beanTreeComparator) {
        this.beanTreeComparator = beanTreeComparator;
    }

    public FeatureDescriptorFilter getFeatureDescriptorFilter() {
        return this.featureDescriptorFilter;
    }

    public void setFeatureDescriptorFilter(FeatureDescriptorFilter featureDescriptorFilter) {
        this.featureDescriptorFilter = featureDescriptorFilter;
    }

    public ToolGroup getPopupMenuToolGroup() {
        return this.popupMenuToolGroup;
    }

    public void setPopupMenuToolGroup(ToolGroup popupMenuToolGroup) {
        this.popupMenuToolGroup = popupMenuToolGroup;
    }

    protected BeanContext getRootContext() {
        return this.rootContext;
    }

    protected void setRootContext(BeanContext rootContext) {
        this.rootContext = rootContext;
    }

    public Selection getSelection() {
        return this.projectTreePanel.getBeanTreeView().getSelection();
    }

    public ToolGroup getToolbarGroup() {
        return this.toolbarGroup;
    }

    public void setToolbarGroup(ToolGroup toolbarGroup) {
        this.toolbarGroup = toolbarGroup;
    }

    public ProjectTreePanel getProjectTreePanel() {
        if (this.projectTreePanel == null) {
            this.setProjectTreePanel(this.createProjectTreePanel());
        }
        return this.projectTreePanel;
    }

    private void setProjectTreePanel(ProjectTreePanel projectTreePanel) {
        this.projectTreePanel = projectTreePanel;
    }
}

