/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.RuntimeContext;
import com.spacekiller.util.swing.AbstractCellRenderer;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workspace.SyncManager;
import com.spacekiller.util.workspace.TransactionSavepoint;
import com.spacekiller.util.workspace.Workspace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SavepointPanel
extends JPanel {
    private static final long serialVersionUID = -2942845018627937905L;
    public static final String DEFAULT_DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private Workbench workbench;
    private Workspace workspace;
    private DateFormat dateFormat;
    private List savepoints = new ArrayList();
    private Icon iconCommitted;
    private Icon iconUncommitted;
    private JScrollPane jScrollPane = null;
    private JList jListSavepoints = null;
    private JPanel jPanel = null;
    private JButton jButtonCommit = null;
    private JButton jButtonRollback = null;
    private static final Logger logger = Logger.getLogger(SavepointPanel.class.getName());

    public SavepointPanel() {
        this.initialize();
        this.initSavepointPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.weightx = 1.0;
        gridBagConstraints11.weighty = 0.0;
        gridBagConstraints11.fill = 1;
        gridBagConstraints11.gridy = 2;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints1.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(285, 250));
        this.add((Component)this.getJScrollPane(), gridBagConstraints1);
        this.add((Component)this.getJPanel(), gridBagConstraints11);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJListSavepoints());
        }
        return this.jScrollPane;
    }

    private JList getJListSavepoints() {
        if (this.jListSavepoints == null) {
            this.jListSavepoints = new JList();
            this.jListSavepoints.setSelectionMode(0);
            this.jListSavepoints.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SavepointPanel.this.checkEnable();
                }
            });
        }
        return this.jListSavepoints;
    }

    public Workbench getWorkbench() {
        return this.workbench;
    }

    public void setWorkbench(Workbench workbench) {
        this.workbench = workbench;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
        this.refresh();
    }

    protected void refresh() {
        SyncManager sync;
        this.savepoints.clear();
        DefaultListModel<TransactionSavepoint> model = new DefaultListModel<TransactionSavepoint>();
        Workspace ws = this.getWorkspace();
        if (ws != null && (sync = ws.getSyncManager()) != null) {
            try {
                int num = sync.getSavepointCount();
                for (int i = 0; i < num; ++i) {
                    TransactionSavepoint sp = sync.getSavepointAt(i);
                    if (sp == null) continue;
                    this.savepoints.add(sp);
                    model.addElement(sp);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        this.getJListSavepoints().setModel(model);
        int num = model.getSize();
        if (num > 0) {
            this.getJListSavepoints().setSelectedIndex(num - 1);
            Rectangle rect = this.getJListSavepoints().getCellBounds(num - 1, num - 1);
            this.getJListSavepoints().scrollRectToVisible(rect);
        }
        this.checkEnable();
    }

    protected void initSavepointPanel() {
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_DATE_FORMAT_PATTERN);
        this.setDateFormat(format);
        this.getJListSavepoints().setCellRenderer(new SavepointListCellRenderer());
        this.checkEnable();
        try {
            this.iconCommitted = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/green-ball.gif"));
            this.iconUncommitted = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/outgo_synch.gif"));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.insets = new Insets(4, 0, 4, 4);
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.gridy = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getJButtonCommit(), gridBagConstraints2);
            this.jPanel.add((Component)this.getJButtonRollback(), gridBagConstraints3);
        }
        return this.jPanel;
    }

    private JButton getJButtonCommit() {
        if (this.jButtonCommit == null) {
            this.jButtonCommit = new JButton();
            this.jButtonCommit.setText("Commit");
            this.jButtonCommit.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/commit_trans.gif")));
            this.jButtonCommit.setFont(new Font("Dialog", 0, 12));
            this.jButtonCommit.setToolTipText("Commit changes until the selected savepoint...");
            this.jButtonCommit.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonCommit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SavepointPanel.this.actionCommit();
                }
            });
        }
        return this.jButtonCommit;
    }

    private JButton getJButtonRollback() {
        if (this.jButtonRollback == null) {
            this.jButtonRollback = new JButton();
            this.jButtonRollback.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/rollback.gif")));
            this.jButtonRollback.setText("Rollback");
            this.jButtonRollback.setFont(new Font("Dialog", 0, 12));
            this.jButtonRollback.setToolTipText("Rollback changes to the selected savepoint...");
            this.jButtonRollback.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonRollback.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SavepointPanel.this.actionRollback();
                }
            });
        }
        return this.jButtonRollback;
    }

    protected void actionCommit() {
        this.getJButtonCommit().setEnabled(false);
        this.getJButtonRollback().setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int index = SavepointPanel.this.getJListSavepoints().getSelectedIndex();
                if (index < 0) {
                    return;
                }
                TransactionSavepoint sp = (TransactionSavepoint)SavepointPanel.this.savepoints.get(index);
                if (sp == null) {
                    return;
                }
                Workspace ws = SavepointPanel.this.getWorkspace();
                if (ws == null) {
                    return;
                }
                SyncManager sync = ws.getSyncManager();
                if (sync == null) {
                    return;
                }
                boolean doCommit = false;
                try {
                    SavepointPanel.this.getJListSavepoints().setSelectionMode(2);
                    SavepointPanel.this.getJListSavepoints().getSelectionModel().setSelectionInterval(0, index);
                    RuntimeContext rc = SavepointPanel.this.workbench.getRuntimeContext();
                    if (rc != null) {
                        String title = "Commit ?";
                        String message = "Are you sure to commit the changes";
                        boolean ok = rc.prompt(title, (Object)(message = message + "\nuntil the selected save point ?"));
                        if (!ok) {
                            return;
                        }
                    }
                    doCommit = true;
                }
                finally {
                    SavepointPanel.this.getJListSavepoints().setSelectionMode(0);
                    SavepointPanel.this.getJListSavepoints().setSelectedIndex(index);
                }
                if (doCommit) {
                    try {
                        sync.commit(sp);
                    }
                    catch (Exception e) {
                        SavepointPanel.this.handleException(e);
                    }
                    finally {
                        SavepointPanel.this.refresh();
                    }
                }
            }
        });
    }

    protected void actionRollback() {
        this.getJButtonCommit().setEnabled(false);
        this.getJButtonRollback().setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int index = SavepointPanel.this.getJListSavepoints().getSelectedIndex();
                if (index < 0) {
                    return;
                }
                TransactionSavepoint sp = (TransactionSavepoint)SavepointPanel.this.savepoints.get(index);
                if (sp == null) {
                    return;
                }
                Workspace ws = SavepointPanel.this.getWorkspace();
                if (ws == null) {
                    return;
                }
                SyncManager sync = ws.getSyncManager();
                if (sync == null) {
                    return;
                }
                boolean doRollback = false;
                try {
                    SavepointPanel.this.getJListSavepoints().setSelectionMode(2);
                    int num = SavepointPanel.this.savepoints.size();
                    SavepointPanel.this.getJListSavepoints().getSelectionModel().setSelectionInterval(index, num - 1);
                    RuntimeContext rc = SavepointPanel.this.workbench.getRuntimeContext();
                    if (rc != null) {
                        String title = "Rollback ?";
                        String message = "Are you sure to discard the changes";
                        boolean ok = rc.prompt(title, (Object)(message = message + "\nsince the selected save point ?"));
                        if (!ok) {
                            return;
                        }
                    }
                    doRollback = true;
                }
                finally {
                    SavepointPanel.this.getJListSavepoints().setSelectionMode(0);
                    SavepointPanel.this.getJListSavepoints().setSelectedIndex(index);
                }
                if (doRollback) {
                    try {
                        sync.rollback(sp);
                    }
                    catch (Exception e) {
                        SavepointPanel.this.handleException(e);
                    }
                    finally {
                        SavepointPanel.this.refresh();
                    }
                }
            }
        });
    }

    protected void checkEnable() {
        int i = this.getJListSavepoints().getSelectedIndex();
        boolean enableCommit = false;
        boolean enableRollback = false;
        if (i > 0) {
            enableCommit = true;
        }
        if (i >= 0) {
            enableRollback = true;
        }
        this.getJButtonCommit().setEnabled(enableCommit);
        this.getJButtonRollback().setEnabled(enableRollback);
    }

    protected void handleException(Throwable e) {
        RuntimeContext rc;
        logger.log(Level.SEVERE, e.getMessage(), e);
        Workbench wb = this.getWorkbench();
        if (wb != null && (rc = wb.getRuntimeContext()) != null) {
            rc.notifyError((Object)this, e);
            return;
        }
    }

    protected class SavepointListCellRenderer
    extends AbstractCellRenderer
    implements ListCellRenderer {
        private static final long serialVersionUID = 4728073474285938723L;
        private JLabel label = new JLabel();
        private String tooltip;

        public SavepointListCellRenderer() {
            this.setOpaque(false);
            this.setLayout(new GridLayout(1, 1));
            this.add(this.label);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setSelected(isSelected);
            this.setFocus(cellHasFocus);
            String text = null;
            Icon icon = null;
            if (value != null && value instanceof TransactionSavepoint) {
                TransactionSavepoint sp = (TransactionSavepoint)value;
                long millis = sp.getMillis();
                text = SavepointPanel.this.dateFormat == null ? "" + new Date(millis) : SavepointPanel.this.dateFormat.format(new Date(millis));
                icon = index == 0 ? SavepointPanel.this.iconCommitted : SavepointPanel.this.iconUncommitted;
            }
            if (text == null) {
                text = "";
            }
            this.label.setText(text);
            this.label.setIcon(icon);
            this.tooltip = null;
            return this;
        }

        public String getToolTipText() {
            return this.getToolTipText(null);
        }

        public String getToolTipText(MouseEvent event) {
            return this.tooltip;
        }
    }
}

