/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.workbench.TextWizardView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextWizardPanel
extends JPanel {
    private static final long serialVersionUID = -8339229970173397905L;
    private TextWizardView textWizardView;
    private JScrollPane jScrollPane = null;
    private JTextArea jTextArea = null;
    private JComboBox jComboBoxType = null;
    private JButton jButtonCreate = null;
    private JPanel jPanel = null;
    private JLabel jLabel = null;
    private static final Logger logger = Logger.getLogger(TextWizardPanel.class.getName());

    public TextWizardPanel() {
        this.initialize();
        this.initTextWizardPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 1;
        gridBagConstraints21.fill = 2;
        gridBagConstraints21.weightx = 0.0;
        gridBagConstraints21.weighty = 0.0;
        gridBagConstraints21.gridy = 2;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(389, 224));
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
        this.add((Component)this.getJPanel(), gridBagConstraints21);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setOpaque(false);
            this.jScrollPane.setViewportView(this.getJTextArea());
        }
        return this.jScrollPane;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
            this.jTextArea.setOpaque(false);
        }
        return this.jTextArea;
    }

    private JComboBox getJComboBoxType() {
        if (this.jComboBoxType == null) {
            this.jComboBoxType = new JComboBox();
        }
        return this.jComboBoxType;
    }

    private JButton getJButtonCreate() {
        if (this.jButtonCreate == null) {
            this.jButtonCreate = new JButton();
            this.jButtonCreate.setText("Create");
            this.jButtonCreate.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/newaccessbean_wiz.gif")));
            this.jButtonCreate.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonCreate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextWizardPanel.this.actionCreate();
                }
            });
        }
        return this.jButtonCreate;
    }

    protected void initTextWizardPanel() {
        String[] textClasses = new String[]{"String", "StringBuffer", "StringBuilder"};
        JComboBox combo = this.getJComboBoxType();
        for (int i = 0; i < textClasses.length; ++i) {
            combo.addItem(textClasses[i]);
        }
    }

    protected void actionCreate() {
        String text = this.getJTextArea().getText();
        Object item = this.getJComboBoxType().getSelectedItem();
        if (item == null) {
            return;
        }
        String clazzName = String.valueOf(item);
        try {
            if (clazzName.indexOf(".") < 0) {
                clazzName = "java.lang." + clazzName;
            }
            Class<?> clazz = Class.forName(clazzName);
            logger.fine("Text class: " + clazz);
            Constructor<?> constr = clazz.getConstructor(String.class);
            logger.fine("Constructor: " + constr);
            Object obj = constr.newInstance(text);
            logger.fine("Text object: " + obj);
            this.textWizardView.publish(obj);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected TextWizardView getTextWizardView() {
        return this.textWizardView;
    }

    protected void setTextWizardView(TextWizardView textWizardView) {
        this.textWizardView = textWizardView;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints1.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("Type:");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.insets = new Insets(0, 4, 4, 4);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(0, 4, 4, 4);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setOpaque(false);
            this.jPanel.add((Component)this.getJButtonCreate(), gridBagConstraints3);
            this.jPanel.add((Component)this.getJComboBoxType(), gridBagConstraints2);
            this.jPanel.add((Component)this.jLabel, gridBagConstraints1);
        }
        return this.jPanel;
    }
}

