/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TransferDataPanel
extends JPanel {
    private static final long serialVersionUID = -1248874819687065912L;
    private Transferable transferable;
    private JLabel jLabel = null;
    private JComboBox jComboBoxContentType = null;
    private JPanel jPanelContent = null;
    private static final Logger logger = Logger.getLogger(TransferDataPanel.class.getName());

    public TransferDataPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(0, 4, 4, 4);
        gridBagConstraints2.gridy = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints1.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.gridy = 0;
        this.jLabel = new JLabel();
        this.jLabel.setText("Content Type:");
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(375, 248));
        this.add((Component)this.jLabel, gridBagConstraints);
        this.add((Component)this.getJComboBoxContentType(), gridBagConstraints1);
        this.add((Component)this.getJPanelContent(), gridBagConstraints2);
    }

    private JComboBox getJComboBoxContentType() {
        if (this.jComboBoxContentType == null) {
            this.jComboBoxContentType = new JComboBox();
            this.jComboBoxContentType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TransferDataPanel.this.refreshContentPreview();
                }
            });
        }
        return this.jComboBoxContentType;
    }

    private JPanel getJPanelContent() {
        if (this.jPanelContent == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            this.jPanelContent = new JPanel();
            this.jPanelContent.setBorder(BorderFactory.createEtchedBorder(0));
            this.jPanelContent.setLayout(gridLayout);
            this.jPanelContent.setOpaque(false);
        }
        return this.jPanelContent;
    }

    public Transferable getTransferable() {
        return this.transferable;
    }

    public void setTransferable(Transferable transferable) {
        this.transferable = transferable;
        this.refreshContentTypes();
    }

    protected void refreshContentTypes() {
        DataFlavor[] flavors;
        Transferable trans = this.getTransferable();
        this.getJComboBoxContentType().removeAllItems();
        if (trans != null && (flavors = trans.getTransferDataFlavors()) != null) {
            for (int c = 0; c < flavors.length; ++c) {
                this.getJComboBoxContentType().addItem(flavors[c]);
            }
        }
        this.refreshContentPreview();
    }

    protected void refreshContentPreview() {
        this.getJPanelContent().removeAll();
        JScrollPane preview = null;
        try {
            Component view;
            DataFlavor flavor;
            Object data;
            Transferable trans;
            Object selType = this.getJComboBoxContentType().getSelectedItem();
            if (selType != null && (trans = this.getTransferable()) != null && (data = trans.getTransferData(flavor = (DataFlavor)selType)) != null && (view = this.createPreview(data)) != null) {
                JScrollPane scroll = new JScrollPane();
                scroll.setViewportView(view);
                preview = scroll;
            }
            if (preview != null) {
                this.getJPanelContent().add(preview);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.getJPanelContent().validate();
        this.getJPanelContent().repaint();
    }

    protected Component createPreview(Object data) throws Exception {
        if (data == null) {
            return null;
        }
        if (data instanceof String) {
            JTextArea area = new JTextArea();
            area.setEditable(false);
            area.setText((String)data);
            return area;
        }
        if (data instanceof Image) {
            JLabel label = new JLabel();
            Image image = (Image)data;
            label.setIcon(new ImageIcon(image));
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 0;
            gbc.anchor = 10;
            panel.add((Component)label, gbc);
            return panel;
        }
        if (data instanceof List) {
            // empty if block
        }
        return null;
    }
}

