/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewEvent;
import com.spacekiller.util.workbench.ViewFocusEvent;
import com.spacekiller.util.workbench.ViewFocusListener;
import com.spacekiller.util.workbench.ViewListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class ViewFocusSupport {
    private Vector views = new Vector();
    private Map viewByComponent = new HashMap();
    private EventListenerList viewFocusListenerList;
    private ViewHandler viewHandler = new ViewHandler();
    private ContainerHandler containerHandler = new ContainerHandler();
    private FocusHandler focusHandler = new FocusHandler();
    private Component focusOwner;
    private View focusView;

    public ViewFocusSupport(EventListenerList viewFocusListenerList) {
        this.setViewFocusListenerList(viewFocusListenerList);
    }

    public void addView(View view) {
        this.installViewRecursive(view);
    }

    protected synchronized void fireViewFocusChanged(ViewFocusEvent ev) {
        EventListenerList listeners = this.getViewFocusListenerList();
        if (listeners != null) {
            Object[] l = listeners.getListenerList();
            for (int i = l.length - 2; i >= 0; i -= 2) {
                if (l[i] != ViewFocusListener.class) continue;
                ((ViewFocusListener)l[i + 1]).viewFocusChanged(ev);
            }
        }
    }

    public Component getFocusOwner() {
        return this.focusOwner;
    }

    public View getView(Component viewComponent) {
        return (View)this.viewByComponent.get(viewComponent);
    }

    protected EventListenerList getViewFocusListenerList() {
        return this.viewFocusListenerList;
    }

    protected View getViewOfChildComponent(Component child) {
        while (child != null) {
            View v = this.getView(child);
            if (v != null) {
                return v;
            }
            child = child.getParent();
        }
        return null;
    }

    protected void handleFocusChanged(Component newFocusOwner) {
        this.setFocusOwner(newFocusOwner);
        View view = this.getViewOfChildComponent(newFocusOwner);
        if (view != null) {
            this.setFocusView(view);
            this.fireViewFocusChanged(new ViewFocusEvent(view, newFocusOwner));
        }
    }

    protected synchronized void installComponentRecursive(Component comp) {
        FocusListener[] fls = comp.getFocusListeners();
        for (int i = 0; i < fls.length; ++i) {
            if (fls[i] != this.focusHandler) continue;
            return;
        }
        comp.addFocusListener(this.focusHandler);
        if (comp instanceof Container) {
            Component[] sub = ((Container)comp).getComponents();
            for (int c = 0; c < sub.length; ++c) {
                this.installComponentRecursive(sub[c]);
            }
            ((Container)comp).addContainerListener(this.containerHandler);
        }
    }

    protected synchronized void installViewRecursive(View view) {
        if (view == null || this.views.contains(view)) {
            return;
        }
        this.views.add(view);
        int count = view.getChildCount();
        for (int c = 0; c < count; ++c) {
            View childView = view.getChildAt(c);
            if (childView == null) continue;
            this.installViewRecursive(childView);
        }
        view.addViewListener(this.viewHandler);
        Component viewComp = view.getComponent();
        if (viewComp != null && !this.viewByComponent.containsValue(view)) {
            this.viewByComponent.put(viewComp, view);
            this.installComponentRecursive(viewComp);
        }
    }

    public void removeView(View view) {
        this.uninstallViewRecursive(view);
    }

    protected void setFocusOwner(Component newFocusOwner) {
        this.focusOwner = newFocusOwner;
    }

    protected void setViewFocusListenerList(EventListenerList newViewFocusListenerList) {
        this.viewFocusListenerList = newViewFocusListenerList;
    }

    protected synchronized void uninstallComponentRecursive(Component comp) {
        comp.removeFocusListener(this.focusHandler);
        if (comp instanceof Container) {
            ((Container)comp).removeContainerListener(this.containerHandler);
            Component[] sub = ((Container)comp).getComponents();
            for (int c = 0; c < sub.length; ++c) {
                this.uninstallComponentRecursive(sub[c]);
            }
        }
    }

    protected synchronized void uninstallViewRecursive(View view) {
        Component viewComp;
        if (view == null || !this.views.contains(view)) {
            return;
        }
        if (this.focusView == view) {
            this.setFocusView(null);
            this.fireViewFocusChanged(new ViewFocusEvent(null, null));
        }
        this.views.remove(view);
        int count = view.getChildCount();
        for (int c = 0; c < count; ++c) {
            View childView = view.getChildAt(c);
            if (childView == null) continue;
            this.uninstallViewRecursive(childView);
        }
        view.removeViewListener(this.viewHandler);
        if (view.isComponentInitialized() && (viewComp = view.getComponent()) != null) {
            this.uninstallComponentRecursive(viewComp);
            this.viewByComponent.remove(viewComp);
        }
    }

    public View getFocusView() {
        return this.focusView;
    }

    protected void setFocusView(View focusView) {
        this.focusView = focusView;
    }

    public class FocusHandler
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            Component comp = e.getComponent();
            if (comp != null) {
                ViewFocusSupport.this.handleFocusChanged(comp);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    public class ContainerHandler
    implements ContainerListener {
        @Override
        public void componentAdded(ContainerEvent e) {
            Component child = e.getChild();
            if (child != null) {
                ViewFocusSupport.this.installComponentRecursive(child);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            Component child = e.getChild();
            if (child != null) {
                ViewFocusSupport.this.uninstallComponentRecursive(child);
            }
        }
    }

    public class ViewHandler
    implements ViewListener {
        @Override
        public void viewsInserted(ViewEvent ev) {
            View[] children = ev.getChildren();
            if (children != null) {
                for (int c = 0; c < children.length; ++c) {
                    ViewFocusSupport.this.installViewRecursive(children[c]);
                }
            }
        }

        @Override
        public void viewsRemoved(ViewEvent ev) {
            View[] children = ev.getChildren();
            if (children != null) {
                for (int c = 0; c < children.length; ++c) {
                    ViewFocusSupport.this.uninstallViewRecursive(children[c]);
                }
            }
        }
    }
}

