/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ClassDescriptor;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.FileContext;
import com.spacekiller.util.FileType;
import com.spacekiller.util.FileTypeRegistry;
import com.spacekiller.util.Filter;
import com.spacekiller.util.Platform;
import com.spacekiller.util.RuntimeContext;
import com.spacekiller.util.Sys;
import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.BeanEditor;
import com.spacekiller.util.beans.DefaultBeanFeatureFilter;
import com.spacekiller.util.beans.DefaultFeatureDescriptorFilter;
import com.spacekiller.util.beans.DefaultFeatureNameFilter;
import com.spacekiller.util.beans.FeatureDescriptorFilter;
import com.spacekiller.util.beans.Selection;
import com.spacekiller.util.beans.SimpleSelection;
import com.spacekiller.util.beans.TypeContext;
import com.spacekiller.util.beans.components.ClassChooser;
import com.spacekiller.util.beans.components.InvokeMethodPanel;
import com.spacekiller.util.beans.components.NewObjectDialog;
import com.spacekiller.util.beans.components.NewObjectPanel;
import com.spacekiller.util.beans.customizers.AbstractCustomizer;
import com.spacekiller.util.beans.customizers.BeanSelectionContext;
import com.spacekiller.util.beans.customizers.DefaultCustomizer;
import com.spacekiller.util.beans.model.BeanTreeNode;
import com.spacekiller.util.beans.model.DefaultBeanTreeComparator;
import com.spacekiller.util.tooling.AbstractTool;
import com.spacekiller.util.tooling.TAction;
import com.spacekiller.util.tooling.TSeparator;
import com.spacekiller.util.tooling.Tool;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.workbench.ArrayConstructorView;
import com.spacekiller.util.workbench.BeanTreeView;
import com.spacekiller.util.workbench.ComponentView;
import com.spacekiller.util.workbench.ConstructorView;
import com.spacekiller.util.workbench.DummySelectionToolContext;
import com.spacekiller.util.workbench.EditorView;
import com.spacekiller.util.workbench.ExportProjectDialog;
import com.spacekiller.util.workbench.ImportProjectDialog;
import com.spacekiller.util.workbench.LoadProjectDialog;
import com.spacekiller.util.workbench.NewProjectDialog;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.PerspectiveChooser;
import com.spacekiller.util.workbench.PreferencesView;
import com.spacekiller.util.workbench.ProjectTreeView;
import com.spacekiller.util.workbench.ProjectTreeViewProvider;
import com.spacekiller.util.workbench.SavepointView;
import com.spacekiller.util.workbench.ScratchpadView;
import com.spacekiller.util.workbench.ScratchpadViewProvider;
import com.spacekiller.util.workbench.SelectionManager;
import com.spacekiller.util.workbench.SelectionToolContext;
import com.spacekiller.util.workbench.SelectionToolContextAction;
import com.spacekiller.util.workbench.SynchronizationView;
import com.spacekiller.util.workbench.TextWizardView;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewProvider;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchAction;
import com.spacekiller.util.workbench.WorkbenchPlugin;
import com.spacekiller.util.workbench.WorkbenchToolContext;
import com.spacekiller.util.workbench.WorkbenchUtilities;
import com.spacekiller.util.workspace.DefaultProjectLoader;
import com.spacekiller.util.workspace.DefaultProjectReference;
import com.spacekiller.util.workspace.Project;
import com.spacekiller.util.workspace.ProjectLoader;
import com.spacekiller.util.workspace.ProjectPersistence;
import com.spacekiller.util.workspace.ProjectReference;
import com.spacekiller.util.workspace.ProjectSource;
import com.spacekiller.util.workspace.ProjectType;
import com.spacekiller.util.workspace.ResyncManager;
import com.spacekiller.util.workspace.SyncManager;
import com.spacekiller.util.workspace.Synchronization;
import com.spacekiller.util.workspace.Workspace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.FeatureDescriptor;
import java.beans.MethodDescriptor;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoManager;

public abstract class WorkbenchExtensions {
    public static final Class DEFAULT_CUSTOMIZER_CLASS = DefaultCustomizer.class;
    public static final String PROJECTTREE_VIEW_PROVIDER = "ProjectTreeViewProvider";
    public static final String SCRATCHPAD_VIEW_PROVIDER = "ScratchpadViewProvider";
    private static final String BEAN_PROPERTY_PRIORITY = "priority";
    private static final String DEFAULT_PREFERENCES_PAGE_ID = "preferences.infection.workbench";
    private static ToolComparator toolComparator = new ToolComparator();
    private static final Logger logger = Logger.getLogger(WorkbenchExtensions.class.getName());

    private WorkbenchExtensions() {
    }

    public static void actionObjectNew(BeansToolkit btk, Class beanClass, Constructor constr, Object[] params, TypeContext target, BeanTreeView projectView) {
        try {
            Object instance = constr.newInstance(params);
            if (instance == null) {
                return;
            }
            logger.fine("Adding new bean into bean-context: " + instance);
            if (!target.add(instance)) {
                throw new Exception("Unable to add object into context: " + instance);
            }
            Vector v = new Vector();
            v.add(instance);
        }
        catch (Exception e) {
            WorkbenchExtensions.handleError(e);
        }
    }

    public static void actionObjectNewOther(Workbench wb, ClassRegistry classRegistry, BeansToolkit btk, ProjectTreeView projectView, NewObjectDialog dialog, Icon icon, String tooltip) {
        try {
            TypeContext typeContext = WorkbenchExtensions.getSelectionTypeContext(projectView);
            logger.fine("Selection-TypeContext = " + typeContext);
            ConstructorView conv = new ConstructorView();
            conv.setBeansToolkit(btk);
            conv.setClassRegistry(btk.getClassRegistry());
            conv.setTitle("Constructor");
            conv.setIcon(icon);
            conv.setTooltip(tooltip);
            Perspective pers = wb.getPerspective();
            pers.addView(conv);
        }
        catch (Throwable e) {
            WorkbenchExtensions.handleError(e);
        }
    }

    protected static Tool[] getObjectCreateActions(Workbench wb, Collection objs) throws Exception {
        if (wb == null) {
            return null;
        }
        ArrayList<Object> tools = new ArrayList<Object>();
        Iterator iter = objs.iterator();
        if (iter.hasNext() && objs.size() == 1) {
            Platform platform = Platform.getInstance();
            WorkbenchPlugin plugin = (WorkbenchPlugin)platform.getPlugin("com.spacekiller.util.workbench.WorkbenchPlugin");
            Object obj = iter.next();
            if (obj != null) {
                List actions = plugin.getNewObjectActions(obj);
                Iterator i = actions.iterator();
                while (i.hasNext()) {
                    tools.add((Tool)i.next());
                }
            }
        }
        if (!tools.isEmpty()) {
            TSeparator sep = new TSeparator();
            tools.add(sep);
        }
        ObjectNewAction action = new ObjectNewAction();
        action.setText("Object...");
        action.setIcon(null);
        action.setTooltip("Create other object..");
        tools.add((Object)action);
        Tool[] rc = new Tool[tools.size()];
        rc = tools.toArray(rc);
        return rc;
    }

    public static void actionObjectOpen(Workbench wb, Collection beans) {
        logger.fine("DEBUG: actionObjectOpen: wb=" + wb + ", beans=" + beans);
        if (wb == null) {
            return;
        }
        if (beans == null) {
            return;
        }
        if (beans.isEmpty()) {
            return;
        }
        Object[] array = beans.toArray();
        if (array.length < 1) {
            return;
        }
        SimpleSelection sel = new SimpleSelection((Object)wb, array);
        DummySelectionToolContext context = new DummySelectionToolContext(wb, (Selection)sel);
        WorkbenchExtensions.actionObjectOpen(context);
    }

    public static void actionObjectOpen(SelectionToolContext stc) {
        if (stc == null) {
            logger.fine("DEBUG: actionObjectOpen: stc=" + stc);
            return;
        }
        SelectionManager sm = stc.getSelectionManager();
        if (sm == null) {
            logger.fine("DEBUG: actionObjectOpen: sm=" + sm);
            return;
        }
        Selection sel = sm.getSelection();
        if (sel == null) {
            logger.fine("DEBUG: actionObjectOpen: sel=" + sel);
            return;
        }
        Workbench wb = sm.getWorkbench();
        if (wb == null) {
            logger.fine("DEBUG: actionObjectOpen: wb=" + wb);
            return;
        }
        ArrayList list = new ArrayList();
        sel.getSelectedObjects(list);
        if (list.isEmpty()) {
            logger.fine("DEBUG: actionObjectOpen: empty selection: " + sel);
            return;
        }
        for (Object bean : list) {
            Tool tool;
            if (bean == null || (tool = WorkbenchExtensions.getObjectOpenAction(wb, bean)) == null) continue;
            if (tool instanceof TAction) {
                TAction action = (TAction)tool;
                Object instance = action.createInstance((ToolContext)stc);
                action.invoke(instance);
                return;
            }
            throw new RuntimeException("DEBUG open: bean=" + bean + ", tool=" + tool);
        }
    }

    public static void actionObjectOpen(Workbench wb, Class customizerClass, Object bean, BeanContext beanContextOfBean) throws Exception {
        Perspective pers = wb.getPerspective();
        BeansToolkit btk = wb.getBeansToolkit();
        Customizer custom = btk.getCustomizer(customizerClass);
        FeatureDescriptorFilter filter = null;
        ListSelectionListener listSelectionListener = null;
        BeanSelectionContext beanSelectionContext = null;
        BeanContextServicesSupport customContext = AbstractCustomizer.createCustomizerBeanContext((BeansToolkit)btk, filter, listSelectionListener, beanSelectionContext);
        customContext.add(custom);
        logger.fine("Trying to open '" + bean + "' in '" + beanContextOfBean + "' with '" + custom + "'");
        if (custom instanceof BeanEditor) {
            logger.fine("Customizer is a BeanEditor: setBeanContextOfBean = " + beanContextOfBean);
            BeanEditor be = (BeanEditor)custom;
            be.setBeansToolkit(btk);
            be.setBeanContextOfBean(beanContextOfBean);
            be.setBean(bean);
        } else {
            custom.setObject(bean);
        }
        String title = null;
        Icon icon = null;
        String tooltip = null;
        if (btk != null) {
            BeanDescriptor descr;
            BeanInfo info = btk.getBeanInfo(bean.getClass());
            if (info != null && (descr = info.getBeanDescriptor()) != null) {
                title = descr.getDisplayName();
                tooltip = descr.getShortDescription();
            }
            icon = btk.getIcon(bean);
            info = btk.getBeanInfo(custom.getClass());
            if (info != null && (descr = info.getBeanDescriptor()) != null) {
                if (title == null) {
                    title = descr.getDisplayName();
                }
                if (tooltip == null) {
                    tooltip = descr.getShortDescription();
                }
            }
            if (icon == null) {
                icon = btk.getIcon((Object)custom);
            }
        }
        if (title == null && (title = custom.toString()) == null) {
            title = custom.getClass().getName();
        }
        if (tooltip == null) {
            tooltip = custom.getClass().getName();
        }
        if (icon == null) {
            // empty if block
        }
        if (!(custom instanceof Component)) {
            throw new Exception("Unsupported Customizer: " + custom);
        }
        Component comp = (Component)((Object)custom);
        EditorView editor = new EditorView(comp);
        editor.setTitle(title);
        editor.setIcon(icon);
        editor.setTooltip(tooltip);
        pers.addView(editor);
    }

    public static void actionObjectOpenWith(Workbench wb, Selection sel, Class customizerClass) {
        if (wb == null) {
            logger.fine("DEBUG: actionObjectOpenWith: wb=" + wb);
            return;
        }
        if (sel == null) {
            logger.fine("DEBUG: actionObjectOpenWith: sel=" + sel);
            return;
        }
        int count = sel.getSelectionCount();
        if (count < 1) {
            logger.fine("DEBUG: actionObjectOpenWith: empty selection: " + sel);
            return;
        }
        for (int c = 0; c < count; ++c) {
            Object bean = sel.getSelectedObjectAt(c);
            if (bean == null) continue;
            try {
                BeanContext beanContextOfBean = null;
                if (bean instanceof BeanContextChild) {
                    beanContextOfBean = ((BeanContextChild)bean).getBeanContext();
                }
                WorkbenchExtensions.actionObjectOpen(wb, customizerClass, bean, beanContextOfBean);
                continue;
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static void actionObjectOpenWithOther(Workbench wb) {
        NewObjectDialog dialog = new NewObjectDialog();
        NewObjectPanel panel = dialog.getNewObjectPanel();
        BeansToolkit btk = wb.getBeansToolkit();
        ClassRegistry reg = btk.getClassRegistry();
        panel.setBeansToolkit(btk);
        panel.setClassRegistry(reg);
        boolean rc = dialog.showDialog();
        if (!rc) {
            return;
        }
        logger.fine("TODO actionObjectOpenWithOther");
    }

    protected static Tool[] getObjectOpenWithActions(Workbench wb, Collection objs) {
        TSeparator sep;
        Iterator i;
        Object obj;
        if (wb == null) {
            return null;
        }
        TreeSet<ObjectOpenWithAction> preferredTools = new TreeSet<ObjectOpenWithAction>(toolComparator);
        TreeSet<Object> normalTools = new TreeSet<Object>(toolComparator);
        TreeSet<ObjectOpenWithAction> defaultTools = new TreeSet<ObjectOpenWithAction>(toolComparator);
        TreeSet<ObjectOpenWithAction> expertTools = new TreeSet<ObjectOpenWithAction>(toolComparator);
        if (objs.size() == 1 && (obj = objs.iterator().next()) != null) {
            FileType[] fileTypes;
            FileTypeRegistry fileTypeRegistry;
            File file = null;
            if (obj instanceof File) {
                file = (File)obj;
            } else if (obj instanceof FileContext) {
                file = ((FileContext)obj).getFile();
            }
            if (file != null && (fileTypeRegistry = WorkbenchExtensions.getFileTypeRegistry()) != null && (fileTypes = fileTypeRegistry.getFileTypes(file)) != null) {
                for (int i2 = 0; i2 < fileTypes.length; ++i2) {
                    Iterator fileActions;
                    FileType fileType = fileTypes[i2];
                    if (fileType == null || (fileActions = fileType.getOpenWithActions(file)) == null) continue;
                    while (fileActions.hasNext()) {
                        Object actionObj = fileActions.next();
                        if (actionObj == null || !(actionObj instanceof Tool)) continue;
                        Tool tool = (Tool)actionObj;
                        normalTools.add(tool);
                    }
                }
            }
        }
        BeansToolkit btk = wb.getBeansToolkit();
        HashSet<Class> customizers = new HashSet<Class>();
        if (!objs.isEmpty() && btk != null) {
            boolean first = true;
            for (Object obj2 : objs) {
                Iterator i3 = btk.getCustomizerClasses(obj2);
                if (i3 == null) {
                    customizers.clear();
                    break;
                }
                if (first) {
                    first = false;
                    while (i3.hasNext()) {
                        Class customizerClass = (Class)i3.next();
                        customizers.add(customizerClass);
                    }
                    continue;
                }
                HashSet set2 = new HashSet();
                while (i3.hasNext()) {
                    set2.add(i3.next());
                }
                customizers.retainAll(set2);
            }
        }
        customizers.remove(DEFAULT_CUSTOMIZER_CLASS);
        ArrayList<Class> list = new ArrayList<Class>();
        list.addAll(customizers);
        list.add(DEFAULT_CUSTOMIZER_CLASS);
        int newCount = list.size();
        for (int c = 0; c < newCount; ++c) {
            Class customClass = (Class)list.get(c);
            Icon icon = null;
            String title = null;
            String tooltip = null;
            boolean preferred = false;
            boolean expert = false;
            double priority = 0.0;
            if (btk != null) {
                try {
                    BeanDescriptor descr;
                    icon = btk.getIcon(customClass);
                    BeanInfo info = btk.getBeanInfo(customClass);
                    if (info != null && (descr = info.getBeanDescriptor()) != null) {
                        Object objPriority;
                        title = descr.getDisplayName();
                        tooltip = descr.getShortDescription();
                        if (descr.isHidden()) continue;
                        if (descr.isPreferred()) {
                            preferred = true;
                        }
                        if (descr.isExpert()) {
                            expert = true;
                        }
                        if ((objPriority = descr.getValue(BEAN_PROPERTY_PRIORITY)) != null) {
                            try {
                                String strPriority = String.valueOf(objPriority).trim();
                                priority = Double.parseDouble(strPriority);
                            }
                            catch (NumberFormatException nfe) {}
                        }
                    }
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            if (title == null) {
                title = customClass.getName();
            }
            if (icon == null) {
                icon = null;
            }
            ObjectOpenWithAction action = new ObjectOpenWithAction();
            action.setCustomizerClass(customClass);
            action.setText(title);
            action.setIcon(icon);
            action.setTooltip(tooltip);
            action.setPriority(priority);
            if (customClass == DEFAULT_CUSTOMIZER_CLASS) {
                defaultTools.add(action);
                continue;
            }
            if (preferred) {
                preferredTools.add(action);
                continue;
            }
            if (expert) {
                expertTools.add(action);
                continue;
            }
            normalTools.add((Object)action);
        }
        LinkedList tools = new LinkedList();
        if (!preferredTools.isEmpty()) {
            i = preferredTools.iterator();
            while (i.hasNext()) {
                tools.add(i.next());
            }
        }
        if (!normalTools.isEmpty()) {
            i = normalTools.iterator();
            while (i.hasNext()) {
                tools.add(i.next());
            }
        }
        if (!expertTools.isEmpty()) {
            i = expertTools.iterator();
            while (i.hasNext()) {
                tools.add(i.next());
            }
        }
        if (!defaultTools.isEmpty()) {
            if (!tools.isEmpty()) {
                sep = new TSeparator();
                tools.add(sep);
            }
            i = defaultTools.iterator();
            while (i.hasNext()) {
                tools.add(i.next());
            }
        }
        if (!tools.isEmpty()) {
            sep = new TSeparator();
            tools.add(sep);
        }
        ObjectOpenWithAnotherAction action = new ObjectOpenWithAnotherAction();
        action.setText("Other...");
        action.setIcon(null);
        action.setTooltip("Choose another customizer..");
        tools.add(action);
        Tool[] rc = new Tool[tools.size()];
        rc = tools.toArray(rc);
        return rc;
    }

    protected static Tool getObjectOpenAction(Workbench wb, Object bean) {
        if (bean == null || wb == null) {
            return null;
        }
        ArrayList<Object> beans = new ArrayList<Object>();
        beans.add(bean);
        Tool[] tools = WorkbenchExtensions.getObjectOpenWithActions(wb, beans);
        if (tools == null) {
            return null;
        }
        if (tools.length < 1) {
            return null;
        }
        Tool tool = tools[0];
        return tool;
    }

    protected static Tool[] getObjectInvokeActions(Workbench wb, Collection objs) {
        if (objs == null || wb == null) {
            return null;
        }
        HashSet classes = new HashSet();
        for (Object o : objs) {
            if (o == null) continue;
            classes.add(o.getClass());
        }
        HashSet methods = new HashSet();
        Iterator i = classes.iterator();
        if (!i.hasNext()) {
            return null;
        }
        Class<?> clazz = (Class<?>)i.next();
        if (clazz == null) {
            return null;
        }
        try {
            WorkbenchExtensions.enumeratePreferredMethods(clazz, methods);
            HashSet temp = new HashSet();
            while (i.hasNext()) {
                clazz = (Class)i.next();
                temp.clear();
                WorkbenchExtensions.enumeratePreferredMethods(clazz, temp);
                methods.retainAll(temp);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        TreeMap<String, ObjectInvokeAction> actions = new TreeMap<String, ObjectInvokeAction>();
        for (Method meth : methods) {
            int paramCount;
            String methName = meth.getName();
            Class<?>[] paramTypes = meth.getParameterTypes();
            int n = paramCount = paramTypes == null ? 0 : paramTypes.length;
            clazz = meth.getDeclaringClass();
            if (clazz == Object.class || methName.equals("toString") && paramCount == 0 || methName.equals("hashCode") && paramCount == 0 || methName.equals("equals") && paramCount == 1 || methName.startsWith("get") && paramCount == 0 || methName.startsWith("is") && paramCount == 0 || methName.startsWith("set") && paramCount == 1) continue;
            ObjectInvokeAction action = (ObjectInvokeAction)((Object)actions.get(methName));
            if (action != null) {
                action.setMethod(null);
                continue;
            }
            String text = methName;
            if (paramCount > 0) {
                text = text + "...";
            }
            String tip = meth.toString();
            Icon icon = null;
            action = new ObjectInvokeAction(methName, meth);
            action.setText(text);
            action.setTooltip(tip);
            action.setIcon(icon);
            actions.put(methName, action);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(actions.values());
        if (!list.isEmpty()) {
            TSeparator sep = new TSeparator();
            list.add(sep);
        }
        ObjectInvokeAction oia = new ObjectInvokeAction(null, null);
        oia.setText("Method...");
        oia.setTooltip("Invoke other method...");
        list.add((Object)oia);
        Tool[] tools = new Tool[list.size()];
        tools = list.toArray(tools);
        return tools;
    }

    protected static void enumeratePreferredMethods(Class clazz, Set dstMethods) throws Exception {
        BeansToolkit btk = Platform.getInstance().getBeansToolkit();
        if (btk == null) {
            return;
        }
        BeanInfo info = btk.getBeanInfo(clazz);
        if (info == null) {
            return;
        }
        MethodDescriptor[] meths = info.getMethodDescriptors();
        if (meths == null) {
            return;
        }
        for (int i = 0; i < meths.length; ++i) {
            Method m;
            MethodDescriptor md = meths[i];
            if (md == null || !md.isPreferred() || (m = md.getMethod()) == null) continue;
            dstMethods.add(m);
        }
    }

    protected static void actionObjectInvoke(Workbench wb, String methodName, Method method) {
        Perspective pers = wb.getPerspective();
        if (pers == null) {
            return;
        }
        SelectionManager sm = wb.getSelectionManager();
        if (sm == null) {
            return;
        }
        Selection sel = sm.getSelection();
        if (sel == null) {
            return;
        }
        ArrayList objs = new ArrayList();
        sel.getSelectedObjects(objs);
        if (objs.isEmpty()) {
            return;
        }
        Object obj = objs.get(0);
        Class<?> clazz = obj.getClass();
        InvokeMethodPanel panel = new InvokeMethodPanel();
        panel.setPreferredSize(new Dimension(300, 300));
        panel.setBeansToolkit(wb.getBeansToolkit());
        panel.setType(clazz);
        panel.setObject(obj);
        if (method != null) {
            panel.setSelectedMethod(method);
        } else if (methodName != null) {
            panel.setSelectedMethodName(methodName);
        }
        ComponentView view = new ComponentView((Component)panel);
        view.setTitle("Invoke");
        view.setIcon(new ImageIcon(WorkbenchExtensions.class.getResource("/com/spacekiller/util/workbench/icons/invoke_method.gif")));
        pers.addView(view);
    }

    public static void actionObjectRemove(SelectionToolContext stc) {
        SelectionManager sm = stc.getSelectionManager();
        if (sm == null) {
            return;
        }
        Selection sel = sm.getSelection();
        if (sel == null) {
            return;
        }
        sel.removeSelectedObjects();
    }

    public static void actionObjectCopy(SelectionToolContext stc) {
        SelectionManager sm = stc.getSelectionManager();
        if (sm == null) {
            return;
        }
        Selection sel = sm.getSelection();
        if (sel == null) {
            return;
        }
        sel.copySelectedObjects();
    }

    public static void actionObjectCut(SelectionToolContext stc) {
        SelectionManager sm = stc.getSelectionManager();
        if (sm == null) {
            return;
        }
        Selection sel = sm.getSelection();
        if (sel == null) {
            return;
        }
        sel.cutSelectedObjects();
    }

    public static void actionObjectPaste(SelectionToolContext stc) {
        SelectionManager sm = stc.getSelectionManager();
        if (sm == null) {
            return;
        }
        Selection sel = sm.getSelection();
        if (sel == null) {
            return;
        }
        sel.pasteObjects();
    }

    public static void actionProjectClose(Workbench wb, ProjectTreeView projectView) {
        logger.fine("actionProjectClose: view=" + projectView);
        logger.fine("workbench: " + wb);
        if (projectView == null) {
            return;
        }
        ArrayList projects = new ArrayList();
        WorkbenchExtensions.getSelectedProjects(projectView, projects);
        logger.fine("Close projects: " + projects.size());
        if (projects.isEmpty()) {
            return;
        }
        wb.closeProjects(projects);
    }

    public static void actionProjectDelete(Workbench wb, ProjectTreeView projectView) {
        logger.fine("actionProjectDelete: view=" + projectView);
        logger.fine("workbench: " + wb);
        if (projectView == null) {
            return;
        }
        ArrayList projects = new ArrayList();
        WorkbenchExtensions.getSelectedProjects(projectView, projects);
        logger.fine("Delete projects: " + projects.size());
        if (projects.isEmpty()) {
            return;
        }
        try {
            wb.deleteProjects(projects);
        }
        catch (Exception e) {
            WorkbenchExtensions.handleError(e);
        }
    }

    public static void actionProjectNew(Workbench workbench, NewProjectDialog dialog) {
        try {
            Workspace workspace = workbench.getWorkspace();
            dialog.setWorkspace(workspace);
            boolean okay = dialog.showDialog();
            if (!okay) {
                return;
            }
            String projectName = dialog.getProjectName();
            String projectClassName = null;
            String projectTypeName = dialog.getProjectType().getName();
            Object projectPath = null;
            DefaultProjectReference newRef = new DefaultProjectReference(projectName, projectClassName, projectTypeName, projectPath);
            ProjectLoader loader = WorkbenchExtensions.createProjectLoader(workspace);
            Project newProject = loader.getProject((ProjectReference)newRef);
            WorkbenchExtensions.showProject(workbench, newProject);
        }
        catch (Exception e) {
            WorkbenchExtensions.handleError(e);
        }
    }

    public static void showProject(Workbench workbench, Project project) throws Exception {
        ProjectTreeView ptv = WorkbenchExtensions.getProjectTreeView(workbench);
        if (ptv == null && (ptv = WorkbenchExtensions.openProjectTreeView(workbench)) == null) {
            return;
        }
        final ProjectTreeView v = ptv;
        final Project p = project;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    v.setSelectedProject(p);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        });
    }

    public static ProjectTreeView openProjectTreeView(Workbench workbench) throws Exception {
        ProjectTreeViewProvider provider = (ProjectTreeViewProvider)workbench.getViewProvider(PROJECTTREE_VIEW_PROVIDER);
        ProjectTreeView ptv = (ProjectTreeView)provider.createView();
        if (ptv == null) {
            return null;
        }
        Workspace ws = workbench.getWorkspace();
        if (ws != null) {
            ptv.setRootContext((BeanContext)ws);
        }
        Perspective pers = workbench.getPerspective();
        pers.addView(ptv);
        return ptv;
    }

    public static ProjectTreeView getProjectTreeView(Workbench workbench) throws Exception {
        Perspective pers = workbench.getPerspective();
        if (pers == null) {
            return null;
        }
        for (View selectedView = pers.getSelectedView(); selectedView != null; selectedView = selectedView.getParent()) {
            if (!(selectedView instanceof ProjectTreeView)) continue;
            return (ProjectTreeView)selectedView;
        }
        int num = pers.getViewCount();
        for (int i = 0; i < num; ++i) {
            View v = pers.getViewAt(i);
            if (v == null || !(v instanceof ProjectTreeView)) continue;
            return (ProjectTreeView)v;
        }
        return null;
    }

    public static ProjectTreeView getSelectedProjectTreeView(Workbench workbench) throws Exception {
        Perspective pers = workbench.getPerspective();
        if (pers == null) {
            return null;
        }
        for (View selectedView = pers.getSelectedView(); selectedView != null; selectedView = selectedView.getParent()) {
            if (!(selectedView instanceof ProjectTreeView)) continue;
            return (ProjectTreeView)selectedView;
        }
        return null;
    }

    static ProjectLoader createProjectLoader(Workspace workspace) {
        ClassLoader projectClassLoader = ClassLoader.getSystemClassLoader();
        DefaultProjectLoader loader = new DefaultProjectLoader(workspace, projectClassLoader);
        return loader;
    }

    public static void enumerateSubClasses(ClassRegistry classRegistry, Class type, Collection dstClasses) {
        logger.fine(" - enumerateSubClasses -> ClassRegistry: " + classRegistry);
        Class[] subs = classRegistry.getSubClasses(type.getName());
        if (subs != null) {
            for (int c = 0; c < subs.length; ++c) {
                Class clazz = subs[c];
                if (clazz == null || dstClasses.contains(clazz)) continue;
                dstClasses.add(clazz);
            }
        }
    }

    public static BeanContext getBeanContext(TreePath path) {
        if (path != null) {
            for (int i = path.getPathCount() - 1; i >= 0; --i) {
                BeanTreeNode node;
                Object o = path.getPathComponent(i);
                if (o == null || !(o instanceof BeanTreeNode) || (o = (node = (BeanTreeNode)o).getBean()) == null || !(o instanceof BeanContext)) continue;
                return (BeanContext)o;
            }
        }
        return null;
    }

    public static void getSelectedProjects(ProjectTreeView projectView, Collection dstProjects) {
        Selection sel = projectView.getSelection();
        int count = sel.getSelectionCount();
        for (int c = 0; c < count; ++c) {
            BeanTreeNode beanNode;
            Object bean;
            Object treeNode;
            Object[] path;
            TreePath tp = sel.getSelectionPathAt(c);
            Object[] objectArray = path = tp == null ? null : tp.getPath();
            if (path == null || path.length != 2 || (treeNode = path[1]) == null || !(treeNode instanceof BeanTreeNode) || (bean = (beanNode = (BeanTreeNode)treeNode).getBean()) == null || !(bean instanceof Project)) continue;
            dstProjects.add(bean);
        }
    }

    public static TypeContext getSelectionTypeContext(ProjectTreeView projectView) {
        TypeContext rc = null;
        logger.fine("ProjectView: " + projectView);
        if (projectView == null) {
            return null;
        }
        Selection sel = projectView.getSelection();
        int count = sel.getSelectionCount();
        block0: for (int c = 0; c < count; ++c) {
            Object[] path = sel.getSelectionPathAt(c).getPath();
            if (path == null) continue;
            for (int i = path.length - 1; i >= 0; --i) {
                Object bean;
                BeanTreeNode node = (BeanTreeNode)path[i];
                if (node == null || (bean = node.getBean()) == null || !(bean instanceof TypeContext)) continue;
                if (rc == null) {
                    rc = (TypeContext)bean;
                    continue block0;
                }
                if (rc == bean) continue block0;
                return null;
            }
        }
        return rc;
    }

    private static void handleError(Throwable exception) {
        logger.log(Level.WARNING, "" + exception, exception);
        RuntimeContext rc = WorkbenchExtensions.getRuntimeContext();
        if (rc != null) {
            Object source = null;
            String message = exception.getMessage();
            if (message == null) {
                message = "" + exception;
            }
            rc.notifyError(source, exception);
        }
    }

    public static void actionProjectExport(Workbench workbench, Project[] projects, ExportProjectDialog dialog) {
        if (projects == null || projects.length < 1) {
            return;
        }
        Workspace workspace = workbench.getWorkspace();
        dialog.setWorkspace(workspace);
        boolean okay = dialog.showDialog();
        if (!okay) {
            return;
        }
        ProjectSource source = dialog.getProjectSource();
        ProjectReference ref = dialog.getProjectReference();
        if (source == null || ref == null) {
            return;
        }
        try {
            int num = projects.length;
            ProjectPersistence[] persistences = new ProjectPersistence[num];
            for (int c = 0; c < num; ++c) {
                Project project = projects[c];
                ProjectType projectType = project.getProjectType();
                if (projectType == null) {
                    throw new Exception("Invalid project type: " + projectType);
                }
                persistences[c] = projectType.annotateProject(project);
            }
            source.saveProjects(ref, persistences);
        }
        catch (Throwable e) {
            WorkbenchExtensions.handleError(e);
        }
    }

    public static void actionProjectImport(Workbench workbench, ImportProjectDialog dialog) {
        Workspace workspace = workbench.getWorkspace();
        dialog.setWorkspace(workspace);
        boolean okay = dialog.showDialog();
        if (!okay) {
            return;
        }
        ProjectSource source = dialog.getProjectSource();
        ProjectReference ref = dialog.getProjectReference();
        if (source == null || ref == null) {
            return;
        }
        try {
            ProjectLoader loader = WorkbenchExtensions.createProjectLoader(workspace);
            Project newProject = loader.getProject(ref);
            logger.fine("newProject=" + newProject);
        }
        catch (Throwable e) {
            WorkbenchExtensions.handleError(e);
        }
    }

    public static void actionProjectLoad(Workbench workbench, LoadProjectDialog dialog) {
        Workspace workspace = workbench.getWorkspace();
        dialog.setWorkspace(workspace);
        boolean okay = dialog.showDialog();
        if (!okay) {
            return;
        }
        ProjectReference[] refs = dialog.getSelectedProjects();
        if (refs == null || refs.length < 1) {
            return;
        }
        try {
            logger.fine("Loading projects: " + refs.length);
            ProjectLoader loader = WorkbenchExtensions.createProjectLoader(workspace);
            Project[] projects = loader.getProjects(refs, 0, refs.length);
            logger.fine("Projects: " + projects);
        }
        catch (Throwable e) {
            WorkbenchExtensions.handleError(e);
        }
    }

    public static void actionWorkbenchRefresh(Workbench wb) {
        try {
            logger.fine("Refresh: " + wb);
            Runtime.getRuntime().gc();
            if (wb != null) {
                wb.refresh();
            }
        }
        catch (Throwable e) {
            WorkbenchExtensions.handleError(e);
        }
    }

    public static void actionWorkspaceSwitch(Workbench wb) {
        try {
            wb.switchWorkspace();
        }
        catch (Throwable e) {
            WorkbenchExtensions.handleError(e);
        }
    }

    public static void actionProjectSave(Workbench wb) {
        try {
            Workspace ws = wb.getWorkspace();
            SyncManager sync = ws.getSyncManager();
            int count = sync.saveAll();
            RuntimeContext rc = WorkbenchExtensions.getRuntimeContext();
            if (rc != null) {
                Object source = null;
                String message = null;
                message = count > 0 ? "Saved changes: " + count : "No changes found";
                rc.notify(source, (Object)message);
            }
        }
        catch (Throwable e) {
            WorkbenchExtensions.handleError(e);
        }
    }

    public static void actionProjectSynchronize(Workbench wb) {
        try {
            Workspace ws = wb.getWorkspace();
            SyncManager syncMan = ws.getSyncManager();
            AllResyncManager resyncManager = new AllResyncManager(syncMan);
            Synchronization sync = resyncManager.resynchronize();
            int nChanges = sync.getChangeCount();
            int nUpdates = sync.getUpdateCount();
            int nConflicts = sync.getConflictCount();
            logger.fine("Number of changes:   " + nChanges);
            logger.fine("Number of updates:   " + nUpdates);
            logger.fine("Number of conflicts: " + nConflicts);
            int nTotal = nChanges + nUpdates + nConflicts;
            if (nTotal == 0) {
                RuntimeContext rc = WorkbenchExtensions.getRuntimeContext();
                if (rc != null) {
                    Object source = null;
                    String message = "No changes found";
                    rc.notify(source, (Object)message);
                }
                return;
            }
            SynchronizationView syncView = new SynchronizationView();
            syncView.setTitle("Synchronize");
            syncView.setTooltip("Synchronize changes with repository...");
            syncView.setIcon(new ImageIcon(WorkbenchExtensions.class.getResource("/com/spacekiller/util/workbench/icons/synchronize.gif")));
            BeansToolkit btk = wb.getBeansToolkit();
            FeatureDescriptorFilter_OnlyBeans filter = new FeatureDescriptorFilter_OnlyBeans();
            syncView.setBeansToolkit(btk);
            syncView.setFeatureDescriptorFilter(filter);
            syncView.setSyncManager(syncMan);
            syncView.setResyncManager(resyncManager);
            syncView.setSynchronization(sync);
            Perspective pers = wb.getPerspective();
            pers.addView(syncView);
        }
        catch (Throwable e) {
            WorkbenchExtensions.handleError(e);
        }
    }

    public static void actionProjectCommit(Workbench wb) {
        try {
            Workspace ws = wb.getWorkspace();
            SyncManager sync = ws.getSyncManager();
            sync.commit();
            RuntimeContext rc = WorkbenchExtensions.getRuntimeContext();
            if (rc != null) {
                Object source = null;
                String message = "Transaction committed";
                rc.notify(source, (Object)message);
            }
        }
        catch (Throwable e) {
            WorkbenchExtensions.handleError(e);
        }
    }

    public static void actionProjectUpdate(Workbench wb) {
        WorkbenchExtensions.actionProjectSynchronize(wb);
    }

    public static void actionProjectRollback(Workbench wb) {
        try {
            SavepointView view = new SavepointView();
            view.setTitle("Transaction");
            view.setTooltip("Commit/Rollback changes...");
            view.setIcon(new ImageIcon(WorkbenchExtensions.class.getResource("/com/spacekiller/util/workbench/icons/rollback.gif")));
            view.setWorkbench(wb);
            view.setWorkspace(wb.getWorkspace());
            Perspective pers = wb.getPerspective();
            pers.addView(view);
        }
        catch (Throwable e) {
            WorkbenchExtensions.handleError(e);
        }
    }

    public static void actionViewMaximize(Workbench wb) {
        Perspective pers = wb.getPerspective();
        if (pers == null) {
            return;
        }
        View view = pers.getSelectedView();
        if (view == null) {
            return;
        }
        pers.maximizeView(view);
    }

    public static void actionViewMinimize(Workbench wb) {
        Perspective pers = wb.getPerspective();
        if (pers == null) {
            return;
        }
        View view = pers.getSelectedView();
        if (view == null) {
            return;
        }
        pers.minimizeView(view);
    }

    public static void actionViewDetach(Workbench wb) {
        Perspective pers = wb.getPerspective();
        if (pers == null) {
            return;
        }
        View view = pers.getSelectedView();
        if (view == null) {
            return;
        }
        pers.detachView(view);
    }

    public static void actionViewRestore(Workbench wb) {
        Perspective pers = wb.getPerspective();
        if (pers == null) {
            return;
        }
        View view = pers.getSelectedView();
        if (view == null) {
            return;
        }
        pers.restoreView(view);
    }

    public static boolean actionViewClose(Workbench wb) throws Exception {
        Perspective pers = wb.getPerspective();
        if (pers == null) {
            return false;
        }
        View view = pers.getSelectedView();
        if (view == null) {
            return false;
        }
        if (!view.promptClose()) {
            return false;
        }
        view.close();
        return true;
    }

    public static void actionShowPreferences(Workbench wb) {
        try {
            PreferencesView prefView = new PreferencesView();
            prefView.setName("Preferences");
            prefView.setTitle("Preferences");
            prefView.setTooltip("Preferences");
            prefView.setIcon(Tools.getIcon(WorkbenchExtensions.class, (String)"/com/spacekiller/util/workbench/icons/preferences_view.gif"));
            prefView.setSelectedPreferencesPageId(DEFAULT_PREFERENCES_PAGE_ID);
            logger.fine("Open PreferencesView: " + prefView);
            Perspective pers = wb.getPerspective();
            pers.addView(prefView);
        }
        catch (Exception e) {
            WorkbenchExtensions.handleError(e);
        }
    }

    protected static RuntimeContext getRuntimeContext() {
        return Platform.getInstance().getRuntimeContext();
    }

    protected static FileTypeRegistry getFileTypeRegistry() {
        Platform plat = Platform.getInstance();
        if (plat != null) {
            return plat.getFileTypeRegistry();
        }
        return null;
    }

    public static ScratchpadView getDefaultScratchpadView(Workbench wb) throws Exception {
        Perspective pers = wb.getPerspective();
        if (pers == null) {
            return null;
        }
        int num = pers.getViewCount();
        for (int c = 0; c < num; ++c) {
            View v = pers.getViewAt(c);
            if (v == null || !(v instanceof ScratchpadView)) continue;
            return (ScratchpadView)v;
        }
        WorkbenchPlugin plugin = WorkbenchUtilities.getWorkbenchPlugin();
        ViewProvider vp = plugin.getViewProvider(SCRATCHPAD_VIEW_PROVIDER);
        if (vp == null) {
            return null;
        }
        ScratchpadViewProvider provider = (ScratchpadViewProvider)vp;
        View newView = provider.createView();
        pers.addView(newView);
        return (ScratchpadView)newView;
    }

    public static ScratchpadView getDefaultScratchpadView(Perspective pers) throws Exception {
        Workbench wb = pers.getWorkbench();
        if (wb == null) {
            return null;
        }
        return WorkbenchExtensions.getDefaultScratchpadView(wb);
    }

    public static void actionTextWizard(Workbench wb, ClassRegistry classRegistry, BeansToolkit btk, Icon icon, String tooltip) {
        TextWizardView view = new TextWizardView();
        view.setTitle("Text Wizard");
        view.setIcon(icon);
        view.setTooltip(tooltip);
        Perspective pers = wb.getPerspective();
        pers.addView(view);
    }

    public static void actionCollectionWizard(Workbench wb, ClassRegistry classRegistry, BeansToolkit btk, Icon icon, String tooltip) {
        ConstructorView conv = new ConstructorView();
        conv.setBeansToolkit(btk);
        conv.setClassRegistry(classRegistry);
        conv.setTitle("New Collection");
        conv.setIcon(icon);
        conv.setTooltip(tooltip);
        conv.setEmptySearchAction(ClassChooser.EMPTY_SEARCH_ALL);
        conv.setClassFilter(new TypeClassFilter(classRegistry, Collection.class.getName()));
        conv.refresh();
        Perspective pers = wb.getPerspective();
        pers.addView(conv);
    }

    public static void actionMapWizard(Workbench wb, ClassRegistry classRegistry, BeansToolkit btk, Icon icon, String tooltip) {
        ConstructorView conv = new ConstructorView();
        conv.setBeansToolkit(btk);
        conv.setClassRegistry(classRegistry);
        conv.setTitle("Create Map");
        conv.setIcon(icon);
        conv.setTooltip(tooltip);
        conv.setEmptySearchAction(ClassChooser.EMPTY_SEARCH_ALL);
        conv.setClassFilter(new TypeClassFilter(classRegistry, Map.class.getName()));
        conv.refresh();
        Perspective pers = wb.getPerspective();
        pers.addView(conv);
    }

    public static void actionArrayWizard(Workbench wb, ClassRegistry classRegistry, BeansToolkit btk, Icon icon, String tooltip) {
        ArrayConstructorView conv = new ArrayConstructorView();
        conv.setBeansToolkit(btk);
        conv.setClassRegistry(classRegistry);
        conv.setTitle("Create Array");
        conv.setIcon(icon);
        conv.setTooltip(tooltip);
        conv.setEmptySearchAction(ClassChooser.EMPTY_SEARCH_ALL);
        conv.setClassFilter(null);
        conv.refresh();
        Perspective pers = wb.getPerspective();
        pers.addView(conv);
    }

    protected static class AllResyncManager
    implements ResyncManager {
        private SyncManager syncManager;

        public AllResyncManager(SyncManager syncManager) {
            this.syncManager = syncManager;
        }

        public Synchronization resynchronize() throws Exception {
            return this.syncManager.synchronizeAll();
        }
    }

    public static class ToolComparator
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            double p1;
            Tool t0 = (Tool)arg0;
            Tool t1 = (Tool)arg1;
            if (t0 == t1) {
                return 0;
            }
            double p0 = t0.getPriority();
            if (p0 != (p1 = t1.getPriority())) {
                return p0 < p1 ? 1 : -1;
            }
            String text0 = t0.getText();
            String text1 = t1.getText();
            if (text0 == null) {
                return -1;
            }
            if (text1 == null) {
                return 1;
            }
            return text0.compareToIgnoreCase(text1);
        }
    }

    public static class TypeClassFilter
    implements Filter {
        private ClassRegistry reg;
        private String typeName;

        public TypeClassFilter(ClassRegistry reg, String typeName) {
            this.reg = reg;
            this.typeName = typeName;
        }

        public boolean accept(Object o) {
            ClassDescriptor cd = (ClassDescriptor)o;
            if (cd.isInterface()) {
                return false;
            }
            if (cd.isAbstract()) {
                return false;
            }
            return this.reg.isTypeAssignableFrom(this.typeName, cd);
        }
    }

    public static class PerspectiveChooserTool
    extends AbstractTool {
        public Object createInstance(ToolContext context, Class type) {
            try {
                Workbench wb = null;
                if (context != null && context instanceof WorkbenchToolContext) {
                    WorkbenchToolContext wtc = (WorkbenchToolContext)context;
                    wb = wtc.getWorkbench();
                }
                JPanel rc = new JPanel();
                rc.setOpaque(false);
                rc.setLayout(new GridBagLayout());
                PerspectiveChooser chooser = new PerspectiveChooser();
                chooser.initPerspectiveChooser();
                chooser.setWorkbench(wb);
                chooser.setOpaque(false);
                chooser.setToolTipText("Switch perspective..");
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.fill = 0;
                gbc.anchor = 14;
                gbc.weightx = 1.0;
                rc.add((Component)chooser, gbc);
                return rc;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected void refreshInstance(Object instance) {
        }
    }

    public static class TestBeanTreeComparator
    extends DefaultBeanTreeComparator {
        public TestBeanTreeComparator() {
            this.setRootComparator(new BeanComparatorIgnoreCase());
        }
    }

    public static class TestComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            return String.valueOf(b).toLowerCase().compareTo(String.valueOf(a).toLowerCase());
        }
    }

    public static class BeanComparatorIgnoreCase
    implements Comparator {
        public int compare(Object a, Object b) {
            return String.valueOf(a).toLowerCase().compareTo(String.valueOf(b).toLowerCase());
        }
    }

    public static class BeanComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            return String.valueOf(a).compareTo(String.valueOf(b));
        }
    }

    public static class FeatureDescriptorFilter_OnlyBeans
    implements FeatureDescriptorFilter {
        DefaultFeatureDescriptorFilter filter = new DefaultFeatureDescriptorFilter(false, false, false, true, true, true);

        public boolean accept(BeanInfo info, FeatureDescriptor feature) {
            return this.filter.accept(info, feature);
        }
    }

    public static class FeatureDescriptorFilter_Default
    implements FeatureDescriptorFilter {
        private DefaultBeanFeatureFilter filter = new DefaultBeanFeatureFilter((FeatureDescriptorFilter)new DefaultFeatureNameFilter(new String[]{"class"}), (FeatureDescriptorFilter)new DefaultFeatureDescriptorFilter(true, false, false, true, true, true));

        public FeatureDescriptorFilter_Default() {
            this.filter.excludeAllFeaturesOf(String.class);
            this.filter.excludeAllFeaturesOfPrimitiveTypes();
        }

        public boolean accept(BeanInfo info, FeatureDescriptor feature) {
            return this.filter.accept(info, feature);
        }
    }

    public static class ArrayWizardAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                ClassRegistry classRegistry = this.getClassRegistry(instance);
                BeansToolkit btk = this.getBeansToolkit(instance);
                WorkbenchExtensions.actionArrayWizard(wb, classRegistry, btk, this.getIcon(), this.getTooltip());
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class MapWizardAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                ClassRegistry classRegistry = this.getClassRegistry(instance);
                BeansToolkit btk = this.getBeansToolkit(instance);
                WorkbenchExtensions.actionMapWizard(wb, classRegistry, btk, this.getIcon(), this.getTooltip());
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class CollectionWizardAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                ClassRegistry classRegistry = this.getClassRegistry(instance);
                BeansToolkit btk = this.getBeansToolkit(instance);
                WorkbenchExtensions.actionCollectionWizard(wb, classRegistry, btk, this.getIcon(), this.getTooltip());
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class TextWizardAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                ClassRegistry classRegistry = this.getClassRegistry(instance);
                BeansToolkit btk = this.getBeansToolkit(instance);
                WorkbenchExtensions.actionTextWizard(wb, classRegistry, btk, this.getIcon(), this.getTooltip());
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class PreferencesAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                WorkbenchExtensions.actionShowPreferences(wb);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ViewCloseAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                WorkbenchExtensions.actionViewClose(wb);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ViewRestoreAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                WorkbenchExtensions.actionViewRestore(wb);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ViewDetachAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                WorkbenchExtensions.actionViewDetach(wb);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ViewMinimizeAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                WorkbenchExtensions.actionViewMinimize(wb);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ViewMaximizeAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                WorkbenchExtensions.actionViewMaximize(wb);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ObjectPasteAction
    extends SelectionToolContextAction.PasteSupportedAction {
        public void invoke(Object instance) {
            try {
                ToolContext tc = this.getToolContext(instance);
                SelectionToolContext stc = (SelectionToolContext)tc;
                WorkbenchExtensions.actionObjectPaste(stc);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ObjectRemoveAction
    extends SelectionToolContextAction.ObjectsSelectedAction {
        public void invoke(Object instance) {
            try {
                ToolContext tc = this.getToolContext(instance);
                SelectionToolContext stc = (SelectionToolContext)tc;
                WorkbenchExtensions.actionObjectRemove(stc);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ObjectCutAction
    extends SelectionToolContextAction.ObjectsSelectedAction {
        public void invoke(Object instance) {
            try {
                ToolContext tc = this.getToolContext(instance);
                SelectionToolContext stc = (SelectionToolContext)tc;
                WorkbenchExtensions.actionObjectCut(stc);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ObjectCopyAction
    extends SelectionToolContextAction.ObjectsSelectedAction {
        public void invoke(Object instance) {
            try {
                ToolContext tc = this.getToolContext(instance);
                SelectionToolContext stc = (SelectionToolContext)tc;
                WorkbenchExtensions.actionObjectCopy(stc);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class RedoAction
    extends WorkbenchAction {
        private Map instanceWorkbenchMap = new HashMap();
        private UndoableEditListener listener = new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                RedoAction.this.refresh();
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void refreshInstance(Object instance) {
            UndoManager undoManager;
            super.refreshInstance(instance);
            if (!(instance instanceof JComponent)) {
                return;
            }
            JComponent comp = (JComponent)instance;
            boolean enabled = false;
            Workbench wb = this.getWorkbench(instance);
            if (wb != null && (undoManager = wb.getUndoManager()) != null) {
                enabled = undoManager.canRedo();
            }
            comp.setEnabled(enabled);
            Map map = this.instanceWorkbenchMap;
            synchronized (map) {
                Workbench old = (Workbench)this.instanceWorkbenchMap.get(instance);
                if (wb != old) {
                    if (old != null) {
                        old.removeUndoableEditListener(this.listener);
                    }
                    if (wb != null) {
                        this.instanceWorkbenchMap.put(instance, wb);
                        wb.addUndoableEditListener(this.listener);
                    } else {
                        this.instanceWorkbenchMap.remove(instance);
                    }
                }
            }
        }

        public void invoke(Object instance) {
            UndoManager undoManager;
            Workbench wb = this.getWorkbench(instance);
            if (wb != null && (undoManager = wb.getUndoManager()) != null && undoManager.canRedo()) {
                undoManager.redo();
            }
        }
    }

    public static class UndoAction
    extends WorkbenchAction {
        private Map instanceWorkbenchMap = new HashMap();
        private UndoableEditListener listener = new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                UndoAction.this.refresh();
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void refreshInstance(Object instance) {
            UndoManager undoManager;
            super.refreshInstance(instance);
            if (!(instance instanceof JComponent)) {
                return;
            }
            JComponent comp = (JComponent)instance;
            boolean enabled = false;
            Workbench wb = this.getWorkbench(instance);
            if (wb != null && (undoManager = wb.getUndoManager()) != null) {
                enabled = undoManager.canUndo();
            }
            comp.setEnabled(enabled);
            Map map = this.instanceWorkbenchMap;
            synchronized (map) {
                Workbench old = (Workbench)this.instanceWorkbenchMap.get(instance);
                if (wb != old) {
                    if (old != null) {
                        old.removeUndoableEditListener(this.listener);
                    }
                    if (wb != null) {
                        this.instanceWorkbenchMap.put(instance, wb);
                        wb.addUndoableEditListener(this.listener);
                    } else {
                        this.instanceWorkbenchMap.remove(instance);
                    }
                }
            }
        }

        public void invoke(Object instance) {
            UndoManager undoManager;
            Workbench wb = this.getWorkbench(instance);
            if (wb != null && (undoManager = wb.getUndoManager()) != null && undoManager.canUndo()) {
                undoManager.undo();
            }
        }
    }

    public static class ObjectInvokeAction
    extends WorkbenchAction {
        private String methodName;
        private Method method;

        public ObjectInvokeAction(String methodName, Method method) {
            this.methodName = methodName;
            this.method = method;
        }

        public void invoke(Object instance) {
            try {
                WorkbenchExtensions.actionObjectInvoke(this.getWorkbench(instance), this.methodName, this.method);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }
    }

    public static class ObjectOpenWithAnotherAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                WorkbenchExtensions.actionObjectOpenWithOther(this.getWorkbench(instance));
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ObjectOpenWithAction
    extends WorkbenchAction {
        private Class customizerClass;

        protected ObjectOpenWithAction() {
        }

        public ObjectOpenWithAction(Class customizerClass) {
            this.setCustomizerClass(customizerClass);
        }

        public void invoke(Object instance) {
            try {
                ToolContext tc = this.getToolContext(instance);
                if (tc != null) {
                    SelectionToolContext stc = (SelectionToolContext)tc;
                    SelectionManager sm = stc.getSelectionManager();
                    if (sm != null) {
                        Selection sel = sm.getSelection();
                        if (sel != null) {
                            Workbench wb = sm.getWorkbench();
                            WorkbenchExtensions.actionObjectOpenWith(wb, sel, this.customizerClass);
                            return;
                        }
                        Sys.println((String)("DEBUG: sel=" + sel));
                    }
                    Sys.println((String)("DEBUG: sm=" + sm));
                }
                Sys.println((String)("DEBUG: tc=" + tc));
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }

        public Class getCustomizerClass() {
            return this.customizerClass;
        }

        protected void setCustomizerClass(Class customizerClass) {
            this.customizerClass = customizerClass;
        }
    }

    public static class ObjectOpenAction
    extends SelectionToolContextAction.ObjectsSelectedAction {
        public void invoke(Object instance) {
            try {
                ToolContext tc = this.getToolContext(instance);
                SelectionToolContext stc = (SelectionToolContext)tc;
                WorkbenchExtensions.actionObjectOpen(stc);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ObjectNewAction
    extends WorkbenchAction {
        private NewObjectDialog dialog = null;

        public void invoke(Object instance) {
            try {
                if (this.dialog == null) {
                    this.dialog = new NewObjectDialog();
                }
                Workbench wb = this.getWorkbench(instance);
                ClassRegistry classRegistry = this.getClassRegistry(instance);
                BeansToolkit btk = this.getBeansToolkit(instance);
                ProjectTreeView projectView = WorkbenchExtensions.getSelectedProjectTreeView(wb);
                WorkbenchExtensions.actionObjectNewOther(wb, classRegistry, btk, projectView, this.dialog, this.getIcon(), this.getTooltip());
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class WorkspaceSwitchAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                WorkbenchExtensions.actionWorkspaceSwitch(wb);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class WorkbenchRefreshAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                WorkbenchExtensions.actionWorkbenchRefresh(wb);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ProjectUpdateAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                WorkbenchExtensions.actionProjectUpdate(wb);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ProjectSynchronizeAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                WorkbenchExtensions.actionProjectSynchronize(wb);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ProjectRollbackAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                WorkbenchExtensions.actionProjectRollback(wb);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ProjectCommitAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                WorkbenchExtensions.actionProjectCommit(wb);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ProjectSaveAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                WorkbenchExtensions.actionProjectSave(wb);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ProjectDeleteAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                ProjectTreeView pv = WorkbenchExtensions.getSelectedProjectTreeView(wb);
                WorkbenchExtensions.actionProjectDelete(wb, pv);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ProjectCloseAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Workbench wb = this.getWorkbench(instance);
                ProjectTreeView pv = WorkbenchExtensions.getSelectedProjectTreeView(wb);
                WorkbenchExtensions.actionProjectClose(wb, pv);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ProjectExportAction
    extends WorkbenchAction {
        private ExportProjectDialog dialog;

        public void invoke(Object instance) {
            try {
                if (this.dialog == null) {
                    this.dialog = new ExportProjectDialog();
                }
                Workbench wb = this.getWorkbench(instance);
                ProjectTreeView projectView = WorkbenchExtensions.getSelectedProjectTreeView(wb);
                ArrayList list = new ArrayList();
                WorkbenchExtensions.getSelectedProjects(projectView, list);
                if (list.isEmpty()) {
                    return;
                }
                Project[] projects = new Project[list.size()];
                projects = list.toArray(projects);
                WorkbenchExtensions.actionProjectExport(wb, projects, this.dialog);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ProjectImportAction
    extends WorkbenchAction {
        private ImportProjectDialog dialog;

        public void invoke(Object instance) {
            try {
                if (this.dialog == null) {
                    this.dialog = new ImportProjectDialog();
                }
                Workbench wb = this.getWorkbench(instance);
                WorkbenchExtensions.actionProjectImport(wb, this.dialog);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ProjectLoadAction
    extends WorkbenchAction {
        private LoadProjectDialog dialog;

        public void invoke(Object instance) {
            try {
                if (this.dialog == null) {
                    this.dialog = new LoadProjectDialog();
                }
                Workbench wb = this.getWorkbench(instance);
                WorkbenchExtensions.actionProjectLoad(wb, this.dialog);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }

    public static class ProjectNewAction
    extends WorkbenchAction {
        private NewProjectDialog dialog = null;

        public void invoke(Object instance) {
            try {
                if (this.dialog == null) {
                    this.dialog = new NewProjectDialog();
                }
                Workbench wb = this.getWorkbench(instance);
                WorkbenchExtensions.actionProjectNew(wb, this.dialog);
            }
            catch (Exception e) {
                WorkbenchExtensions.handleError(e);
            }
        }
    }
}

