/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.beans.Selectable;
import com.spacekiller.util.beans.Selection;
import com.spacekiller.util.workbench.AbstractSelectionManager;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewFocusCondition;
import com.spacekiller.util.workbench.ViewFocusEvent;
import com.spacekiller.util.workbench.ViewFocusListener;
import com.spacekiller.util.workbench.ViewProvider;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchListener;
import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class WorkbenchSelectionManager
extends AbstractSelectionManager {
    private Workbench workbench;
    private Perspective perspective;
    private View view;
    private WorkbenchHandler workbenchHandler = new WorkbenchHandler();
    private ViewFocusHandler viewFocusHandler = new ViewFocusHandler();
    private Set viewFocusConditions = new HashSet();

    public WorkbenchSelectionManager(Workbench wb) {
        this.setWorkbench(wb);
    }

    @Override
    public Workbench getWorkbench() {
        return this.workbench;
    }

    protected synchronized void setWorkbench(Workbench wb) {
        if (this.workbench == wb) {
            return;
        }
        if (this.workbench != null) {
            this.workbench.removeWorkbenchListener(this.workbenchHandler);
        }
        this.workbench = wb;
        Perspective pers = null;
        if (this.workbench != null) {
            this.workbench.addWorkbenchListener(this.workbenchHandler);
            pers = this.workbench.getPerspective();
        }
        this.setPerspective(pers);
    }

    @Override
    public Perspective getPerspective() {
        return this.perspective;
    }

    protected synchronized void setPerspective(Perspective pers) {
        if (this.perspective == pers) {
            return;
        }
        if (this.perspective != null) {
            this.perspective.removeViewFocusListener(this.viewFocusHandler);
        }
        this.perspective = pers;
        if (this.perspective != null) {
            this.perspective.addViewFocusListener(this.viewFocusHandler);
        }
    }

    @Override
    public View getView() {
        return this.view;
    }

    protected void setView(View v) {
        if (this.view == v) {
            return;
        }
        this.view = v;
        this.fireViewFocusChanged();
    }

    @Override
    public void addViewFocusCondition(ViewFocusCondition condition) {
        if (condition == null) {
            return;
        }
        this.viewFocusConditions.add(condition);
        condition.viewFocusChanged(this.view);
    }

    @Override
    public void removeViewFocusCondition(ViewFocusCondition condition) {
        this.viewFocusConditions.remove((Object)condition);
    }

    protected synchronized void fireViewFocusChanged() {
        View v = this.view;
        Iterator i = this.viewFocusConditions.iterator();
        while (i.hasNext()) {
            ((ViewFocusCondition)((Object)i.next())).viewFocusChanged(v);
        }
    }

    protected class ViewFocusHandler
    implements ViewFocusListener {
        protected ViewFocusHandler() {
        }

        @Override
        public void viewFocusChanged(ViewFocusEvent e) {
            Component c = e.getComponent();
            View v = e.getView();
            if (v != null && v.getParent() == null) {
                v = null;
            }
            Selection sel = null;
            for (Component x = c; x != null; x = x.getParent()) {
                if (!(x instanceof Selectable)) continue;
                sel = ((Selectable)x).getSelection();
                break;
            }
            if (sel == null && v != null && v instanceof Selectable) {
                sel = ((Selectable)v).getSelection();
            }
            WorkbenchSelectionManager.this.setView(v);
            WorkbenchSelectionManager.this.setSelection(sel);
        }
    }

    protected class WorkbenchHandler
    implements WorkbenchListener {
        protected WorkbenchHandler() {
        }

        @Override
        public void perspectiveActivated(Perspective p) {
            WorkbenchSelectionManager.this.setPerspective(p);
        }

        @Override
        public void perspectiveDeactivated(Perspective p) {
            if (p == WorkbenchSelectionManager.this.perspective) {
                WorkbenchSelectionManager.this.setPerspective(null);
            }
        }

        @Override
        public void perspectiveAdded(Perspective p) {
        }

        @Override
        public void perspectiveClosed(Perspective p) {
        }

        @Override
        public void perspectiveOpened(Perspective p) {
        }

        @Override
        public void perspectiveRemoved(Perspective p) {
        }

        @Override
        public void viewProviderAdded(ViewProvider vp) {
        }

        @Override
        public void viewProviderRemoved(ViewProvider vp) {
        }
    }
}

