/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.workbench.Workbench;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class WorkbenchUndoManager
extends UndoManager {
    private static final long serialVersionUID = -1787245729665531234L;
    private static final Logger logger = Logger.getLogger(WorkbenchUndoManager.class.getName());
    private final EventListenerList undoableEditListeners = new EventListenerList();
    private Workbench workbench;

    protected WorkbenchUndoManager() {
    }

    public WorkbenchUndoManager(Workbench workbench) {
        this();
        this.setWorkbench(workbench);
    }

    protected Workbench getWorkbench() {
        return this.workbench;
    }

    protected void setWorkbench(Workbench workbench) {
        this.workbench = workbench;
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit anEdit) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("addEdit: " + anEdit);
        }
        if (super.addEdit(anEdit)) {
            this.fireUndoableEditHappened(anEdit);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void undoTo(UndoableEdit edit) throws CannotUndoException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("undoTo: " + edit);
        }
        try {
            super.undoTo(edit);
        }
        finally {
            Workbench wb = this.getWorkbench();
            if (wb != null) {
                wb.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void redoTo(UndoableEdit edit) throws CannotRedoException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("redoTo: " + edit);
        }
        try {
            super.redoTo(edit);
        }
        finally {
            Workbench wb = this.getWorkbench();
            if (wb != null) {
                wb.refresh();
            }
        }
    }

    protected synchronized void addUndoableEditListener(UndoableEditListener l) {
        this.undoableEditListeners.add(UndoableEditListener.class, l);
    }

    protected synchronized void removeUndoableEditListener(UndoableEditListener l) {
        this.undoableEditListeners.remove(UndoableEditListener.class, l);
    }

    protected synchronized void fireUndoableEditHappened(UndoableEdit edit) {
        Object[] ll = this.undoableEditListeners.getListenerList();
        if (ll.length > 0) {
            UndoableEditEvent ev = new UndoableEditEvent(this, edit);
            for (int c = 1; c < ll.length; c += 2) {
                ((UndoableEditListener)ll[c]).undoableEditHappened(ev);
            }
        }
    }
}

