/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Platform;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewProvider;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchContainer;
import com.spacekiller.util.workbench.WorkbenchPlugin;
import com.spacekiller.util.workspace.WorkspacePlugin;
import com.spacekiller.util.workspace.WorkspaceUtilities;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.JPopupMenu;

public final class WorkbenchUtilities {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final Iterator EMPTY_ITERATOR = new Iterator(){

        public Object next() {
            return null;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void remove() {
        }
    };

    private WorkbenchUtilities() {
    }

    public static WorkbenchPlugin getWorkbenchPlugin() throws Exception {
        return (WorkbenchPlugin)Platform.getInstance().getPlugin("com.spacekiller.util.workbench.WorkbenchPlugin");
    }

    public static WorkspacePlugin getWorkspacePlugin() throws Exception {
        return WorkspaceUtilities.getWorkspacePlugin();
    }

    public static Workbench getWorkbench(Component component) {
        Component comp = component;
        while (comp != null) {
            JPopupMenu popup;
            WorkbenchContainer ww;
            Workbench wb;
            if (comp instanceof WorkbenchContainer && (wb = (ww = (WorkbenchContainer)((Object)comp)).getWorkbench()) != null) {
                return wb;
            }
            if (comp instanceof JPopupMenu && (popup = (JPopupMenu)comp).getParent() == null) {
                comp = popup.getInvoker();
                continue;
            }
            comp = comp.getParent();
        }
        return null;
    }

    public static Class getCustomizerClass(BeansToolkit btk, Object bean) {
        Iterator i = WorkbenchUtilities.getCustomizerClasses(btk, bean);
        if (i != null && i.hasNext()) {
            return (Class)i.next();
        }
        return null;
    }

    public static Iterator getCustomizerClasses(BeansToolkit btk, Object bean) {
        Iterator i = btk.getCustomizerClasses(bean);
        if (i != null && i.hasNext()) {
            return i;
        }
        return null;
    }

    public static View openView(Workbench wb, String viewProviderId) throws Exception {
        return WorkbenchUtilities.openView(wb, viewProviderId, true);
    }

    public static View openView(Workbench wb, String viewProviderId, boolean newInstance) throws Exception {
        WorkbenchPlugin plugin = WorkbenchUtilities.getWorkbenchPlugin();
        if (plugin == null) {
            return null;
        }
        ViewProvider vp = plugin.getViewProvider(viewProviderId);
        if (vp == null) {
            return null;
        }
        return WorkbenchUtilities.openView(wb, vp, newInstance);
    }

    public static View openView(Workbench wb, ViewProvider provider) throws Exception {
        return WorkbenchUtilities.openView(wb, provider, true);
    }

    public static View openView(Workbench wb, ViewProvider provider, boolean newInstance) throws Exception {
        View view;
        if (provider == null) {
            return null;
        }
        if (wb == null) {
            return null;
        }
        Perspective pers = wb.getPerspective();
        if (pers == null) {
            return null;
        }
        if (!newInstance && (view = pers.getViewOfProvider(provider)) != null) {
            pers.toFront(view);
            return view;
        }
        view = provider.createView();
        if (view != null) {
            pers.addView(view);
        }
        return view;
    }
}

