/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.render;

import java.awt.image.BufferedImage;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;

public class BufferedImagePool {
    private Entry first;
    private Entry last;
    private int size;

    public int size() {
        return this.size;
    }

    public synchronized BufferedImage getBufferedImage(int minWidth, int minHeight, int type) {
        Entry entry = this.first;
        while (entry != null) {
            Entry next = entry.next;
            BufferedImage bi = entry.reference.get();
            if (bi == null) {
                this.delEntry(entry);
            } else if (bi.getType() == type && bi.getWidth() >= minWidth && bi.getHeight() >= minHeight) {
                this.delEntry(entry);
                return bi;
            }
            entry = next;
        }
        return null;
    }

    public synchronized void putBufferedImage(BufferedImage image) {
        if (image == null) {
            return;
        }
        Entry entry = new Entry();
        entry.reference = new SoftReference<BufferedImage>(image);
        this.addEntry(entry);
    }

    public synchronized void clear() {
        Entry entry = this.first;
        while (entry != null) {
            Entry next = entry.next;
            BufferedImage bi = entry.reference.get();
            if (bi != null) {
                bi.flush();
            }
            this.delEntry(entry);
            entry = next;
        }
    }

    private void addEntry(Entry entry) {
        entry.prev = null;
        entry.next = this.first;
        if (this.first == null) {
            this.last = entry;
        } else {
            this.first.prev = entry;
        }
        this.first = entry;
        ++this.size;
    }

    private void delEntry(Entry entry) {
        if (entry.prev == null) {
            this.first = entry.next;
        } else {
            entry.prev.next = entry.next;
        }
        if (entry.next == null) {
            this.last = entry.prev;
        } else {
            entry.next.prev = entry.prev;
        }
        --this.size;
    }

    protected Entry first() {
        return this.first;
    }

    protected Entry last() {
        return this.last;
    }

    protected static class Entry {
        protected Entry prev;
        protected Entry next;
        protected Reference<BufferedImage> reference;

        protected Entry() {
        }
    }
}

