/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.render;

import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CharIterator
implements AttributedCharacterIterator {
    private static final String MIN_LONG_STR = Long.toString(Long.MIN_VALUE);
    private static final char[] MIN_LONG = MIN_LONG_STR.toCharArray();
    private static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private char[] arr;
    private int idx;
    private int ofs;
    private int end;
    private Map attrs;

    public CharIterator(char[] arr) {
        this(arr, 0, arr.length);
    }

    public CharIterator(char[] arr, int ofs, int len) {
        this.arr = arr;
        this.ofs = ofs;
        this.end = ofs + len;
        this.idx = ofs;
        this.attrs = new HashMap();
    }

    @Override
    public char first() {
        this.idx = this.ofs;
        return this.idx < this.end ? this.arr[this.idx] : (char)'\uffff';
    }

    @Override
    public char last() {
        if (this.ofs < this.end) {
            this.idx = this.end - 1;
            return this.arr[this.idx];
        }
        this.idx = this.end;
        return '\uffff';
    }

    @Override
    public char current() {
        return this.idx < this.end ? this.arr[this.idx] : (char)'\uffff';
    }

    @Override
    public char next() {
        return this.idx + 1 < this.end ? this.arr[++this.idx] : (char)'\uffff';
    }

    @Override
    public char previous() {
        return this.idx - 1 < this.ofs ? (char)'\uffff' : this.arr[--this.idx];
    }

    @Override
    public int getBeginIndex() {
        return this.ofs;
    }

    @Override
    public int getEndIndex() {
        return this.end;
    }

    @Override
    public int getIndex() {
        return this.idx;
    }

    @Override
    public char setIndex(int x) {
        this.idx = x;
        return this.arr[this.idx];
    }

    @Override
    public int getRunStart() {
        return this.ofs;
    }

    @Override
    public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
        return this.ofs;
    }

    public int getRunStart(Set attributes) {
        return this.ofs;
    }

    @Override
    public int getRunLimit() {
        return this.end;
    }

    @Override
    public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
        return this.end;
    }

    public int getRunLimit(Set attributes) {
        return this.end;
    }

    public Map getAttributes() {
        return this.attrs;
    }

    @Override
    public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
        return this.attrs.get(attribute);
    }

    public Set getAllAttributeKeys() {
        return this.attrs.keySet();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public void setBeginIndex(int x) {
        this.ofs = x;
    }

    public void setEndIndex(int z) {
        this.end = z;
    }

    public char[] array() {
        return this.arr;
    }

    public void setArray(char[] chars) {
        this.arr = chars;
    }

    public void setAttribute(AttributedCharacterIterator.Attribute attribute, Object value) {
        this.attrs.put(attribute, value);
    }

    public String toString() {
        return new String(this.arr, this.ofs, this.end - this.ofs);
    }

    public void setLong(long i) throws ArrayIndexOutOfBoundsException {
        int q2;
        int r;
        if (i == Long.MIN_VALUE) {
            this.ofs = 0;
            this.end = MIN_LONG.length;
            System.arraycopy(MIN_LONG, 0, this.arr, 0, this.end);
            this.idx = 0;
            return;
        }
        this.ofs = this.end = this.arr.length;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            this.arr[--this.ofs] = DigitOnes[r];
            this.arr[--this.ofs] = DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            this.arr[--this.ofs] = DigitOnes[r];
            this.arr[--this.ofs] = DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            this.arr[--this.ofs] = digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            this.arr[--this.ofs] = sign;
        }
    }
}

