/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.render;

import com.spacekiller.util.render.FontButtonUI;
import com.spacekiller.util.render.FontOutline;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class FontButton
extends JButton {
    private static final long serialVersionUID = -2935761035664295289L;
    private static final FontButtonUI fontButtonUI = new FontButtonUI();
    private FontOutline fontOutline;
    private float outlineWidth = 1.0f;
    private Paint fillPaint;
    private Paint outlinePaint;
    private Paint disabledFillPaint;
    private Paint disabledOutlinePaint;
    private boolean ignoreSetForeground;

    public FontButton() {
    }

    public FontButton(Action a) {
        super(a);
    }

    public FontButton(Icon icon) {
        super(icon);
    }

    public FontButton(String text, Icon icon) {
        super(text, icon);
    }

    public FontButton(String text) {
        super(text);
    }

    @Override
    public void updateUI() {
        this.setUI(fontButtonUI);
    }

    public FontOutline getFontOutline() {
        if (this.fontOutline == null) {
            this.fontOutline = new FontOutline(this.getFont(), this.getText().toCharArray());
        }
        return this.fontOutline;
    }

    public void setChars(char[] arr) {
        this.getFontOutline().setText(arr);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.getFontOutline().setText(text.toCharArray());
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.getFontOutline().setFont(font);
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (!this.isIgnoreSetForeground()) {
            this.setFillColor(fg);
        }
    }

    public Stroke getOutlineStroke() {
        return this.getFontOutline().getOutlineStroke();
    }

    public void setOutlineStroke(Stroke outlineStroke) {
        this.getFontOutline().setOutlineStroke(outlineStroke);
    }

    public float getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setOutlineWidth(float outlineWidth) {
        this.outlineWidth = outlineWidth;
        this.setOutlineStroke(new BasicStroke(outlineWidth));
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint fillPaint) {
        this.fillPaint = fillPaint;
    }

    public Color getFillColor() {
        Paint p = this.getFillPaint();
        return p instanceof Color ? (Color)p : null;
    }

    public void setFillColor(Color fillColor) {
        this.setFillPaint(fillColor);
        this.setDisabledFillColor(FontOutline.paler(fillColor));
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint outlinePaint) {
        this.outlinePaint = outlinePaint;
    }

    public Color getOutlineColor() {
        Paint p = this.getOutlinePaint();
        return p instanceof Color ? (Color)p : null;
    }

    public void setOutlineColor(Color outlineColor) {
        this.setOutlinePaint(outlineColor);
        this.setDisabledOutlineColor(FontOutline.paler(outlineColor));
    }

    public Paint getDisabledFillPaint() {
        return this.disabledFillPaint;
    }

    public void setDisabledFillPaint(Paint disabledFillPaint) {
        this.disabledFillPaint = disabledFillPaint;
    }

    public Color getDisabledFillColor() {
        Paint p = this.getDisabledFillPaint();
        return p instanceof Color ? (Color)p : null;
    }

    public void setDisabledFillColor(Color fillColor) {
        this.setDisabledFillPaint(fillColor);
    }

    public Paint getDisabledOutlinePaint() {
        return this.disabledOutlinePaint;
    }

    public void setDisabledOutlinePaint(Paint disabledOutlinePaint) {
        this.disabledOutlinePaint = disabledOutlinePaint;
    }

    public Color getDisabledOutlineColor() {
        Paint p = this.getDisabledOutlinePaint();
        return p instanceof Color ? (Color)p : null;
    }

    public void setDisabledOutlineColor(Color outlineColor) {
        this.setDisabledOutlinePaint(outlineColor);
    }

    public boolean isIgnoreSetForeground() {
        return this.ignoreSetForeground;
    }

    public void setIgnoreSetForeground(boolean ignoreSetForeground) {
        this.ignoreSetForeground = ignoreSetForeground;
    }
}

