/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.render;

import com.spacekiller.util.render.FontLabel;
import com.spacekiller.util.render.FontOutline;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;

public class FontLabelUI
extends BasicLabelUI {
    @Override
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            FontLabel label = (FontLabel)l;
            Paint fillPaint = label.getFillPaint();
            Paint outlinePaint = label.getOutlinePaint();
            this.paintOutlineText(label, g2, s, textX, textY, fillPaint, outlinePaint);
            return;
        }
        super.paintEnabledText(l, g, s, textX, textY);
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            FontLabel label = (FontLabel)l;
            Paint fillPaint = label.getDisabledFillPaint();
            Paint outlinePaint = label.getDisabledOutlinePaint();
            this.paintOutlineText(label, g2, s, textX, textY, fillPaint, outlinePaint);
            return;
        }
        super.paintDisabledText(l, g, s, textX, textY);
    }

    protected void paintOutlineText(FontLabel label, Graphics2D g2, String s, int textX, int textY, Paint fillPaint, Paint outlinePaint) {
        switch (label.getHorizontalAlignment()) {
            case 4: {
                textX = (int)((double)textX - Math.ceil(label.getOutlineWidth()));
            }
        }
        switch (label.getVerticalAlignment()) {
            case 3: {
                textY = (int)((double)textY - Math.ceil(label.getOutlineWidth()));
            }
        }
        FontOutline outline = label.getFontOutline();
        RenderingHints oldHints = g2.getRenderingHints();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        outline.drawText(g2, textX, textY, fillPaint, outlinePaint);
        g2.setRenderingHints(oldHints);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = super.getPreferredSize(c);
        FontLabel label = (FontLabel)c;
        int extra = (int)Math.ceil(label.getOutlineWidth()) * 2;
        dim.width += extra;
        dim.height += extra;
        return dim;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension dim = super.getMinimumSize(c);
        FontLabel label = (FontLabel)c;
        int extra = (int)Math.ceil(label.getOutlineWidth()) * 2;
        dim.width += extra;
        dim.height += extra;
        return dim;
    }
}

