/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.render;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class ImageLabel
extends JComponent
implements SwingConstants {
    private static final long serialVersionUID = 3576077139798357335L;
    private static final Image[] EMPTY = new Image[0];
    private Image[] arr;
    private int ofs;
    private int end;
    private int orientation = 0;

    public ImageLabel() {
        this.arr = EMPTY;
        this.ofs = 0;
        this.end = 0;
    }

    public ImageLabel(Image[] arr, int ofs, int len) {
        this.arr = arr;
        this.ofs = ofs;
        this.end = ofs + len;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public Image[] getImages() {
        return this.arr;
    }

    public void setImages(Image[] arr) {
        this.arr = arr;
    }

    public int getOffset() {
        return this.ofs;
    }

    public void setOffset(int ofs) {
        this.ofs = ofs;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.orientation == 0) {
            int x = 0;
            for (int i = this.ofs; i < this.end; ++i) {
                Image img = this.arr[i];
                if (img == null) continue;
                g.drawImage(img, x, 0, this);
                x += img.getWidth(this);
            }
        } else {
            int y = 0;
            for (int i = this.ofs; i < this.end; ++i) {
                Image img = this.arr[i];
                if (img == null) continue;
                g.drawImage(img, 0, y, this);
                y += img.getHeight(this);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        int w = 0;
        int h = 0;
        if (this.orientation == 0) {
            for (int i = this.ofs; i < this.end; ++i) {
                Image img = this.arr[i];
                if (img == null) continue;
                w += img.getWidth(this);
                h = Math.max(h, img.getHeight(this));
            }
        } else {
            for (int i = this.ofs; i < this.end; ++i) {
                Image img = this.arr[i];
                if (img == null) continue;
                w = Math.max(w, img.getWidth(this));
                h += img.getHeight(this);
            }
        }
        return new Dimension(w, h);
    }

    public Image createStringImage(GraphicsConfiguration gc, String text) {
        Font font = this.getFont();
        FontMetrics fm = this.getFontMetrics(font);
        int width = fm.stringWidth(text);
        int height = fm.getHeight();
        int ascent = fm.getAscent();
        return this.createStringImage(gc, text, width, height, ascent, font);
    }

    public Image createStringImage(GraphicsConfiguration gc, String text, int width, int height, int ascent, Font font) {
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)((Image)img).getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
        }
        g.setFont(font);
        g.setColor(this.getForeground());
        g.drawString(text, 0, ascent);
        g.dispose();
        return img;
    }
}

