/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.render;

import com.spacekiller.util.render.BufferedImagePool;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.WritableRaster;

public class ImageUtil {
    public static final Color TRANS_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private static ImageUtil INSTANCE;
    private BufferedImagePool pool;

    protected ImageUtil() {
        this(new BufferedImagePool());
    }

    public ImageUtil(BufferedImagePool pool) {
        this.setPool(pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageUtil getInstance() {
        ImageUtil inst = INSTANCE;
        if (inst != null) return inst;
        Class<ImageUtil> clazz = ImageUtil.class;
        synchronized (ImageUtil.class) {
            inst = INSTANCE;
            if (inst != null) return inst;
            INSTANCE = inst = new ImageUtil();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return inst;
        }
    }

    protected BufferedImagePool getPool() {
        return this.pool;
    }

    protected void setPool(BufferedImagePool pool) {
        if (pool == null) {
            throw new NullPointerException("pool");
        }
        this.pool = pool;
    }

    public void flush() {
        this.pool.clear();
    }

    public BufferedImage createImageChild(BufferedImage parent, int width, int height) {
        return this.createImageChild(parent, 0, 0, width, height);
    }

    public BufferedImage createImageChild(BufferedImage parent, int x, int y, int width, int height) {
        WritableRaster rasta = parent.getRaster();
        WritableRaster child = rasta.createWritableChild(x, y, width, height, 0, 0, null);
        BufferedImage ic = new BufferedImage(parent.getColorModel(), child, parent.isAlphaPremultiplied(), null);
        return ic;
    }

    public BufferedImage createBlurImage(Image image, int radiusX, int radiusY, boolean crop) {
        Kernel kernel = this.createBlurKernel(radiusX, radiusY);
        return this.createBlurImage(image, kernel, crop, this.pool, null);
    }

    public BufferedImage createBlurImage(Image image, Kernel kernel, boolean crop) {
        return this.createBlurImage(image, kernel, crop, this.pool, null);
    }

    public BufferedImage createBlurImage(Image image, Kernel kernel, boolean crop, BufferedImagePool pool) {
        return this.createBlurImage(image, kernel, crop, pool, null);
    }

    public BufferedImage createBlurImage(Image image, Kernel kernel, boolean crop, BufferedImagePool pool, BufferedImage targetImage) {
        int cropY;
        int cropX;
        BufferedImage dst;
        Graphics2D bg;
        int type;
        int radiusY2;
        int targetHeight;
        int blurHeight;
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (width < 1 || height < 1) {
            return null;
        }
        int radiusX2 = kernel.getWidth() - 1;
        int targetWidth = width + radiusX2;
        int blurWidth = targetWidth + radiusX2;
        BufferedImage src = pool.getBufferedImage(blurWidth, blurHeight = (targetHeight = height + (radiusY2 = kernel.getHeight() - 1)) + radiusY2, type = 2);
        if (src == null) {
            src = new BufferedImage(blurWidth, blurHeight, type);
            bg = src.createGraphics();
        } else {
            bg = src.createGraphics();
            bg.setComposite(AlphaComposite.Clear);
            bg.setColor(TRANS_COLOR);
            bg.fillRect(0, 0, blurWidth, blurHeight);
            bg.setComposite(AlphaComposite.SrcOver);
        }
        bg.drawImage(image, radiusX2, radiusY2, null);
        bg.dispose();
        BufferedImage srcPart = src;
        if (src.getWidth() != blurWidth || src.getHeight() != blurHeight) {
            srcPart = this.createImageChild(src, 0, 0, blurWidth, blurHeight);
        }
        if ((dst = pool.getBufferedImage(blurWidth, blurHeight, type)) == null) {
            dst = new BufferedImage(blurWidth, blurHeight, type);
        }
        BufferedImage dstPart = dst;
        if (dst.getWidth() != blurWidth || dst.getHeight() != blurHeight) {
            dstPart = this.createImageChild(dst, 0, 0, blurWidth, blurHeight);
        }
        ConvolveOp cop = new ConvolveOp(kernel, 1, null);
        BufferedImage blurImage = cop.filter(srcPart, dstPart);
        if (pool != null) {
            pool.putBufferedImage(src);
        }
        if (crop) {
            targetWidth = width;
            targetHeight = height;
            cropX = -radiusX2;
            cropY = -radiusY2;
        } else {
            cropX = -radiusX2 / 2;
            cropY = -radiusY2 / 2;
        }
        if (targetImage == null) {
            targetImage = new BufferedImage(targetWidth, targetHeight, type);
        }
        bg = targetImage.createGraphics();
        bg.drawImage((Image)blurImage, cropX, cropY, null);
        bg.dispose();
        if (pool != null) {
            pool.putBufferedImage(dst);
        }
        return targetImage;
    }

    public Kernel createBlurKernel(int radiusX, int radiusY) {
        return this.createBlurKernel(radiusX, radiusY, null);
    }

    public Kernel createBlurKernel(int radiusX, int radiusY, float[] data) {
        int kernelWidth = 1 + radiusX + radiusX;
        int kernelHeight = 1 + radiusY + radiusY;
        int kernelSize = kernelWidth * kernelHeight;
        if (data == null || data.length < kernelSize) {
            data = new float[kernelSize];
        }
        for (int y = 0; y <= radiusY; ++y) {
            for (int x = 0; x <= radiusX; ++x) {
                float v;
                double dx = (double)x + 0.25;
                double dy = (double)y + 0.25;
                data[(radiusY + y) * kernelWidth + (radiusX + x)] = v = (float)(1.0 / Math.sqrt(dx * dx + dy * dy));
                data[(radiusY + y) * kernelWidth + (radiusX - x)] = v;
                data[(radiusY - y) * kernelWidth + (radiusX + x)] = v;
                data[(radiusY - y) * kernelWidth + (radiusX - x)] = v;
            }
        }
        double sum = 0.0;
        for (int i = 0; i < kernelSize; ++i) {
            sum += (double)data[i];
        }
        double factor = 1.0 / sum;
        int i = 0;
        while (i < kernelSize) {
            int n = i++;
            data[n] = (float)((double)data[n] * factor);
        }
        return new Kernel(kernelWidth, kernelHeight, data);
    }

    protected String dumpMatrix(int w, int h, float[] arr) {
        StringBuffer sb = new StringBuffer();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                if (x > 0) {
                    sb.append(" | ");
                }
                sb.append(String.valueOf(Math.round((double)arr[y * w + x] * 1000.0)));
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

