/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.render;

import com.spacekiller.util.render.RotatingIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.Timer;

public class RotatingIconLabel
extends JLabel {
    private static final long serialVersionUID = 47592326997147750L;
    private Timer timer;
    private int delay = 50;
    private double thetaIncrement = 0.09817477042468103;

    public RotatingIconLabel() {
    }

    public RotatingIconLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
    }

    public RotatingIconLabel(Icon image) {
        super(image);
    }

    public RotatingIconLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
    }

    public RotatingIconLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
    }

    public RotatingIconLabel(String text) {
        super(text);
    }

    @Override
    public void setIcon(Icon icon) {
        if (icon == null) {
            super.setIcon(icon);
            return;
        }
        if (icon instanceof RotatingIcon) {
            super.setIcon(icon);
            return;
        }
        RotatingIcon rot = new RotatingIcon(icon);
        super.setIcon(rot);
    }

    public void start() {
        if (this.timer != null && this.timer.isRunning()) {
            return;
        }
        this.timer = new Timer(this.delay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RotatingIconLabel.this.rotate();
            }
        });
        this.timer.setRepeats(true);
        this.timer.start();
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    protected void rotate() {
        Icon icon = this.getIcon();
        if (icon != null && icon instanceof RotatingIcon) {
            RotatingIcon rot = (RotatingIcon)icon;
            double theta = (rot.getTheta() + this.thetaIncrement) % (Math.PI * 2);
            rot.setTheta(theta);
            this.repaint();
        }
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public double getThetaIncrement() {
        return this.thetaIncrement;
    }

    public void setThetaIncrement(double thetaIncrement) {
        this.thetaIncrement = thetaIncrement;
    }
}

