/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.render;

import com.spacekiller.util.render.ScalableRepaintManager;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;

public class ScalablePane
extends JPanel {
    private static final long serialVersionUID = -4208695786386252565L;
    private JComponent fieldScaleComponent = null;
    private ScaleComponent paintComponent = new ScaleComponent();
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    protected JFrame eventHandlerFrame = new ScaleFrame();
    public static final long allEvents = 3391L;
    private static final Logger logger = Logger.getLogger(ScalablePane.class.getName());

    public ScalablePane() {
        this.initialize();
    }

    private void connEtoC1() {
        try {
            this.scalablePane_Initialize();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void dispatchEventToPeer(AWTEvent peerEv) {
        if (peerEv == null) {
            return;
        }
        this.getToolkit().getSystemEventQueue().postEvent(peerEv);
    }

    public void dispose() {
        this.setScale(1.0, 1.0);
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isScaled()) {
            return super.getPreferredSize();
        }
        Dimension pref = this.paintComponent.getPreferredSize();
        return new Dimension((int)(pref.getWidth() * this.getScaleX()), (int)(pref.getHeight() * this.getScaleY()));
    }

    public JComponent getScaleComponent() {
        return this.fieldScaleComponent;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Component getVisibleComponentAt(Container container, int x, int y) {
        if (container == null) {
            return null;
        }
        Component comp = container.getComponentAt(x, y);
        if (comp == container) {
            return null;
        }
        if (comp != null && comp.isVisible()) {
            return comp;
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            int num = container.getComponentCount();
            for (int c = 0; c < num; ++c) {
                comp = container.getComponent(c);
                if (!comp.isVisible() || !comp.contains(x, y)) continue;
                return comp;
            }
        }
        return null;
    }

    private void handleComponentEvent(ComponentEvent cev, JComponent peer) {
        if (cev.getID() == 101 && cev.getSource() == this) {
            this.validate();
            logger.fine("resized to: " + this.paintComponent.getBounds());
        } else {
            if (cev.getID() == 101) {
                logger.fine("resized: " + cev);
            }
            if (cev.getID() == 100) {
                logger.fine("moved: " + cev);
            }
            this.dispatchEventToPeer(new ComponentEvent(peer, cev.getID()));
        }
    }

    private void handleException(Throwable exception) {
        logger.fine("--------- UNCAUGHT EXCEPTION ---------");
        logger.log(Level.SEVERE, exception.getMessage(), exception);
    }

    private void handleMouseEvent(MouseEvent mev, JComponent peer) {
        int x = (int)((double)mev.getX() / this.getScaleX());
        int y = (int)((double)mev.getY() / this.getScaleY());
        this.eventHandlerFrame.getContentPane().add(this.paintComponent);
        Insets insets = this.eventHandlerFrame.getInsets();
        MouseEvent newEv = new MouseEvent(this.eventHandlerFrame, mev.getID(), mev.getWhen(), mev.getModifiersEx(), insets.left + x, insets.top + y, mev.getClickCount(), mev.isPopupTrigger());
        this.eventHandlerFrame.dispatchEvent(newEv);
    }

    private void initConnections() throws Exception {
    }

    private void initialize() {
        try {
            this.setName("ProjectUI");
            this.setBounds(new Rectangle(0, 0, 339, 149));
            this.setLayout(new GridLayout());
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.setMinimumSize(new Dimension(0, 0));
            this.setSize(339, 149);
            this.initConnections();
            this.connEtoC1();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public boolean isScaled() {
        return this.scaleX != 1.0 || this.scaleY != 1.0;
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            ScalablePane aProjectUI = new ScalablePane();
            JTree comp = new JTree();
            aProjectUI.setScaleComponent(comp);
            aProjectUI.setScaleX(0.9);
            aProjectUI.setScaleY(0.9);
            frame.setContentPane(aProjectUI);
            frame.setSize(aProjectUI.getSize());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.setVisible(true);
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of com.spacekiller.conv.ProjectUI");
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        ScaleComponent comp;
        if (!this.isScaled()) {
            super.paintComponent(g);
            return;
        }
        Rectangle bounds = g.getClipBounds();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            g2.scale(this.getScaleX(), this.getScaleY());
        }
        if ((comp = this.paintComponent) != null && this.getScaleComponent() != null) {
            ((Component)comp).validate();
            SwingUtilities.paintComponent(g, comp, this, comp.getBounds());
        }
    }

    @Override
    protected void processEvent(AWTEvent ev) {
        if (!this.isScaled()) {
            super.processEvent(ev);
            return;
        }
        JComponent peer = this.getScaleComponent();
        if (peer == null) {
            return;
        }
        if (ev instanceof MouseEvent) {
            this.handleMouseEvent((MouseEvent)ev, peer);
            return;
        }
        if (ev instanceof ComponentEvent) {
            this.handleComponentEvent((ComponentEvent)ev, peer);
            return;
        }
        logger.fine("unknown event: " + ev);
    }

    private void scalablePane_Initialize() {
        this.eventHandlerFrame.setBounds(-2500, -2500, 2000, 2000);
        this.eventHandlerFrame.setVisible(true);
        this.eventHandlerFrame.setVisible(false);
    }

    private void scaleScaleComponent() {
        JComponent scaleComponent = this.getScaleComponent();
        if (this.isScaled()) {
            ScalableRepaintManager.getDefaultScalableRepaintManager().addScalablePane(this);
            this.enableEvents(3391L);
            this.paintComponent.removeAll();
            if (scaleComponent != null) {
                this.paintComponent.add(scaleComponent);
            }
        } else {
            this.disableEvents(3391L);
            ScalableRepaintManager.getDefaultScalableRepaintManager().removeScalablePane(this);
            this.removeAll();
            if (scaleComponent != null) {
                this.add(scaleComponent);
            }
        }
    }

    public void setScale(double newScaleX, double newScaleY) {
        boolean wasScaled = this.isScaled();
        this.scaleY = newScaleY;
        this.scaleX = newScaleX;
        boolean scaled = this.isScaled();
        if (scaled != wasScaled) {
            this.scaleScaleComponent();
        }
        this.validateScaleComponent();
    }

    public void setScaleComponent(JComponent scaleComponent) {
        this.fieldScaleComponent = scaleComponent;
        this.scaleScaleComponent();
        this.validateScaleComponent();
    }

    public void setScaleX(double newScaleX) {
        boolean wasScaled = this.isScaled();
        this.scaleX = newScaleX;
        boolean scaled = this.isScaled();
        if (scaled != wasScaled) {
            this.scaleScaleComponent();
        }
        this.validateScaleComponent();
    }

    public void setScaleY(double newScaleY) {
        boolean wasScaled = this.isScaled();
        this.scaleY = newScaleY;
        boolean scaled = this.isScaled();
        if (scaled != wasScaled) {
            this.scaleScaleComponent();
        }
        this.validateScaleComponent();
    }

    @Override
    public void validate() {
        super.validate();
        this.validateScaleComponent();
    }

    private void validateScaleComponent() {
        int width = (int)((double)this.getWidth() / this.getScaleX());
        int height = (int)((double)this.getHeight() / this.getScaleY());
        this.paintComponent.setScaleBounds(new Rectangle(0, 0, width, height));
        this.paintComponent.validate();
    }

    @Override
    protected void validateTree() {
        super.validateTree();
        this.validateScaleComponent();
    }

    class ScaleComponent
    extends JComponent {
        private static final long serialVersionUID = 2736630614313239656L;

        public ScaleComponent() {
            this.setLayout(new GridLayout(1, 1));
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
        }

        @Override
        public void setBounds(Rectangle r) {
        }

        public void setScaleBounds(Rectangle r) {
            super.setBounds(r.x, r.y, r.width, r.height);
        }
    }

    class ScaleFrame
    extends JFrame {
        private static final long serialVersionUID = 6334530845532131987L;

        ScaleFrame() {
        }

        @Override
        public void setContentPane(Container c) {
            System.out.println("!!!! FRAME-SET-CONTENTPANE: " + c);
            super.setContentPane(c);
        }
    }
}

