/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.jmidi;

import com.spacekiller.util.midi.MidiFactory;
import com.spacekiller.util.midi.MidiManager;
import com.waxmonster.midi.MidiPort;
import com.waxmonster.midi.jmidi.JMidiDeviceInfo;
import com.waxmonster.midi.jmidi.JMidiDevicePanel;
import com.waxmonster.midi.jmidi.JMidiDeviceProvider;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MidiDevice;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class JMidiDevice
extends Device {
    private static final Logger logger = Logger.getLogger(JMidiDevice.class.getName());
    private static final String KEY_MIDI_DEVICE_NAME = "midiDeviceName";
    private final JMidiDeviceProvider midiDeviceProvider;
    private final JMidiDeviceInfo jMidiDeviceInfo;
    private MidiFactory midiFactory;
    private String midiDeviceName;
    private JMidiDevicePanel jMidiDevicePanel;

    public JMidiDevice(JMidiDeviceProvider midiDeviceProvider, String name, Icon iconColor16, JMidiDeviceInfo jMidiDeviceInfo, MidiFactory midiFactory) {
        super((DeviceProvider)midiDeviceProvider, name);
        this.setIconColor16(iconColor16);
        this.midiDeviceProvider = midiDeviceProvider;
        this.jMidiDeviceInfo = jMidiDeviceInfo;
        this.midiFactory = midiFactory;
    }

    protected synchronized void addMidiPort(MidiPort port) throws StudioException {
        super.addPort((Port)port);
    }

    protected void activate() throws StudioException {
        this.midiDeviceProvider.activate(this);
    }

    protected void deactivate() throws StudioException {
        this.midiDeviceProvider.deactivate(this);
    }

    public synchronized Component getCustomizer() {
        if (this.jMidiDevicePanel == null) {
            this.jMidiDevicePanel = new JMidiDevicePanel();
            this.jMidiDevicePanel.setOpaque(false);
            this.jMidiDevicePanel.setDevice(this);
        }
        return this.jMidiDevicePanel;
    }

    public synchronized Properties getProperties() {
        Properties props = super.getProperties();
        if (this.midiDeviceName != null) {
            props.setProperty(KEY_MIDI_DEVICE_NAME, this.midiDeviceName);
        } else {
            props.remove(KEY_MIDI_DEVICE_NAME);
        }
        return props;
    }

    protected void applyProperty(String key, String value) {
        if (KEY_MIDI_DEVICE_NAME.equals(key)) {
            if ("null".equals(value)) {
                value = null;
            }
            this.setMidiDeviceName(value);
            return;
        }
    }

    protected void setSubtitle(String subtitle) {
        super.setSubtitle(subtitle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDefaultMidiDeviceOLD() {
        if (this.midiDeviceName != null) {
            return;
        }
        if (this.jMidiDeviceInfo == null) {
            return;
        }
        int type = this.jMidiDeviceInfo.getType();
        String devName = null;
        try {
            MidiFactory factory = this.getMidiFactory();
            if (factory == null) {
                return;
            }
            MidiManager manager = factory.createMidiManager();
            try {
                MidiDevice.Info[] infos = manager.getMidiDeviceInfo();
                for (int i = 0; i < infos.length; ++i) {
                    String infoName;
                    MidiDevice.Info info = infos[i];
                    if (info == null || (infoName = info.getName()) == null) continue;
                    try {
                        MidiDevice midiDev = manager.getMidiDevice(info);
                        if (midiDev == null) continue;
                        try {
                            if (type == 0) {
                                int maxTransmitters = midiDev.getMaxTransmitters();
                                if (maxTransmitters == 0) continue;
                            } else {
                                int maxReceivers = midiDev.getMaxReceivers();
                                if (maxReceivers == 0) {
                                    continue;
                                }
                            }
                        }
                        finally {
                            manager.closeMidiDevice(midiDev);
                        }
                        devName = infoName;
                        break;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            finally {
                manager.close();
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        if (devName == null) {
            return;
        }
        if (this.midiDeviceName != null) {
            return;
        }
        final String defaultMidiDevName = devName;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (JMidiDevice.this.midiDeviceName != null) {
                    return;
                }
                JMidiDevice.this.setMidiDeviceName(defaultMidiDevName);
            }
        });
    }

    protected MidiFactory getMidiFactory() {
        return this.midiFactory;
    }

    protected final JMidiDeviceInfo getJMidiDeviceInfo() {
        return this.jMidiDeviceInfo;
    }

    public String getMidiDeviceName() {
        return this.midiDeviceName;
    }

    public void setMidiDeviceName(String midiDeviceName) {
        this.midiDeviceName = midiDeviceName;
    }

    protected static String generateUniqueMidiDeviceName(String name, Set names) {
        if (!names.contains(name)) {
            return name;
        }
        int max = 20;
        for (int i = 0; i < max; ++i) {
            String unique = name + " " + (2 + i);
            if (names.contains(unique)) continue;
            return unique;
        }
        return null;
    }
}

