/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.jmidi;

import com.spacekiller.util.midi.MidiFactory;
import com.spacekiller.util.midi.MidiManager;
import com.waxmonster.midi.jmidi.JMidiDevice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MidiDevice;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class JMidiDevicePanel
extends JPanel {
    private static final long serialVersionUID = -67562298905175323L;
    private static final String NONE_DEVICE = "<Select Device>";
    private static final Logger logger = Logger.getLogger(JMidiDevicePanel.class.getName());
    private JMidiDevice device;
    private boolean refreshing;
    private JComboBox comboBoxMidiDev;
    private JButton btnRefresh;
    private Set midiDeviceNames = new HashSet();
    private MidiDeviceRenderer renderer;

    public JMidiDevicePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelMidiDev = new JPanel();
        panelMidiDev.setOpaque(false);
        panelMidiDev.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "MIDI Device", 4, 2, null, null));
        GridBagConstraints gbc_panelMidiDev = new GridBagConstraints();
        gbc_panelMidiDev.insets = new Insets(4, 4, 4, 4);
        gbc_panelMidiDev.fill = 2;
        gbc_panelMidiDev.gridx = 0;
        gbc_panelMidiDev.gridy = 0;
        this.add((Component)panelMidiDev, gbc_panelMidiDev);
        GridBagLayout gbl_panelMidiDev = new GridBagLayout();
        gbl_panelMidiDev.columnWidths = new int[]{0, 0, 0};
        gbl_panelMidiDev.rowHeights = new int[]{0, 0};
        gbl_panelMidiDev.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gbl_panelMidiDev.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelMidiDev.setLayout(gbl_panelMidiDev);
        this.comboBoxMidiDev = new JComboBox();
        this.comboBoxMidiDev.setOpaque(false);
        this.comboBoxMidiDev.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!JMidiDevicePanel.this.refreshing) {
                    JMidiDevicePanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_comboBoxMidiDev = new GridBagConstraints();
        gbc_comboBoxMidiDev.insets = new Insets(4, 4, 4, 4);
        gbc_comboBoxMidiDev.fill = 1;
        gbc_comboBoxMidiDev.gridx = 0;
        gbc_comboBoxMidiDev.gridy = 0;
        panelMidiDev.add((Component)this.comboBoxMidiDev, gbc_comboBoxMidiDev);
        this.btnRefresh = new JButton("");
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMidiDevicePanel.this.refresh(true);
            }
        });
        this.btnRefresh.setMargin(new Insets(2, 2, 2, 2));
        this.btnRefresh.setToolTipText("Refresh devices");
        this.btnRefresh.setIcon(new ImageIcon(JMidiDevicePanel.class.getResource("/com/waxmonster/midi/jmidi/icons/refresh_devices.gif")));
        GridBagConstraints gbc_btnRefresh = new GridBagConstraints();
        gbc_btnRefresh.insets = new Insets(4, 0, 4, 4);
        gbc_btnRefresh.gridx = 1;
        gbc_btnRefresh.gridy = 0;
        panelMidiDev.add((Component)this.btnRefresh, gbc_btnRefresh);
        ImageIcon missingDeviceIcon = new ImageIcon(JMidiDevicePanel.class.getResource("/com/waxmonster/midi/jmidi/icons/missing_midi_device_icon16.png"));
        this.renderer = new MidiDeviceRenderer(missingDeviceIcon);
    }

    public JMidiDevice getDevice() {
        return this.device;
    }

    public void setDevice(JMidiDevice device) {
        this.device = device;
        this.refresh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(boolean refreshMidiDevices) {
        try {
            this.refreshing = true;
            this.getComboBoxMidiDev().removeAllItems();
            this.getComboBoxMidiDev().setRenderer(this.renderer);
            this.getComboBoxMidiDev().addItem(NONE_DEVICE);
            String midiDevName = null;
            int selectedIndex = -1;
            this.midiDeviceNames.clear();
            JMidiDevice dev = this.device;
            if (dev != null) {
                midiDevName = dev.getMidiDeviceName();
                int type = dev.getJMidiDeviceInfo().getType();
                MidiFactory factory = dev.getMidiFactory();
                if (factory != null) {
                    if (refreshMidiDevices) {
                        try {
                            factory.refreshMidiDeviceInfo();
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    MidiManager manager = factory.createMidiManager();
                    try {
                        MidiDevice.Info[] infos = manager.getMidiDeviceInfo();
                        for (int i = 0; i < infos.length; ++i) {
                            String infoName;
                            MidiDevice.Info info = infos[i];
                            if (info == null || (infoName = info.getName()) == null) continue;
                            try {
                                MidiDevice midiDev = manager.getMidiDevice(info);
                                if (midiDev == null) continue;
                                try {
                                    if (type == 0) {
                                        int maxTransmitters = midiDev.getMaxTransmitters();
                                        if (maxTransmitters == 0) continue;
                                    } else {
                                        int maxReceivers = midiDev.getMaxReceivers();
                                        if (maxReceivers == 0) {
                                            continue;
                                        }
                                    }
                                }
                                finally {
                                    manager.closeMidiDevice(midiDev);
                                }
                                if (!this.midiDeviceNames.add(infoName)) {
                                    if ((infoName = JMidiDevice.generateUniqueMidiDeviceName(infoName, this.midiDeviceNames)) == null) continue;
                                    this.midiDeviceNames.add(infoName);
                                }
                                if (infoName.equals(midiDevName)) {
                                    selectedIndex = this.getComboBoxMidiDev().getItemCount();
                                }
                                this.getComboBoxMidiDev().addItem(infoName);
                                continue;
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                    }
                    finally {
                        manager.close();
                    }
                }
            }
            if (selectedIndex < 0 && midiDevName != null && midiDevName.length() > 0) {
                selectedIndex = this.getComboBoxMidiDev().getItemCount();
                this.getComboBoxMidiDev().addItem(midiDevName);
            }
            if (selectedIndex >= 0) {
                this.getComboBoxMidiDev().setSelectedIndex(selectedIndex);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void apply() {
        JMidiDevice dev = this.device;
        if (dev == null) {
            return;
        }
        String midiDevName = null;
        Object item = this.getComboBoxMidiDev().getSelectedItem();
        if (item != null && !NONE_DEVICE.equals(item)) {
            midiDevName = String.valueOf(item);
        }
        dev.setMidiDeviceName(midiDevName);
    }

    protected JComboBox getComboBoxMidiDev() {
        return this.comboBoxMidiDev;
    }

    protected JButton getBtnRefresh() {
        return this.btnRefresh;
    }

    protected class MidiDeviceRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -7198324160230828849L;
        private Icon missingDeviceIcon;

        public MidiDeviceRenderer(Icon missingDeviceIcon) {
            this.missingDeviceIcon = missingDeviceIcon;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Icon icon = null;
            String tip = null;
            String midiDevName = String.valueOf(value);
            if (!JMidiDevicePanel.NONE_DEVICE.equals(midiDevName) && !JMidiDevicePanel.this.midiDeviceNames.contains(midiDevName)) {
                icon = this.missingDeviceIcon;
                tip = "Device not found: " + midiDevName;
            }
            this.setIcon(icon);
            this.setToolTipText(tip);
            this.setOpaque(isSelected);
            return comp;
        }
    }
}

