/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.jmidi;

import com.spacekiller.util.Tools;
import com.spacekiller.util.midi.MidiFactory;
import com.spacekiller.util.midi.impl.DefaultMidiFactory;
import com.waxmonster.midi.MidiInputPortType;
import com.waxmonster.midi.MidiOutputPortType;
import com.waxmonster.midi.MidiPort;
import com.waxmonster.midi.MidiPortType;
import com.waxmonster.midi.impl.MidiEngineConfig;
import com.waxmonster.midi.jmidi.JMidiDevice;
import com.waxmonster.midi.jmidi.JMidiDeviceInfo;
import com.waxmonster.midi.jmidi.JMidiInputPort;
import com.waxmonster.midi.jmidi.JMidiOutputPort;
import com.waxmonster.midi.jmidi.JMidiSupport;
import com.waxmonster.midi.jmidi.JMidiSyncGroup;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceInfo;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.StudioException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class JMidiDeviceProvider
extends DeviceProvider {
    public static final String PROVIDER_NAME = "JMidiDeviceProvider";
    public static final String DEVICE_CATEGORY_NAME = "MIDI Devices";
    private static final Logger logger = Logger.getLogger(JMidiDeviceProvider.class.getName());
    private static final String CLASS_NAME = JMidiDeviceProvider.class.getName();
    private MidiEngineConfig config = new MidiEngineConfig();
    private MidiFactory midiFactory;

    public JMidiDeviceProvider() {
        super(PROVIDER_NAME);
        this.initJMidiDeviceProvider();
    }

    protected void initJMidiDeviceProvider() {
        String name = "MIDI Device-Source";
        String tooltip = "MIDI Device (Source)";
        Icon icon = Tools.getIcon(JMidiDeviceProvider.class, (String)"/com/waxmonster/midi/impl/icons/midi_source_icon16.png");
        JMidiDeviceInfo sourceInfo = new JMidiDeviceInfo(name, 0, tooltip, icon);
        this.addDeviceInfo(sourceInfo);
        name = "MIDI Device-Dest";
        tooltip = "MIDI Device (Dest.)";
        icon = Tools.getIcon(JMidiDeviceProvider.class, (String)"/com/waxmonster/midi/impl/icons/midi_dest_icon16.png");
        JMidiDeviceInfo destInfo = new JMidiDeviceInfo(name, 1, tooltip, icon);
        this.addDeviceInfo(destInfo);
    }

    public synchronized void refreshDeviceInfo() {
    }

    public Device createDevice(DeviceInfo info) throws StudioException {
        JMidiSupport midiSupport;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createDevice", info);
        }
        if (info == null || !(info instanceof JMidiDeviceInfo)) {
            throw new StudioException("Invalid DeviceInfo: " + info);
        }
        JMidiDeviceInfo devInfo = (JMidiDeviceInfo)info;
        String devName = devInfo.getDeviceName();
        Icon iconColor16 = info.getIcon(1);
        JMidiDevice dev = new JMidiDevice(this, devName, iconColor16, devInfo, this.getMidiFactory());
        String title = "MIDI Device";
        String subtitle = null;
        int type = devInfo.getType();
        if (type == 0) {
            subtitle = "(Source)";
            midiSupport = new JMidiSupport(devName, dev, this.config);
            JMidiOutputPort outputPort = new JMidiOutputPort("MIDI-Out", MidiOutputPortType.TYPE, midiSupport);
            dev.addMidiPort((MidiPort)outputPort);
        }
        if (type == 1) {
            subtitle = "(Dest.)";
            midiSupport = new JMidiSupport(devName, dev, this.config);
            JMidiInputPort inputPort = new JMidiInputPort("MIDI-In", MidiInputPortType.TYPE, midiSupport);
            dev.addMidiPort((MidiPort)inputPort);
        }
        dev.setTitle(title);
        dev.setSubtitle(subtitle);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "createDevice", (Object)dev);
        }
        return dev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MidiFactory getMidiFactory() {
        if (this.midiFactory == null) {
            JMidiDeviceProvider jMidiDeviceProvider = this;
            synchronized (jMidiDeviceProvider) {
                if (this.midiFactory == null) {
                    this.setMidiFactory(DefaultMidiFactory.getInstance());
                }
            }
        }
        return this.midiFactory;
    }

    protected void setMidiFactory(MidiFactory midiFactory) {
        this.midiFactory = midiFactory;
    }

    public PortType getPortType(String typeName) {
        return MidiPortType.getMidiPortType((String)typeName);
    }

    protected synchronized void activate(JMidiDevice device) throws StudioException {
        HashSet<JMidiSyncGroup> groups = new HashSet<JMidiSyncGroup>();
        Port[] ports = device.getPorts();
        for (int i = 0; i < ports.length; ++i) {
            JMidiSupport support;
            Port port = ports[i];
            if (port instanceof JMidiInputPort) {
                JMidiInputPort inputPort = (JMidiInputPort)port;
                support = inputPort.getJMidiSupport();
                groups.add(support.getJMidiSyncGroup());
                continue;
            }
            if (!(port instanceof JMidiOutputPort)) continue;
            JMidiOutputPort outputPort = (JMidiOutputPort)port;
            support = outputPort.getJMidiSupport();
            groups.add(support.getJMidiSyncGroup());
        }
        for (JMidiSyncGroup group : groups) {
            group.getJMidiEngine().activateJMidiDevice(device, group);
        }
    }

    protected synchronized void deactivate(JMidiDevice device) throws StudioException {
        HashSet<JMidiSyncGroup> groups = new HashSet<JMidiSyncGroup>();
        Port[] ports = device.getPorts();
        for (int i = 0; i < ports.length; ++i) {
            JMidiSupport support;
            Port port = ports[i];
            if (port instanceof JMidiInputPort) {
                JMidiInputPort inputPort = (JMidiInputPort)port;
                support = inputPort.getJMidiSupport();
                groups.add(support.getJMidiSyncGroup());
                continue;
            }
            if (!(port instanceof JMidiOutputPort)) continue;
            JMidiOutputPort outputPort = (JMidiOutputPort)port;
            support = outputPort.getJMidiSupport();
            groups.add(support.getJMidiSyncGroup());
        }
        for (JMidiSyncGroup group : groups) {
            group.getJMidiEngine().deactivateJMidiDevice(device, group);
        }
    }

    public MidiEngineConfig getConfig() {
        return this.config;
    }

    public void setConfig(MidiEngineConfig config) {
        this.config = config;
    }
}

