/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.jmidi;

import com.spacekiller.util.Clock;
import com.spacekiller.util.midi.MidiListener;
import com.spacekiller.util.midi.MidiManager;
import com.waxmonster.midi.MidiContext;
import com.waxmonster.midi.MidiException;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.midi.impl.AbstractMidiEngine;
import com.waxmonster.midi.impl.MidiContextImpl;
import com.waxmonster.midi.impl.MidiEngineConfig;
import com.waxmonster.midi.impl.MidiProcessorProxy;
import com.waxmonster.midi.impl.Wrapper;
import com.waxmonster.midi.impl.WrapperOutputPort;
import com.waxmonster.midi.jmidi.JMidiDevice;
import com.waxmonster.midi.jmidi.JMidiDeviceInfo;
import com.waxmonster.midi.jmidi.JMidiSource;
import com.waxmonster.midi.jmidi.JMidiSupport;
import com.waxmonster.midi.jmidi.JMidiSyncGroup;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.Receiver;

public class JMidiEngine
extends AbstractMidiEngine {
    private static final Logger logger = Logger.getLogger(JMidiEngine.class.getName());
    private final String name;
    private final Clock clock;
    private JMidiSupport jMidiSupport;
    private JMidiSyncGroup jMidiSyncGroup;
    private JMidiDevice jMidiDevice;
    private JMidiDeviceInfo jMidiDeviceInfo;
    private MidiContextImpl midiContext;
    private Wrapper theWrapper;
    private MidiManager midiManager;
    private MidiDevice midiDevice;
    private JMidiSource source;
    private Receiver receiver;

    public JMidiEngine(String name, Clock clock, MidiEngineConfig config) {
        super(config);
        this.name = name;
        this.clock = clock;
    }

    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }

    public void prepare(MidiSyncGroup group, MidiContext context) throws MidiException {
        MidiContextImpl syncGroupContext = this.getMidiContextImpl(context);
        if (group == null || !(group instanceof JMidiSyncGroup)) {
            throw new MidiException("Invalid MidiSyncGroup: " + group);
        }
        JMidiSyncGroup jMidiGroup = (JMidiSyncGroup)group;
        JMidiSupport jMidiSupport = jMidiGroup.getJMidiSupport();
        this.prepareJMidiDriver(jMidiSupport, syncGroupContext);
    }

    public void start() throws MidiException {
        this.startJMidiDriver();
    }

    final void activateJMidiDevice(JMidiDevice device, JMidiSyncGroup syncGroup) throws StudioException {
        MidiContextImpl midiContext;
        Studio studio = device.getStudio();
        if (studio == null) {
            throw new StudioException("Device is not assigned to a studio: " + (Object)((Object)device));
        }
        JMidiSupport jMidiSupport = syncGroup.getJMidiSupport();
        boolean prepared = this.prepareJMidiDriver(jMidiSupport, midiContext = this.createMidiContextImpl(studio));
        if (prepared) {
            this.startJMidiDriver();
        }
    }

    final void deactivateJMidiDevice(JMidiDevice device, JMidiSyncGroup syncGroup) throws StudioException {
        JMidiSupport jMidiSupport = syncGroup.getJMidiSupport();
        this.deactivateJMidiDriver(jMidiSupport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean prepareJMidiDriver(JMidiSupport support, MidiContextImpl context) throws MidiException {
        JMidiSyncGroup syncGroup;
        JMidiEngine jMidiEngine = this;
        synchronized (jMidiEngine) {
            if (this.jMidiSupport == support) {
                return false;
            }
            if (this.jMidiSupport != null) {
                throw new MidiException("JMidiEngine is already activated: " + (Object)((Object)this));
            }
            syncGroup = support.getJMidiSyncGroup();
            if (syncGroup == null) {
                throw new MidiException("No JMidiSyncGroup available: " + (Object)((Object)support));
            }
            JMidiEngine engine = syncGroup.getJMidiEngine();
            if (engine != this) {
                throw new MidiException("Invalid JMidiEngine: " + (Object)((Object)engine) + " != " + (Object)((Object)this));
            }
            this.jMidiSupport = support;
            this.jMidiSyncGroup = syncGroup;
            this.midiContext = context;
        }
        boolean success = false;
        try {
            Wrapper wrapper;
            this.jMidiDevice = this.jMidiSupport.getJMidiDevice();
            this.jMidiDeviceInfo = this.jMidiDevice.getJMidiDeviceInfo();
            int type = this.jMidiDeviceInfo.getType();
            String midiDevName = this.jMidiDevice.getMidiDeviceName();
            MidiDevice midiDev = null;
            if (midiDevName != null) {
                this.midiManager = syncGroup.getMidiManager();
                midiDev = this.getMidiDevice(midiDevName, type, this.midiManager);
            }
            if (midiDev == null) {
                success = true;
                boolean bl = false;
                return bl;
            }
            this.midiDevice = midiDev;
            this.midiManager.openMidiDevice(this.midiDevice);
            if (type == 1) {
                this.receiver = this.midiDevice.getReceiver();
                if (this.receiver == null) {
                    throw new MidiException("Target MIDI receiver not available: " + midiDevName);
                }
            }
            this.theWrapper = wrapper = context.getGroupWrapper((MidiSyncGroup)syncGroup);
            this.prepareMidiSyncGroup(syncGroup, context);
            success = true;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JMidi engine prepared: " + (Object)((Object)this));
            }
            boolean bl = true;
            return bl;
        }
        catch (MidiException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new MidiException((Throwable)e);
        }
        finally {
            if (!success) {
                try {
                    this.deactivateJMidiDriver(support);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startJMidiDriver() throws MidiException {
        MidiProcessorProxy proxy;
        WrapperOutputPort outPort;
        JMidiEngine jMidiEngine = this;
        synchronized (jMidiEngine) {
            JMidiSupport support = this.jMidiSupport;
            if (support == null) {
                throw new MidiException("MidiEngine is not prepared: " + (Object)((Object)this));
            }
        }
        if (this.theWrapper.isStarted()) {
            throw new MidiException("MidiEngine is already started: " + (Object)((Object)this));
        }
        if (this.theWrapper.getOutputPortCount() > 0 && (outPort = this.theWrapper.getOutputPortAt(0)) != null && (proxy = outPort.getOutputProxy()) != null) {
            this.source = new JMidiSource(this.clock, (MidiProcessor)proxy);
        }
        if (this.source != null) {
            this.midiManager.addMidiListener((MidiListener)this.source, this.midiDevice);
        }
        this.theWrapper.setStarted(true);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JMidi engine started: " + (Object)((Object)this.jMidiDevice));
        }
        this.startMidiEngines(this.midiContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivateJMidiDriver(JMidiSupport support) throws StudioException {
        MidiContextImpl midiContext;
        JMidiEngine jMidiEngine = this;
        synchronized (jMidiEngine) {
            if (this.jMidiSyncGroup == null && this.jMidiSupport == null) {
                return;
            }
            if (support != this.jMidiSupport) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Ignored invalid MidiSupport: " + (Object)((Object)support) + " != " + (Object)((Object)this.jMidiSupport));
                }
                return;
            }
        }
        if (this.source != null) {
            this.midiManager.removeMidiListener((MidiListener)this.source, this.midiDevice);
            this.source = null;
        }
        if (this.receiver != null) {
            this.receiver.close();
            this.receiver = null;
        }
        if ((midiContext = this.midiContext) != null) {
            this.shutdownMidiProcessors(midiContext);
        }
        JMidiEngine jMidiEngine2 = this;
        synchronized (jMidiEngine2) {
            this.midiContext = null;
            this.jMidiSyncGroup = null;
            this.jMidiSupport = null;
            this.theWrapper = null;
        }
        if (support != null) {
            support.reset();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JMIDI engine stopped: " + (Object)((Object)this.jMidiDevice));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MidiDevice getMidiDevice(String midiDeviceName, int type, MidiManager mm) throws StudioException {
        if (midiDeviceName == null) {
            return null;
        }
        try {
            HashSet<String> midiDevNames = new HashSet<String>();
            MidiDevice.Info[] infos = mm.getMidiDeviceInfo();
            for (int i = 0; i < infos.length; ++i) {
                MidiDevice.Info info = infos[i];
                if (info == null) continue;
                try {
                    MidiDevice midiDevice;
                    block13: {
                        midiDevice = mm.getMidiDevice(info);
                        if (midiDevice == null) continue;
                        try {
                            if (type == 0) {
                                int maxTransmitters = midiDevice.getMaxTransmitters();
                                if (maxTransmitters == 0) continue;
                                break block13;
                            }
                            int maxReceivers = midiDevice.getMaxReceivers();
                            if (maxReceivers != 0) break block13;
                            continue;
                        }
                        finally {
                            mm.closeMidiDevice(midiDevice);
                        }
                    }
                    String infoName = info.getName();
                    if (infoName == null) continue;
                    if (!midiDevNames.add(infoName)) {
                        if ((infoName = JMidiDevice.generateUniqueMidiDeviceName(infoName, midiDevNames)) == null) continue;
                        midiDevNames.add(infoName);
                    }
                    if (!midiDeviceName.equals(infoName)) continue;
                    return midiDevice;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        catch (Exception e) {
            throw new MidiException((Throwable)e);
        }
        if (type == 0) {
            throw new MidiException("Midi source device not found: " + midiDeviceName);
        }
        throw new MidiException("Midi dest device not found: " + midiDeviceName);
    }

    protected Receiver getReceiver() {
        return this.receiver;
    }
}

