/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.jmidi;

import com.spacekiller.util.Clock;
import com.spacekiller.util.midi.MidiListener;
import com.waxmonster.midi.MidiProcessor;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;

public class JMidiSource
implements MidiListener {
    private final Clock clock;
    private final MidiProcessor mp;

    public JMidiSource(Clock clock, MidiProcessor target) {
        if (clock == null) {
            throw new IllegalArgumentException("Clock is null");
        }
        if (target == null) {
            throw new IllegalArgumentException("MidiProcessor is null");
        }
        this.clock = clock;
        this.mp = target;
    }

    public void send(MidiEvent event) {
        this.handle(this.clock.nanos(), event.getMessage());
    }

    public void send(MidiMessage mm, long tick) {
        this.handle(this.clock.nanos(), mm);
    }

    protected void handle(long time, MidiMessage mm) {
        if (mm instanceof ShortMessage) {
            this.mp.process(time, (ShortMessage)mm);
            return;
        }
        if (mm instanceof SysexMessage) {
            this.mp.process(time, (SysexMessage)mm);
            return;
        }
    }
}

