/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.jmidi;

import com.spacekiller.util.Clock;
import com.spacekiller.util.midi.MidiFactory;
import com.spacekiller.util.midi.MidiManager;
import com.waxmonster.midi.MidiInputPort;
import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiPort;
import com.waxmonster.midi.MidiSupport;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.midi.impl.MidiEngineConfig;
import com.waxmonster.midi.jmidi.JMidiDevice;
import com.waxmonster.midi.jmidi.JMidiEngine;
import com.waxmonster.midi.jmidi.JMidiSyncGroup;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.Studio;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JMidiSupport
extends MidiSupport {
    private static final Logger logger = Logger.getLogger(JMidiSupport.class.getName());
    private static int shutdownThreadCounter = 0;
    private final String name;
    private final JMidiDevice device;
    private MidiEngineConfig config;
    private JMidiSyncGroup syncGroup;
    private int shutdownTimeoutMillis = 1000;

    public JMidiSupport(String name, JMidiDevice device, MidiEngineConfig config) {
        this.name = name;
        this.device = device;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reset() {
        MidiManager midiMan = null;
        JMidiSupport jMidiSupport = this;
        synchronized (jMidiSupport) {
            if (this.syncGroup != null) {
                midiMan = this.syncGroup.getMidiManager();
                this.syncGroup = null;
            }
        }
        if (midiMan == null) return;
        Class<JMidiSupport> clazz = JMidiSupport.class;
        synchronized (JMidiSupport.class) {
            int threadSuffix = ++shutdownThreadCounter;
            // ** MonitorExit[var3_5] (shouldn't be in output)
            String threadName = "MidiManagerShutdown-" + threadSuffix;
            MidiManagerShutdown mms = new MidiManagerShutdown(midiMan);
            Thread thread = new Thread((Runnable)mms, threadName);
            thread.setDaemon(true);
            thread.start();
            try {
                thread.join(this.shutdownTimeoutMillis);
                if (!thread.isAlive()) return;
                logger.warning("MIDI shutdown timeout! Eventually there is a Midi-Driver problem in the native code! Thread: " + thread);
                return;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            return;
        }
    }

    public synchronized MidiSyncGroup getMidiSyncGroup(MidiPort port) {
        return this.getJMidiSyncGroup();
    }

    public synchronized JMidiSyncGroup getJMidiSyncGroup() {
        if (this.syncGroup == null) {
            MidiInputPort inputPort = null;
            MidiOutputPort outputPort = null;
            JMidiDevice dev = this.device;
            if (dev != null) {
                Port[] ports = dev.getPorts();
                for (int i = 0; i < ports.length; ++i) {
                    Port p = ports[i];
                    if (p == null) continue;
                    if (p instanceof MidiOutputPort) {
                        outputPort = (MidiOutputPort)p;
                        break;
                    }
                    if (!(p instanceof MidiInputPort)) continue;
                    inputPort = (MidiInputPort)p;
                    break;
                }
            }
            Studio studio = this.device.getStudio();
            Clock clock = studio.getClock();
            JMidiEngine engine = new JMidiEngine(this.name, clock, this.config);
            if (inputPort != null) {
                this.syncGroup = new JMidiSyncGroup(this.name, inputPort, engine, this, this.createMidiManager());
            } else if (outputPort != null) {
                this.syncGroup = new JMidiSyncGroup(this.name, outputPort, engine, this, this.createMidiManager());
            }
        }
        return this.syncGroup;
    }

    protected MidiManager createMidiManager() {
        MidiFactory factory = this.device.getMidiFactory();
        if (factory == null) {
            return null;
        }
        return factory.createMidiManager();
    }

    protected final JMidiDevice getJMidiDevice() {
        return this.device;
    }

    protected static class MidiManagerShutdown
    implements Runnable {
        private MidiManager midiManager;

        public MidiManagerShutdown(MidiManager midiManager) {
            this.midiManager = midiManager;
        }

        @Override
        public void run() {
            try {
                this.midiManager.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

