/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.jmidi;

import com.spacekiller.util.midi.MidiManager;
import com.waxmonster.midi.MidiEngine;
import com.waxmonster.midi.MidiException;
import com.waxmonster.midi.MidiInputPort;
import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.midi.jmidi.JMidiEngine;
import com.waxmonster.midi.jmidi.JMidiSupport;
import com.waxmonster.midi.jmidi.JMidiTarget;
import javax.sound.midi.Receiver;

public class JMidiSyncGroup
extends MidiSyncGroup {
    private final JMidiEngine engine;
    private final JMidiSupport support;
    private final MidiManager manager;
    private final MidiInputPort inputPort;
    private final MidiOutputPort outputPort;

    public JMidiSyncGroup(String name, MidiInputPort inputPort, JMidiEngine engine, JMidiSupport support, MidiManager manager) {
        super(name, new MidiInputPort[]{inputPort}, new MidiOutputPort[0], (MidiEngine)engine);
        this.engine = engine;
        this.support = support;
        this.manager = manager;
        this.inputPort = inputPort;
        this.outputPort = null;
    }

    public JMidiSyncGroup(String name, MidiOutputPort outputPort, JMidiEngine engine, JMidiSupport support, MidiManager manager) {
        super(name, new MidiInputPort[0], new MidiOutputPort[]{outputPort}, (MidiEngine)engine);
        this.engine = engine;
        this.support = support;
        this.manager = manager;
        this.inputPort = null;
        this.outputPort = outputPort;
    }

    public void setTargetMidiProcessors(MidiProcessor[] targets) throws MidiException {
    }

    public MidiProcessor createMidiProcessor(MidiInputPort port) throws MidiException {
        Receiver receiver = this.engine.getReceiver();
        if (receiver == null) {
            throw new MidiException("Target MIDI receiver not available: " + (Object)((Object)this.engine));
        }
        return new JMidiTarget(receiver);
    }

    public final JMidiEngine getJMidiEngine() {
        return this.engine;
    }

    public final JMidiSupport getJMidiSupport() {
        return this.support;
    }

    public final MidiManager getMidiManager() {
        return this.manager;
    }

    public final MidiInputPort getMidiInputPort() {
        return this.inputPort;
    }

    public final MidiOutputPort getMidiOutputPort() {
        return this.outputPort;
    }
}

