/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.jmidi;

import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.common.ShortMidiMsg;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;

public class JMidiTarget
implements MidiProcessor {
    private static final Logger logger = Logger.getLogger(JMidiTarget.class.getName());
    private final Receiver receiver;

    public JMidiTarget(Receiver receiver) {
        this.receiver = receiver;
    }

    public void process(long time, int status) {
        block2: {
            try {
                long ts = time / 1000L;
                this.receiver.send((MidiMessage)new ShortMidiMsg(status), ts);
            }
            catch (IllegalStateException e) {
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }
    }

    public void process(long time, int status, int data1) {
        block2: {
            try {
                long ts = time / 1000L;
                this.receiver.send((MidiMessage)new ShortMidiMsg(status, data1), ts);
            }
            catch (IllegalStateException e) {
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }
    }

    public void process(long time, int status, int data1, int data2) {
        block2: {
            try {
                long ts = time / 1000L;
                this.receiver.send((MidiMessage)new ShortMidiMsg(status, data1, data2), ts);
            }
            catch (IllegalStateException e) {
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }
    }

    public void process(long time, ShortMessage sm) {
        block2: {
            try {
                long ts = time / 1000L;
                this.receiver.send(sm, ts);
            }
            catch (IllegalStateException e) {
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }
    }

    public void process(long time, SysexMessage sm) {
        block2: {
            try {
                long ts = time / 1000L;
                this.receiver.send(sm, ts);
            }
            catch (IllegalStateException e) {
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }
    }

    public void shutdown() {
        this.receiver.close();
    }
}

