/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio;

import com.waxmonster.audio.AudioOutputPortType;
import com.waxmonster.audio.AudioPortType;
import com.waxmonster.studio.PortType;
import javax.swing.Icon;

public class AudioInputPortType
extends AudioPortType {
    private static final String MONO_TYPE_NAME = "MonoAudioInput";
    private static final String MONO_TYPE_TOOLTIP = "Mono audio input";
    private static final String[] MONO_TYPE_ICONS = new String[]{"/com/waxmonster/audio/icons/audio_input_mono.png", "/com/waxmonster/audio/icons/audio_input_mono.png"};
    private static final String LEFT_TYPE_NAME = "LeftAudioInput";
    private static final String LEFT_TYPE_TOOLTIP = "Left audio input";
    private static final String[] LEFT_TYPE_ICONS = new String[]{"/com/waxmonster/audio/icons/audio_input_left.png", "/com/waxmonster/audio/icons/audio_input_left.png"};
    private static final String RIGHT_TYPE_NAME = "RightAudioInput";
    private static final String RIGHT_TYPE_TOOLTIP = "Right audio input";
    private static final String[] RIGHT_TYPE_ICONS = new String[]{"/com/waxmonster/audio/icons/audio_input_right.png", "/com/waxmonster/audio/icons/audio_input_right.png"};
    private static final String STEREO_TYPE_NAME = "StereoAudioInput";
    private static final String STEREO_TYPE_TOOLTIP = "Stereo audio input";
    private static final String[] STEREO_TYPE_ICONS = new String[]{"/com/waxmonster/audio/icons/audio_input_stereo.png", "/com/waxmonster/audio/icons/audio_input_stereo.png"};
    public static final AudioInputPortType MONO = new AudioInputPortType("MonoAudioInput", 1, "Mono audio input", AudioInputPortType.getIcons(MONO_TYPE_ICONS));
    public static final AudioInputPortType LEFT = new AudioInputPortType("LeftAudioInput", 1, "Left audio input", AudioInputPortType.getIcons(LEFT_TYPE_ICONS));
    public static final AudioInputPortType RIGHT = new AudioInputPortType("RightAudioInput", 1, "Right audio input", AudioInputPortType.getIcons(RIGHT_TYPE_ICONS));
    public static final AudioInputPortType STEREO = new AudioInputPortType("StereoAudioInput", 2, "Stereo audio input", AudioInputPortType.getIcons(STEREO_TYPE_ICONS));

    public AudioInputPortType(String name, int channels, String tooltip, Icon[] icons) {
        super(name, channels, tooltip, icons);
    }

    public boolean isConnectable(PortType targetType) {
        if (targetType != null && targetType instanceof AudioOutputPortType) {
            AudioOutputPortType type = (AudioOutputPortType)targetType;
            return type.channels == this.channels;
        }
        return false;
    }

    public Object getPreferredLayoutConstraint() {
        return "West";
    }

    public static AudioInputPortType getAudioInputPortType(String typeName) {
        if (MONO_TYPE_NAME.equalsIgnoreCase(typeName)) {
            return MONO;
        }
        if (LEFT_TYPE_NAME.equalsIgnoreCase(typeName)) {
            return LEFT;
        }
        if (RIGHT_TYPE_NAME.equalsIgnoreCase(typeName)) {
            return RIGHT;
        }
        if (STEREO_TYPE_NAME.equalsIgnoreCase(typeName)) {
            return STEREO;
        }
        return null;
    }

    public static AudioInputPortType getAudioInputPortType(int channels) {
        switch (channels) {
            case 1: {
                return MONO;
            }
            case 2: {
                return STEREO;
            }
        }
        return null;
    }
}

