/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio;

import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioOutputPortType;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.studio.Connection;
import com.waxmonster.studio.Port;

public class AudioOutputPort
extends AudioPort {
    private static final AudioInputPort[] NO_PORTS = new AudioInputPort[0];
    private AudioInputPort[] targetPorts = NO_PORTS;

    public AudioOutputPort(String name, AudioOutputPortType portType, AudioSupport support) {
        super(name, portType, support);
    }

    protected void applyProperty(String key, String value) {
    }

    public final boolean isConnectable(Port partner) {
        if (partner == null) {
            return false;
        }
        if (partner instanceof AudioInputPort) {
            AudioInputPort p = (AudioInputPort)partner;
            return p.channels == this.channels;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void connectionAdded(Connection conn) {
        Port partner = conn.getPartner((Port)this);
        if (partner != null && partner instanceof AudioInputPort) {
            AudioInputPort partnerPort = (AudioInputPort)partner;
            AudioOutputPort audioOutputPort = this;
            synchronized (audioOutputPort) {
                AudioInputPort[] arr = new AudioInputPort[this.targetPorts.length + 1];
                System.arraycopy(this.targetPorts, 0, arr, 0, this.targetPorts.length);
                arr[this.targetPorts.length] = partnerPort;
                this.targetPorts = arr;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void connectionRemoved(Connection conn) {
        Port partner = conn.getPartner((Port)this);
        if (partner != null && partner instanceof AudioInputPort) {
            AudioInputPort partnerPort = (AudioInputPort)partner;
            AudioOutputPort audioOutputPort = this;
            synchronized (audioOutputPort) {
                int num = this.targetPorts.length;
                for (int i = 0; i < num; ++i) {
                    if (this.targetPorts[i] != partnerPort) continue;
                    AudioInputPort[] arr = new AudioInputPort[this.targetPorts.length - 1];
                    System.arraycopy(this.targetPorts, 0, arr, 0, i);
                    System.arraycopy(this.targetPorts, i + 1, arr, i, num - i - 1);
                    this.targetPorts = arr;
                    return;
                }
            }
        }
    }
}

