/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio;

import com.waxmonster.audio.AudioInputPortType;
import com.waxmonster.audio.AudioPortType;
import com.waxmonster.studio.PortType;
import javax.swing.Icon;

public class AudioOutputPortType
extends AudioPortType {
    private static final String MONO_TYPE_NAME = "MonoAudioOutput";
    private static final String MONO_TYPE_TOOLTIP = "Mono audio output";
    private static final String[] MONO_TYPE_ICONS = new String[]{"/com/waxmonster/audio/icons/audio_output_mono.png", "/com/waxmonster/audio/icons/audio_output_mono.png"};
    private static final String LEFT_TYPE_NAME = "LeftAudioOutput";
    private static final String LEFT_TYPE_TOOLTIP = "Left audio output";
    private static final String[] LEFT_TYPE_ICONS = new String[]{"/com/waxmonster/audio/icons/audio_output_left.png", "/com/waxmonster/audio/icons/audio_output_left.png"};
    private static final String RIGHT_TYPE_NAME = "RightAudioOutput";
    private static final String RIGHT_TYPE_TOOLTIP = "Right audio output";
    private static final String[] RIGHT_TYPE_ICONS = new String[]{"/com/waxmonster/audio/icons/audio_output_right.png", "/com/waxmonster/audio/icons/audio_output_right.png"};
    private static final String STEREO_TYPE_NAME = "StereoAudioOutput";
    private static final String STEREO_TYPE_TOOLTIP = "Stereo audio output";
    private static final String[] STEREO_TYPE_ICONS = new String[]{"/com/waxmonster/audio/icons/audio_output_stereo.png", "/com/waxmonster/audio/icons/audio_output_stereo.png"};
    public static final AudioOutputPortType MONO = new AudioOutputPortType("MonoAudioOutput", 1, "Mono audio output", AudioOutputPortType.getIcons(MONO_TYPE_ICONS));
    public static final AudioOutputPortType LEFT = new AudioOutputPortType("LeftAudioOutput", 1, "Left audio output", AudioOutputPortType.getIcons(LEFT_TYPE_ICONS));
    public static final AudioOutputPortType RIGHT = new AudioOutputPortType("RightAudioOutput", 1, "Right audio output", AudioOutputPortType.getIcons(RIGHT_TYPE_ICONS));
    public static final AudioOutputPortType STEREO = new AudioOutputPortType("StereoAudioOutput", 2, "Stereo audio output", AudioOutputPortType.getIcons(STEREO_TYPE_ICONS));

    public AudioOutputPortType(String name, int channels, String tooltip, Icon[] icons) {
        super(name, channels, tooltip, icons);
    }

    public boolean isConnectable(PortType targetType) {
        if (targetType != null && targetType instanceof AudioInputPortType) {
            AudioInputPortType type = (AudioInputPortType)targetType;
            return type.channels == this.channels;
        }
        return false;
    }

    public Object getPreferredLayoutConstraint() {
        return "East";
    }

    public static AudioOutputPortType getAudioOutputPortType(String typeName) {
        if (MONO_TYPE_NAME.equalsIgnoreCase(typeName)) {
            return MONO;
        }
        if (LEFT_TYPE_NAME.equalsIgnoreCase(typeName)) {
            return LEFT;
        }
        if (RIGHT_TYPE_NAME.equalsIgnoreCase(typeName)) {
            return RIGHT;
        }
        if (STEREO_TYPE_NAME.equalsIgnoreCase(typeName)) {
            return STEREO;
        }
        return null;
    }

    public static AudioOutputPortType getAudioOutputPortType(int channels) {
        switch (channels) {
            case 1: {
                return MONO;
            }
            case 2: {
                return STEREO;
            }
        }
        return null;
    }
}

