/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio;

import com.waxmonster.audio.AudioInputPortType;
import com.waxmonster.audio.AudioOutputPortType;
import com.waxmonster.studio.AbstractPortType;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class AudioPortType
extends AbstractPortType {
    protected final String name;
    protected final String tooltip;
    protected final Icon[] icons;
    protected final int channels;

    public AudioPortType(String name, int channels, String tooltip, Icon[] icons) {
        this.name = name;
        this.channels = channels;
        this.tooltip = tooltip;
        this.icons = icons;
    }

    public final String getName() {
        return this.name;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public Icon getIcon(int iconKind) {
        if (iconKind < 0 || iconKind >= this.icons.length) {
            return null;
        }
        return this.icons[iconKind];
    }

    public final int getChannels() {
        return this.channels;
    }

    static Icon[] getIcons(String[] resources) {
        int n = resources.length;
        Icon[] icons = new Icon[n];
        for (int i = 0; i < n; ++i) {
            URL url = AudioPortType.class.getResource(resources[i]);
            if (url == null) continue;
            icons[i] = new ImageIcon(url);
        }
        return icons;
    }

    public String toString() {
        return String.valueOf(this.name);
    }

    public static AudioPortType getAudioPortType(String typeName) {
        AudioInputPortType apt = AudioInputPortType.getAudioInputPortType(typeName);
        if (apt != null) {
            return apt;
        }
        return AudioOutputPortType.getAudioOutputPortType(typeName);
    }
}

