/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioEngine;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioProcessor;

public abstract class AudioSyncGroup {
    protected final String name;
    private final AudioInputPort[] inputs;
    private final AudioOutputPort[] outputs;
    private final AudioEngine engine;

    public AudioSyncGroup(String name, AudioInputPort[] inputPorts, AudioOutputPort[] outputPorts) {
        this(name, inputPorts, outputPorts, null);
    }

    public AudioSyncGroup(String name, AudioInputPort[] inputPorts, AudioOutputPort[] outputPorts, AudioEngine engine) {
        this.name = name;
        this.inputs = inputPorts;
        this.outputs = outputPorts;
        this.engine = engine;
    }

    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }

    public final String getName() {
        return this.name;
    }

    public final int getInputPortCount() {
        return this.inputs.length;
    }

    public final AudioInputPort getInputPortAt(int index) {
        return this.inputs[index];
    }

    public final int getInputPortIndex(AudioInputPort port) {
        for (int i = 0; i < this.inputs.length; ++i) {
            if (port != this.inputs[i]) continue;
            return i;
        }
        return -1;
    }

    public final int getOutputPortCount() {
        return this.outputs.length;
    }

    public final AudioOutputPort getOutputPortAt(int index) {
        return this.outputs[index];
    }

    public final int getOutputPortIndex(AudioOutputPort port) {
        for (int i = 0; i < this.outputs.length; ++i) {
            if (port != this.outputs[i]) continue;
            return i;
        }
        return -1;
    }

    public final AudioEngine getAudioEngine() {
        return this.engine;
    }

    public abstract AudioProcessor createAudioProcessor(SampleBuffer[] var1, SampleBuffer[] var2) throws AudioException;
}

