/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.locale;

import com.spacekiller.util.Filter;
import com.spacekiller.util.Tools;
import com.spacekiller.util.locale.LocaleUtil;
import com.spacekiller.util.swing.AbstractCellRenderer;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CountryChooser
extends JPanel {
    private static final long serialVersionUID = 4759938111196182886L;
    private String selectedCountry;
    private Filter countryFilter;
    private transient ActionListener actionListeners;
    private transient List changeListeners;
    private JScrollPane jScrollPane = null;
    private JList jList = null;

    public CountryChooser() {
        this.initialize();
        this.initCountryChooser();
    }

    private void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.setRows(1);
        this.setLayout(gridLayout);
        this.setSize(new Dimension(262, 247));
        this.add((Component)this.getJScrollPane(), null);
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners == null) {
            return;
        }
        this.actionListeners.actionPerformed(e);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.add(this.actionListeners, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.remove(this.actionListeners, listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])AWTEventMulticaster.getListeners((EventListener)this.actionListeners, ActionListener.class);
    }

    protected void fireStateChanged(ChangeEvent e) {
        if (this.changeListeners == null) {
            return;
        }
        int currentSize = this.changeListeners.size();
        for (int index = 0; index < currentSize; ++index) {
            ChangeListener ls = (ChangeListener)this.changeListeners.get(index);
            if (ls == null) continue;
            ls.stateChanged(e);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new LinkedList();
        }
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(listener);
        }
    }

    public ChangeListener[] getChangeListeners() {
        if (this.changeListeners == null) {
            return new ChangeListener[0];
        }
        return this.changeListeners.toArray(new ChangeListener[this.changeListeners.size()]);
    }

    public String getSelectedCountry() {
        return this.selectedCountry;
    }

    public void setSelectedCountry(String selectedCountry) {
        this.selectedCountry = selectedCountry;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setOpaque(false);
            this.jScrollPane.setViewportView(this.getJList());
        }
        return this.jScrollPane;
    }

    private JList getJList() {
        if (this.jList == null) {
            this.jList = new JList();
            this.jList.setOpaque(false);
            this.jList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    CountryChooser.this.handleSelectionChanged();
                }
            });
            this.jList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        CountryChooser.this.handleDoubleClick();
                    }
                }
            });
        }
        return this.jList;
    }

    public Filter getCountryFilter() {
        return this.countryFilter;
    }

    public void setCountryFilter(Filter countryFilter) {
        this.countryFilter = countryFilter;
        this.refresh();
    }

    protected void refresh() {
        String oldSelected = this.getSelectedCountry();
        TreeSet<Locale> set = new TreeSet<Locale>(new CountryComparator());
        String[] countries = Locale.getISOCountries();
        if (countries != null) {
            Filter filter = this.countryFilter;
            for (int i = 0; i < countries.length; ++i) {
                String country = countries[i];
                if (country == null || filter != null && !filter.accept((Object)country)) continue;
                Locale locale = new Locale("", country);
                set.add(locale);
            }
        }
        DefaultListModel model = new DefaultListModel();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            model.addElement(i.next());
        }
        this.getJList().setModel(model);
        this.selectCountry(oldSelected);
    }

    private void selectCountry(String country) {
        ListModel model = this.getJList().getModel();
        if (model == null) {
            return;
        }
        int index = -1;
        if (country != null) {
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                String ctry = (String)model.getElementAt(i);
                if (!country.equals(ctry)) continue;
                index = i;
                break;
            }
        }
        if (index >= 0) {
            this.getJList().setSelectedIndex(index);
            Rectangle rect = this.getJList().getCellBounds(index, index);
            if (rect != null) {
                this.getJList().scrollRectToVisible(rect);
            }
        } else {
            this.getJList().clearSelection();
        }
    }

    public String showDialog(Component owner, String title) {
        Window win;
        JDialog dialog = null;
        if (owner != null && (win = SwingUtilities.getWindowAncestor(owner)) != null) {
            if (win instanceof Frame) {
                dialog = new JDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new JDialog((Dialog)win);
            }
        }
        if (dialog == null) {
            dialog = new JDialog();
        }
        this.getJList().setSelectionMode(0);
        final JDialog dialogFinal = dialog;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialogFinal.dispose();
            }
        });
        dialog.setTitle(title);
        dialog.setContentPane(this);
        dialog.pack();
        Tools.centerWindow((Component)owner, (Window)dialog);
        dialog.setModal(true);
        dialog.setVisible(true);
        return this.getSelectedCountry();
    }

    protected void initCountryChooser() {
        this.getJList().setCellRenderer(new CountryListCellRenderer());
        this.setPreferredSize(new Dimension(250, 350));
        this.refresh();
    }

    private void handleSelectionChanged() {
        int sel = this.getJList().getSelectedIndex();
        if (sel >= 0) {
            String country = null;
            Object value = this.getJList().getModel().getElementAt(sel);
            if (value != null && value instanceof Locale) {
                country = ((Locale)value).getCountry();
            }
            this.setSelectedCountry(country);
        }
        this.fireStateChanged(new ChangeEvent(this));
    }

    private void handleDoubleClick() {
        ActionEvent ev = new ActionEvent(this, 1001, "action");
        this.fireActionPerformed(ev);
    }

    public static class CountryListCellRenderer
    extends AbstractCellRenderer
    implements ListCellRenderer {
        private static final long serialVersionUID = 2761111683732224451L;
        private JLabel label = new JLabel();

        public CountryListCellRenderer() {
            this.setOpaque(false);
            this.setLayout(new GridLayout(1, 1));
            this.add(this.label);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setSelected(isSelected);
            this.setFocus(cellHasFocus);
            String text = null;
            Icon icon = null;
            if (value != null && value instanceof Locale) {
                Locale locale = (Locale)value;
                String country = locale.getCountry();
                text = locale.getDisplayCountry();
                icon = LocaleUtil.getInstance().getCountryIcon(country);
            }
            if (text == null) {
                text = "";
            }
            this.label.setText(text);
            this.label.setIcon(icon);
            return this;
        }
    }

    public static class CountryComparator
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            Locale loc0 = (Locale)arg0;
            Locale loc1 = (Locale)arg1;
            String name0 = loc0.getDisplayCountry();
            String name1 = loc1.getDisplayCountry();
            if (name0 == null) {
                return -1;
            }
            if (name1 == null) {
                return 1;
            }
            int rc = name0.compareToIgnoreCase(name1);
            if (rc != 0) {
                return rc;
            }
            return -1;
        }
    }
}

