/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WaxMonsterClassPreloader {
    private static final Logger logger = Logger.getLogger(WaxMonsterClassPreloader.class.getName());
    private static final String PRELOAD_PATH = "/preloadclasses.txt";
    private static final String SRC_MAIN_RESOURCES = "/src/main/resources/";
    private static final String SRC_MAIN_JAVA = "src.main.java.";
    private static final String TARGET_CLASSES = "target.classes.";

    public static void main(String[] args) {
        try {
            String workspacePath = "../";
            String outputFilePath = workspacePath + "/waxmonster_studio_dist/" + SRC_MAIN_RESOURCES + "/" + PRELOAD_PATH;
            workspacePath = new File(workspacePath).getCanonicalPath();
            String fileSep = File.separator;
            char fileSepChar = File.separatorChar;
            logger.info("Scanning class files: " + workspacePath);
            ArrayList paths = new ArrayList();
            WaxMonsterClassPreloader.scanClasses(new File(workspacePath), paths);
            logger.info("Total classes: " + paths.size());
            TreeSet<String> classes = new TreeSet<String>();
            for (String path : paths) {
                if (path.startsWith(workspacePath)) {
                    path = path.substring(workspacePath.length());
                }
                if (path.startsWith(fileSep)) {
                    path = path.substring(fileSep.length());
                }
                boolean include = false;
                if (path.startsWith("mmutil_sound")) {
                    include = true;
                }
                if (path.startsWith("mmutil_thread")) {
                    include = true;
                }
                if (path.startsWith("mmutil_timer")) {
                    include = true;
                }
                if (path.startsWith("waxmonster_studio")) {
                    include = true;
                }
                if (path.startsWith("waxmonster_audio")) {
                    include = true;
                }
                if (path.startsWith("waxmonster_fader")) {
                    include = true;
                }
                if (path.startsWith("waxmonster_timecode")) {
                    include = true;
                }
                if (path.startsWith("waxmonster_model")) {
                    include = true;
                }
                if (path.startsWith("waxmonster_scratch")) {
                    include = true;
                }
                if (path.startsWith("waxmonster_waxlab")) {
                    include = true;
                }
                if (!include) continue;
                String className = path;
                int x = className.indexOf(fileSep);
                if (x >= 0) {
                    className = className.substring(x + fileSep.length());
                }
                if ((className = className.replace(fileSepChar, '.')).endsWith(".class")) {
                    className = className.substring(0, className.length() - 6);
                }
                if (className.startsWith(SRC_MAIN_JAVA)) {
                    className = className.substring(SRC_MAIN_JAVA.length());
                }
                if (className.startsWith(TARGET_CLASSES)) {
                    className = className.substring(TARGET_CLASSES.length());
                }
                classes.add(className);
            }
            logger.info("WaxMonster classes: " + classes.size());
            File outFile = new File(outputFilePath);
            logger.info("Output file: " + outFile.getAbsolutePath());
            FileWriter writer = new FileWriter(outFile);
            for (String name : classes) {
                writer.write(name);
                writer.write("\n");
            }
            writer.close();
            logger.info("Output file written.");
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected static void scanClasses(File file, List dest) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    WaxMonsterClassPreloader.scanClasses(files[i], dest);
                }
            }
        } else if (file.isFile() && file.getName().endsWith(".class")) {
            dest.add(file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preloadClasses(List dest) throws IOException {
        block14: {
            URL url = this.getClass().getResource(PRELOAD_PATH);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Preloading classes: " + url);
            }
            InputStream in = url.openStream();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                block9: while (true) {
                    while (true) {
                        String name;
                        if ((name = reader.readLine()) == null) {
                            break block14;
                        }
                        try {
                            Class clazz = this.preloadClass(name);
                            if (clazz == null) continue block9;
                            dest.add(clazz);
                        }
                        catch (ClassNotFoundException e) {
                            if (!logger.isLoggable(Level.FINE)) continue;
                            logger.fine("Class not found: " + name);
                        }
                        catch (Throwable e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    break;
                }
                finally {
                    reader.close();
                }
            }
            finally {
                in.close();
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Number of preloaded classes: " + dest.size());
        }
    }

    protected Class preloadClass(String name) throws ClassNotFoundException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("preloadClass: " + name);
        }
        return Class.forName(name);
    }
}

