/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.plugin;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.tooling.TAction;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewProvider;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchAction;
import com.spacekiller.util.workbench.WorkbenchPlugin;
import com.spacekiller.util.workbench.WorkbenchToolContext;
import com.spacekiller.util.workbench.WorkbenchUtilities;
import com.waxmonster.midi.common.MidiMapperComponent;
import com.waxmonster.studio.plugin.WaxMonsterPlugin;
import com.waxmonster.studio.plugin.WaxMonsterPreferences;
import com.waxmonster.studio.plugin.WaxMonsterPreferencesPage;
import com.waxmonster.studio.plugin.WaxMonsterTemplate;
import com.waxmonster.studio.plugin.WaxMonsterTemplateChooser;
import com.waxmonster.studio.view.DeviceCustomizerView;
import com.waxmonster.studio.view.StudioPanel;
import com.waxmonster.studio.view.StudioView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JInternalFrame;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class WaxMonsterExtensions {
    private static final Logger logger = Logger.getLogger(WaxMonsterExtensions.class.getName());
    private static File currentDirectory;
    private static MidiMapperComponent midiMapperComponent;

    private WaxMonsterExtensions() {
    }

    protected static void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    public static void actionFileNew(ToolContext ctx, Workbench wb) {
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("actionFileNew: wb=" + wb);
            }
            WaxMonsterTemplate[] templates = WaxMonsterPlugin.getInstance().getWaxMonsterTemplates();
            Arrays.sort(templates, new TemplateComparator());
            Component parent = WaxMonsterExtensions.getPerspectiveComponent(wb);
            String title = "New Studio Project";
            WaxMonsterTemplateChooser templateChooser = new WaxMonsterTemplateChooser();
            templateChooser.setIncludeEmptyTemplate(true);
            templateChooser.setTemplates(templates);
            templateChooser.setPreferredSize(new Dimension(400, 300));
            boolean ok = templateChooser.showDialog(parent, title);
            if (!ok) {
                return;
            }
            WaxMonsterTemplate selectedTemplate = templateChooser.getSelectedTemplate();
            WaxMonsterExtensions.newStudioProject(wb, selectedTemplate);
        }
        catch (Throwable e) {
            WaxMonsterExtensions.handleException(e);
        }
    }

    protected static Component getPerspectiveComponent(Workbench wb) {
        Perspective pers;
        if (wb != null && (pers = wb.getPerspective()) != null) {
            return pers.getComponent();
        }
        return null;
    }

    public static void actionFileOpen(ToolContext ctx, Workbench wb) {
        try {
            File currentFile;
            Component parent;
            File file;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("actionFileOpen: wb=" + wb);
            }
            if ((file = StudioPanel.showFileOpenDialog((Component)(parent = WaxMonsterExtensions.getPerspectiveComponent(wb)), (File)currentDirectory, currentFile = null)) == null) {
                return;
            }
            File curr = file;
            if (curr != null && curr.isFile()) {
                curr = curr.getParentFile();
            }
            if (curr != null && (curr = curr.getParentFile()) != null) {
                currentDirectory = curr;
            }
            boolean autoStartStudio = false;
            WaxMonsterExtensions.openStudioProject(wb, file, autoStartStudio);
        }
        catch (Throwable e) {
            WaxMonsterExtensions.handleException(e);
        }
    }

    protected static boolean openStudioProject(Workbench wb, File file, boolean autoStartStudio) throws Exception {
        if (wb == null) {
            return false;
        }
        StudioView studioView = WaxMonsterExtensions.createStudioView(wb);
        if (studioView == null) {
            return false;
        }
        if (file != null) {
            StudioPanel studioPanel = studioView.getStudioPanel();
            if (studioPanel != null) {
                studioPanel.openStudio(file, autoStartStudio);
            }
            WaxMonsterExtensions.rememberRecentFile(file);
        }
        return true;
    }

    protected static boolean newStudioProject(Workbench wb, WaxMonsterTemplate template) throws Exception {
        if (wb == null) {
            return false;
        }
        String templatePath = null;
        if (template != null) {
            templatePath = template.getPath();
        }
        URL studioZipURL = null;
        if (templatePath != null && (studioZipURL = WaxMonsterExtensions.class.getResource(templatePath)) == null) {
            throw new IOException("Studio project file resource not found: " + templatePath);
        }
        StudioView studioView = WaxMonsterExtensions.createStudioView(wb);
        if (studioView == null) {
            return false;
        }
        StudioPanel studioPanel = studioView.getStudioPanel();
        if (studioPanel != null) {
            studioPanel.importStudio(studioZipURL);
        }
        return true;
    }

    protected static StudioView createStudioView(Workbench wb) throws Exception {
        WorkbenchPlugin wbPlugin = WorkbenchUtilities.getWorkbenchPlugin();
        if (wbPlugin == null) {
            return null;
        }
        ViewProvider studioViewProvider = wbPlugin.getViewProvider("StudioViewProvider");
        if (studioViewProvider == null) {
            return null;
        }
        View newView = studioViewProvider.createView();
        if (newView != null && newView instanceof StudioView) {
            StudioView studioView = (StudioView)newView;
            studioView.setStudioWorkbench(wb);
            return studioView;
        }
        return null;
    }

    public static void actionFileSave(ToolContext ctx, Workbench wb) {
        try {
            StudioView studioView = WaxMonsterExtensions.getStudioView(ctx);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("actionFileSave: context=" + ctx + ", studioView=" + studioView);
            }
            if (studioView == null) {
                return;
            }
            StudioPanel studioPanel = studioView.getStudioPanel();
            studioPanel.saveStudio();
        }
        catch (Throwable e) {
            WaxMonsterExtensions.handleException(e);
        }
    }

    public static void actionFileSaveAs(ToolContext ctx, Workbench wb) {
        try {
            StudioView studioView = WaxMonsterExtensions.getStudioView(ctx);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("actionFileSaveAs: context=" + ctx + ", studioView=" + studioView);
            }
            if (studioView == null) {
                return;
            }
            StudioPanel studioPanel = studioView.getStudioPanel();
            studioPanel.saveStudioAs();
        }
        catch (Throwable e) {
            WaxMonsterExtensions.handleException(e);
        }
    }

    public static void actionExportStudio(ToolContext ctx, Workbench wb) {
        try {
            StudioView studioView = WaxMonsterExtensions.getStudioView(ctx);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("actionExportProject: context=" + ctx + ", studioView=" + studioView);
            }
            if (studioView == null) {
                return;
            }
            StudioPanel studioPanel = studioView.getStudioPanel();
            studioPanel.exportStudio();
        }
        catch (Throwable e) {
            WaxMonsterExtensions.handleException(e);
        }
    }

    public static void actionImportStudio(ToolContext ctx, Workbench wb) {
        try {
            StudioView studioView = WaxMonsterExtensions.getStudioView(ctx);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("actionImportProject: context=" + ctx + ", studioView=" + studioView);
            }
            if (studioView == null) {
                return;
            }
            StudioPanel studioPanel = studioView.getStudioPanel();
            studioPanel.importStudio();
        }
        catch (Throwable e) {
            WaxMonsterExtensions.handleException(e);
        }
    }

    public static void actionMidiMapper(Object instance, ToolContext ctx) {
        try {
            Component comp = null;
            Window window = null;
            if (instance != null && instance instanceof Component) {
                comp = (Component)instance;
                window = SwingUtilities.getWindowAncestor(comp);
            }
            if (window == null) {
                return;
            }
            RootPaneContainer rootPaneContainer = null;
            if (window instanceof RootPaneContainer) {
                rootPaneContainer = (RootPaneContainer)((Object)window);
            }
            if (rootPaneContainer == null) {
                return;
            }
            WaxMonsterExtensions.sendStudioPanelToBack(comp);
            midiMapperComponent.showMidiMapper(rootPaneContainer);
        }
        catch (Throwable e) {
            WaxMonsterExtensions.handleException(e);
        }
    }

    protected static boolean sendStudioPanelToBack(Component comp) {
        while (comp != null) {
            if (comp instanceof JInternalFrame) {
                JInternalFrame frame = (JInternalFrame)comp;
                frame.toBack();
                return true;
            }
            comp = comp.getParent();
        }
        return false;
    }

    public static StudioView getStudioView(ToolContext ctx) {
        View view;
        Perspective pers;
        WorkbenchToolContext wtc;
        Workbench wb;
        if (ctx != null && ctx instanceof WorkbenchToolContext && (wb = (wtc = (WorkbenchToolContext)ctx).getWorkbench()) != null && (pers = wb.getPerspective()) != null && (view = pers.getSelectedView()) != null) {
            if (view instanceof StudioView) {
                return (StudioView)view;
            }
            if (view instanceof DeviceCustomizerView) {
                DeviceCustomizerView dcv = (DeviceCustomizerView)view;
                return dcv.getStudioView();
            }
        }
        return null;
    }

    protected static void rememberRecentFile(File file) throws Exception {
        PreferencesRegistry registry = Platform.getInstance().getPreferencesRegistry();
        Preferences waxMonsterPrefs = registry.getPreferences("waxmonster");
        if (waxMonsterPrefs == null) {
            logger.log(Level.WARNING, "WaxMonsterPreferences not available: waxmonster");
            return;
        }
        WaxMonsterPreferences waxMonsterPreferences = WaxMonsterPreferencesPage.getWaxMonsterPreferences(waxMonsterPrefs);
        if (waxMonsterPreferences != null) {
            String[] recentPaths;
            String path;
            int maxPaths = waxMonsterPreferences.getMaxRecentProjects();
            ArrayList<String> pathList = new ArrayList<String>();
            HashSet<String> pathSet = new HashSet<String>();
            if (file != null && (path = file.getPath()) != null && pathList.size() < maxPaths && pathSet.add(path)) {
                pathList.add(path);
            }
            if ((recentPaths = waxMonsterPreferences.getRecentProjectPaths()) != null) {
                for (int i = 0; i < recentPaths.length; ++i) {
                    String path2 = recentPaths[i];
                    if (path2 == null || pathList.size() >= maxPaths || !pathSet.add(path2)) continue;
                    pathList.add(path2);
                }
            }
            recentPaths = pathList.toArray(new String[pathList.size()]);
            waxMonsterPreferences.setRecentProjectPaths(recentPaths);
            WaxMonsterPreferencesPage.setWaxMonsterPreferences(waxMonsterPreferences, waxMonsterPrefs);
            registry.savePreferences(waxMonsterPrefs);
        }
    }

    static {
        midiMapperComponent = new MidiMapperComponent();
    }

    protected static class TemplateComparator
    implements Comparator {
        protected TemplateComparator() {
        }

        public int compare(Object o1, Object o2) {
            int h2;
            double p2;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return o1 == null ? 0 : 1;
            }
            WaxMonsterTemplate t1 = (WaxMonsterTemplate)o1;
            WaxMonsterTemplate t2 = (WaxMonsterTemplate)o2;
            double p1 = t1.getPriority();
            if (p1 < (p2 = t2.getPriority())) {
                return 1;
            }
            if (p1 > p2) {
                return -1;
            }
            int h1 = t1.hashCode();
            if (h1 < (h2 = t2.hashCode())) {
                return -1;
            }
            if (h1 > h2) {
                return 1;
            }
            return 0;
        }
    }

    public static class MidiMapperAction
    extends TAction {
        public void invoke(Object instance) {
            ToolContext ctx = this.getToolContext(instance);
            WaxMonsterExtensions.actionMidiMapper(instance, ctx);
        }
    }

    public static class ImportStudioAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            ToolContext ctx = this.getToolContext(instance);
            Workbench wb = this.getWorkbench(instance);
            WaxMonsterExtensions.actionImportStudio(ctx, wb);
        }
    }

    public static class ExportStudioAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            ToolContext ctx = this.getToolContext(instance);
            Workbench wb = this.getWorkbench(instance);
            WaxMonsterExtensions.actionExportStudio(ctx, wb);
        }
    }

    public static class FileSaveAsAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            ToolContext ctx = this.getToolContext(instance);
            Workbench wb = this.getWorkbench(instance);
            WaxMonsterExtensions.actionFileSaveAs(ctx, wb);
        }
    }

    public static class FileSaveAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            ToolContext ctx = this.getToolContext(instance);
            Workbench wb = this.getWorkbench(instance);
            WaxMonsterExtensions.actionFileSave(ctx, wb);
        }
    }

    public static class FileOpenAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            ToolContext ctx = this.getToolContext(instance);
            Workbench wb = this.getWorkbench(instance);
            WaxMonsterExtensions.actionFileOpen(ctx, wb);
        }
    }

    public static class FileNewAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            ToolContext ctx = this.getToolContext(instance);
            Workbench wb = this.getWorkbench(instance);
            WaxMonsterExtensions.actionFileNew(ctx, wb);
        }
    }
}

