/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.plugin;

import java.io.File;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WaxMonsterMain {
    private static final String PLATFORM_MAIN_CLASS_NAME = "com.spacekiller.infection.platform.InfectionPlatform";
    private static final Logger logger = Logger.getLogger(WaxMonsterMain.class.getName());
    private static WaxMonsterMain INSTANCE;
    private File projectFileToLoad;

    protected WaxMonsterMain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static WaxMonsterMain getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<WaxMonsterMain> clazz = WaxMonsterMain.class;
        synchronized (WaxMonsterMain.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new WaxMonsterMain();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static void main(String[] args) {
        try {
            WaxMonsterMain.getInstance().launch(args);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    protected void launch(String[] args) throws Exception {
        int i;
        int argCount;
        int n = argCount = args == null ? 0 : args.length;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Launching Wax-Monster Studio...");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Main arguments: " + argCount);
                for (i = 0; i < argCount; ++i) {
                    logger.fine("Argument #" + i + " = " + args[i]);
                }
            }
        }
        this.projectFileToLoad = null;
        if (argCount > 0) {
            for (i = 0; i < argCount; ++i) {
                String path;
                String arg = args[i];
                if (arg == null) continue;
                if (arg.startsWith("-")) {
                    if (!arg.startsWith("--")) continue;
                    continue;
                }
                if (i == argCount - 1 && (path = arg) != null && path.trim().length() > 0) {
                    File file = new File(path);
                    if (file.exists() && file.isFile()) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Project file to load: " + file);
                        }
                        this.projectFileToLoad = file;
                        continue;
                    }
                    logger.warning("File not found: " + file);
                }
                logger.warning("Invalid main argument #" + i + ": " + arg);
            }
        }
        String[] mainArgs = new String[]{};
        Class<?> mainClass = Class.forName(PLATFORM_MAIN_CLASS_NAME);
        Method mainMethod = mainClass.getMethod("main", String[].class);
        mainMethod.invoke(null, new Object[]{mainArgs});
    }

    protected File getProjectFileToLoad() {
        return this.projectFileToLoad;
    }
}

