/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.plugin;

import com.spacekiller.util.Extension;
import com.spacekiller.util.ExtensionPoint;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Plugin;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchUtilities;
import com.waxmonster.studio.plugin.WaxMonsterClassPreloader;
import com.waxmonster.studio.plugin.WaxMonsterExtensions;
import com.waxmonster.studio.plugin.WaxMonsterMain;
import com.waxmonster.studio.plugin.WaxMonsterPreferences;
import com.waxmonster.studio.plugin.WaxMonsterPreferencesPage;
import com.waxmonster.studio.plugin.WaxMonsterTemplate;
import com.waxmonster.studio.view.StudioViewProvider;
import java.beans.beancontext.BeanContext;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WaxMonsterPlugin
extends Plugin {
    private static final Logger logger = Logger.getLogger(WaxMonsterPlugin.class.getName());
    public static final String WAXMONSTER_PLUGIN_ID = "com.waxmonster.studio.plugin.WaxMonsterPlugin";
    public static final String POINT_WAXMONSTER_TEMPLATE = "com.waxmonster.studio.plugin.WaxMonsterTemplate";
    private List preloadedClasses = new ArrayList();
    private File projectFileToLoad = null;
    private boolean autoStartStudio = false;
    private List waxMonsterTemplates = new ArrayList();

    public static WaxMonsterPlugin getInstance() throws Exception {
        return (WaxMonsterPlugin)Platform.getInstance().getPlugin(WAXMONSTER_PLUGIN_ID);
    }

    protected void startup() {
        super.startup();
        this.startupWaxMonster();
    }

    protected void shutdown() {
        super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extensionAvailable(ExtensionPoint point, Extension x) {
        super.extensionAvailable(point, x);
        String pointId = point.getId();
        if (POINT_WAXMONSTER_TEMPLATE.equals(pointId)) {
            block8: {
                try {
                    Object obj = this.getExtensionInstance(x);
                    if (obj instanceof WaxMonsterTemplate) {
                        WaxMonsterTemplate template = (WaxMonsterTemplate)obj;
                        List list = this.waxMonsterTemplates;
                        synchronized (list) {
                            this.waxMonsterTemplates.add(template);
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("WaxMonsterTemplate: " + template);
                        }
                        break block8;
                    }
                    logger.warning("Invalid WaxMonsterTemplate class: " + obj.getClass().getName());
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            return;
        }
        logger.info("extensionAvailable: " + x);
    }

    protected void extensionUnavailable(ExtensionPoint point, Extension x) {
        super.extensionUnavailable(point, x);
        logger.info("extensionUnavailable: " + x);
    }

    protected void startupWaxMonster() {
        try {
            boolean preloadClasses = true;
            WaxMonsterMain waxMonsterMain = WaxMonsterMain.getInstance();
            this.projectFileToLoad = waxMonsterMain.getProjectFileToLoad();
            this.autoStartStudio = false;
            WaxMonsterPreferences waxMonsterPreferences = null;
            PreferencesRegistry registry = Platform.getInstance().getPreferencesRegistry();
            try {
                Preferences waxMonsterPrefs = registry.getPreferences("waxmonster");
                waxMonsterPreferences = WaxMonsterPreferencesPage.getWaxMonsterPreferences(waxMonsterPrefs);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            boolean none = true;
            if (waxMonsterPreferences != null) {
                preloadClasses = waxMonsterPreferences.isPreloadClasses();
                boolean loadDefaultProject = waxMonsterPreferences.isLoadDefaultProject();
                if (loadDefaultProject && this.projectFileToLoad == null) {
                    none = false;
                    File defProjectFile = null;
                    int defaultProjectType = waxMonsterPreferences.getDefaultProjectType();
                    switch (defaultProjectType) {
                        case 0: {
                            none = true;
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 3: {
                            String path = waxMonsterPreferences.getDefaultProjectPath();
                            if (path == null || path.trim().length() <= 0) break;
                            defProjectFile = new File(path);
                            break;
                        }
                        default: {
                            String path;
                            String[] recentPaths = waxMonsterPreferences.getRecentProjectPaths();
                            if (recentPaths == null || recentPaths.length <= 0 || (path = recentPaths[0]) == null || path.trim().length() <= 0) break;
                            defProjectFile = new File(path);
                        }
                    }
                    if (defProjectFile != null) {
                        this.projectFileToLoad = defProjectFile;
                        this.autoStartStudio = waxMonsterPreferences.isAutoStartDefaultProject();
                    }
                }
            }
            if (!none) {
                StudioViewProvider.setLoadViewDisabled((boolean)true);
                Thread hook = new Thread((Runnable)new PostStartup(), "WaxLabPlugin");
                Platform.getInstance().addPostStartupHook(hook);
            }
            logger.info("preloadClasses: " + preloadClasses);
            if (preloadClasses) {
                WaxMonsterClassPreloader preloader = new WaxMonsterClassPreloader();
                preloader.preloadClasses(this.preloadedClasses);
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void postStartupWaxMonster() {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("postStartupWaxMonster...");
            }
            if (this.projectFileToLoad != null) {
                Workbench workbench = this.lookupWaxMonsterWorkbench();
                if (workbench == null) {
                    logger.warning("Workbench not available!");
                } else {
                    WaxMonsterExtensions.openStudioProject(workbench, this.projectFileToLoad, this.autoStartStudio);
                }
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected Workbench lookupWaxMonsterWorkbench() throws Exception {
        Workbench workbench = null;
        BeanContext perspectives = WorkbenchUtilities.getWorkbenchPlugin().getPerspectives();
        for (Object obj : perspectives) {
            Perspective pers;
            if (obj != null && obj instanceof Perspective && (workbench = (pers = (Perspective)obj).getWorkbench()) != null) break;
        }
        return workbench;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WaxMonsterTemplate[] getWaxMonsterTemplates() {
        List list = this.waxMonsterTemplates;
        synchronized (list) {
            return this.waxMonsterTemplates.toArray(new WaxMonsterTemplate[this.waxMonsterTemplates.size()]);
        }
    }

    protected class PostStartup
    implements Runnable {
        protected PostStartup() {
        }

        @Override
        public void run() {
            WaxMonsterPlugin.this.postStartupWaxMonster();
        }
    }
}

