/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.plugin;

import com.spacekiller.util.Platform;
import com.waxmonster.studio.plugin.WaxMonsterJavaRuntimeWizard;
import com.waxmonster.studio.plugin.WaxMonsterPreferences;
import com.waxmonster.studio.view.StudioPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class WaxMonsterPreferencesPanel
extends JPanel {
    private static final long serialVersionUID = 2236007983825563321L;
    private WaxMonsterPreferences waxMonsterPreferences;
    private boolean refreshing = false;
    private JCheckBox chckbxPreloadClasses;
    private JTextField textFieldDefaultProject;
    private JButton btnBrowseProject;
    private JRadioButton rdbtnDefaultProject;
    private JRadioButton rdbtnLastProject;
    private JRadioButton rdbtnEmptyProject;
    private JRadioButton rdbtnNone;
    private JCheckBox chckbxLoadDefaultProject;
    private JCheckBox chckbxAutostartDefaultProject;
    private JPanel panelJavaRuntime;
    private JLabel lblJavaVersion;
    private JLabel lblVersioninfo;
    private JButton btnRealtimeWizard;

    public WaxMonsterPreferencesPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelStudio = new JPanel();
        panelStudio.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Wax Monster Studio", 4, 2, null, null));
        GridBagConstraints gbc_panelStudio = new GridBagConstraints();
        gbc_panelStudio.weightx = 1.0;
        gbc_panelStudio.insets = new Insets(4, 4, 5, 4);
        gbc_panelStudio.fill = 1;
        gbc_panelStudio.gridx = 0;
        gbc_panelStudio.gridy = 0;
        this.add((Component)panelStudio, gbc_panelStudio);
        GridBagLayout gbl_panelStudio = new GridBagLayout();
        gbl_panelStudio.columnWidths = new int[]{0, 0};
        gbl_panelStudio.rowHeights = new int[]{0, 0};
        gbl_panelStudio.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelStudio.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelStudio.setLayout(gbl_panelStudio);
        this.chckbxPreloadClasses = new JCheckBox("Preload classes");
        this.chckbxPreloadClasses.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!WaxMonsterPreferencesPanel.this.refreshing) {
                    WaxMonsterPreferencesPanel.this.apply();
                }
            }
        });
        this.chckbxPreloadClasses.setToolTipText("Preload classes at startup ?");
        GridBagConstraints gbc_chckbxPreloadClasses = new GridBagConstraints();
        gbc_chckbxPreloadClasses.insets = new Insets(4, 4, 4, 4);
        gbc_chckbxPreloadClasses.gridx = 0;
        gbc_chckbxPreloadClasses.gridy = 0;
        panelStudio.add((Component)this.chckbxPreloadClasses, gbc_chckbxPreloadClasses);
        JPanel panelDefaultProject = new JPanel();
        panelDefaultProject.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Default Project", 4, 2, null, null));
        GridBagConstraints gbc_panelDefaultProject = new GridBagConstraints();
        gbc_panelDefaultProject.insets = new Insets(4, 4, 5, 4);
        gbc_panelDefaultProject.weightx = 1.0;
        gbc_panelDefaultProject.fill = 1;
        gbc_panelDefaultProject.gridx = 0;
        gbc_panelDefaultProject.gridy = 1;
        this.add((Component)panelDefaultProject, gbc_panelDefaultProject);
        GridBagLayout gbl_panelDefaultProject = new GridBagLayout();
        gbl_panelDefaultProject.columnWidths = new int[]{0, 0};
        gbl_panelDefaultProject.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panelDefaultProject.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelDefaultProject.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelDefaultProject.setLayout(gbl_panelDefaultProject);
        this.chckbxLoadDefaultProject = new JCheckBox("Load default project:");
        this.chckbxLoadDefaultProject.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!WaxMonsterPreferencesPanel.this.refreshing) {
                    WaxMonsterPreferencesPanel.this.apply();
                }
                WaxMonsterPreferencesPanel.this.checkEnableDefaultProject();
            }
        });
        GridBagConstraints gbc_chckbxLoadDefaultProject = new GridBagConstraints();
        gbc_chckbxLoadDefaultProject.insets = new Insets(4, 4, 0, 0);
        gbc_chckbxLoadDefaultProject.anchor = 17;
        gbc_chckbxLoadDefaultProject.gridx = 0;
        gbc_chckbxLoadDefaultProject.gridy = 0;
        panelDefaultProject.add((Component)this.chckbxLoadDefaultProject, gbc_chckbxLoadDefaultProject);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.weightx = 1.0;
        gbc_panel.insets = new Insets(4, 20, 5, 4);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 1;
        panelDefaultProject.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        this.rdbtnNone = new JRadioButton("None");
        this.rdbtnNone.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!WaxMonsterPreferencesPanel.this.refreshing) {
                    WaxMonsterPreferencesPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_rdbtnNone = new GridBagConstraints();
        gbc_rdbtnNone.insets = new Insets(0, 0, 4, 5);
        gbc_rdbtnNone.anchor = 17;
        gbc_rdbtnNone.gridx = 0;
        gbc_rdbtnNone.gridy = 0;
        panel.add((Component)this.rdbtnNone, gbc_rdbtnNone);
        this.rdbtnEmptyProject = new JRadioButton("Empty project");
        this.rdbtnEmptyProject.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!WaxMonsterPreferencesPanel.this.refreshing) {
                    WaxMonsterPreferencesPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_rdbtnEmptyProject = new GridBagConstraints();
        gbc_rdbtnEmptyProject.insets = new Insets(0, 0, 4, 5);
        gbc_rdbtnEmptyProject.anchor = 17;
        gbc_rdbtnEmptyProject.gridx = 0;
        gbc_rdbtnEmptyProject.gridy = 1;
        panel.add((Component)this.rdbtnEmptyProject, gbc_rdbtnEmptyProject);
        this.rdbtnLastProject = new JRadioButton("Last project");
        this.rdbtnLastProject.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!WaxMonsterPreferencesPanel.this.refreshing) {
                    WaxMonsterPreferencesPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_rdbtnLastProject = new GridBagConstraints();
        gbc_rdbtnLastProject.insets = new Insets(0, 0, 4, 5);
        gbc_rdbtnLastProject.anchor = 17;
        gbc_rdbtnLastProject.gridx = 0;
        gbc_rdbtnLastProject.gridy = 2;
        panel.add((Component)this.rdbtnLastProject, gbc_rdbtnLastProject);
        this.rdbtnDefaultProject = new JRadioButton("Default project:");
        this.rdbtnDefaultProject.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!WaxMonsterPreferencesPanel.this.refreshing) {
                    WaxMonsterPreferencesPanel.this.apply();
                }
                WaxMonsterPreferencesPanel.this.checkEnableDefaultProject();
            }
        });
        GridBagConstraints gbc_rdbtnDefaultProject = new GridBagConstraints();
        gbc_rdbtnDefaultProject.insets = new Insets(0, 0, 0, 5);
        gbc_rdbtnDefaultProject.anchor = 17;
        gbc_rdbtnDefaultProject.gridx = 0;
        gbc_rdbtnDefaultProject.gridy = 3;
        panel.add((Component)this.rdbtnDefaultProject, gbc_rdbtnDefaultProject);
        this.textFieldDefaultProject = new JTextField();
        GridBagConstraints gbc_textFieldDefaultProject = new GridBagConstraints();
        gbc_textFieldDefaultProject.insets = new Insets(0, 0, 0, 5);
        gbc_textFieldDefaultProject.weightx = 1.0;
        gbc_textFieldDefaultProject.fill = 1;
        gbc_textFieldDefaultProject.gridx = 1;
        gbc_textFieldDefaultProject.gridy = 3;
        panel.add((Component)this.textFieldDefaultProject, gbc_textFieldDefaultProject);
        this.textFieldDefaultProject.setColumns(10);
        this.btnBrowseProject = new JButton("");
        this.btnBrowseProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaxMonsterPreferencesPanel.this.actionBrowseDefaultProject();
            }
        });
        this.btnBrowseProject.setToolTipText("Browse...");
        this.btnBrowseProject.setMargin(new Insets(2, 2, 2, 2));
        this.btnBrowseProject.setIcon(new ImageIcon(WaxMonsterPreferencesPanel.class.getResource("/com/waxmonster/studio/plugin/icons/file_explorer.gif")));
        GridBagConstraints gbc_btnBrowseProject = new GridBagConstraints();
        gbc_btnBrowseProject.gridx = 2;
        gbc_btnBrowseProject.gridy = 3;
        panel.add((Component)this.btnBrowseProject, gbc_btnBrowseProject);
        this.chckbxAutostartDefaultProject = new JCheckBox("Auto-Start default project");
        this.chckbxAutostartDefaultProject.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!WaxMonsterPreferencesPanel.this.refreshing) {
                    WaxMonsterPreferencesPanel.this.apply();
                }
            }
        });
        this.chckbxAutostartDefaultProject.setToolTipText("Automatically start default project ?");
        GridBagConstraints gbc_chckbxAutostartDefaultProject = new GridBagConstraints();
        gbc_chckbxAutostartDefaultProject.insets = new Insets(4, 4, 4, 0);
        gbc_chckbxAutostartDefaultProject.anchor = 17;
        gbc_chckbxAutostartDefaultProject.gridx = 0;
        gbc_chckbxAutostartDefaultProject.gridy = 2;
        panelDefaultProject.add((Component)this.chckbxAutostartDefaultProject, gbc_chckbxAutostartDefaultProject);
        this.panelJavaRuntime = new JPanel();
        this.panelJavaRuntime.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Java Runtime", 4, 2, null, null));
        GridBagConstraints gbc_panelJavaRuntime = new GridBagConstraints();
        gbc_panelJavaRuntime.insets = new Insets(4, 4, 5, 4);
        gbc_panelJavaRuntime.weightx = 1.0;
        gbc_panelJavaRuntime.fill = 1;
        gbc_panelJavaRuntime.gridx = 0;
        gbc_panelJavaRuntime.gridy = 2;
        this.add((Component)this.panelJavaRuntime, gbc_panelJavaRuntime);
        GridBagLayout gbl_panelJavaRuntime = new GridBagLayout();
        gbl_panelJavaRuntime.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelJavaRuntime.rowHeights = new int[]{0, 0};
        gbl_panelJavaRuntime.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelJavaRuntime.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelJavaRuntime.setLayout(gbl_panelJavaRuntime);
        this.btnRealtimeWizard = new JButton("Runtime Wizard");
        this.btnRealtimeWizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaxMonsterPreferencesPanel.this.actionJavaRuntimeWizard();
            }
        });
        this.lblJavaVersion = new JLabel("Java Version:");
        GridBagConstraints gbc_lblJavaVersion = new GridBagConstraints();
        gbc_lblJavaVersion.anchor = 17;
        gbc_lblJavaVersion.insets = new Insets(4, 4, 5, 5);
        gbc_lblJavaVersion.gridx = 0;
        gbc_lblJavaVersion.gridy = 0;
        this.panelJavaRuntime.add((Component)this.lblJavaVersion, gbc_lblJavaVersion);
        this.lblVersioninfo = new JLabel("VersionInfo");
        GridBagConstraints gbc_lblVersioninfo = new GridBagConstraints();
        gbc_lblVersioninfo.anchor = 17;
        gbc_lblVersioninfo.fill = 2;
        gbc_lblVersioninfo.weightx = 1.0;
        gbc_lblVersioninfo.insets = new Insets(4, 4, 5, 5);
        gbc_lblVersioninfo.gridx = 1;
        gbc_lblVersioninfo.gridy = 0;
        this.panelJavaRuntime.add((Component)this.lblVersioninfo, gbc_lblVersioninfo);
        this.btnRealtimeWizard.setMargin(new Insets(2, 4, 2, 4));
        GridBagConstraints gbc_btnRealtimeWizard = new GridBagConstraints();
        gbc_btnRealtimeWizard.insets = new Insets(4, 4, 5, 5);
        gbc_btnRealtimeWizard.gridx = 2;
        gbc_btnRealtimeWizard.gridy = 0;
        this.panelJavaRuntime.add((Component)this.btnRealtimeWizard, gbc_btnRealtimeWizard);
        this.initWaxMonsterPreferencesPanel();
    }

    private void initWaxMonsterPreferencesPanel() {
        this.textFieldDefaultProject.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!WaxMonsterPreferencesPanel.this.refreshing) {
                    WaxMonsterPreferencesPanel.this.apply();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!WaxMonsterPreferencesPanel.this.refreshing) {
                    WaxMonsterPreferencesPanel.this.apply();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!WaxMonsterPreferencesPanel.this.refreshing) {
                    WaxMonsterPreferencesPanel.this.apply();
                }
            }
        });
        ButtonGroup defProjectGroup = new ButtonGroup();
        defProjectGroup.add(this.getRdbtnNone());
        defProjectGroup.add(this.getRdbtnEmptyProject());
        defProjectGroup.add(this.getRdbtnLastProject());
        defProjectGroup.add(this.getRdbtnDefaultProject());
        this.checkEnableDefaultProject();
        String javaVersion = System.getProperty("java.version");
        String javaVmName = System.getProperty("java.vm.name");
        this.lblVersioninfo.setText(String.valueOf(javaVmName) + ", " + String.valueOf(javaVersion));
    }

    public WaxMonsterPreferences getWaxMonsterPreferences() {
        return this.waxMonsterPreferences;
    }

    public void setWaxMonsterPreferences(WaxMonsterPreferences waxMonsterPreferences) {
        this.waxMonsterPreferences = waxMonsterPreferences;
        this.refresh();
    }

    protected JCheckBox getChckbxPreloadClasses() {
        return this.chckbxPreloadClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void refresh() {
        try {
            this.refreshing = true;
            boolean preloadClasses = true;
            boolean loadDefaultProject = false;
            boolean autoStartDefaultProject = false;
            int defaultProjectType = -1;
            String defaultProjectPath = null;
            if (this.waxMonsterPreferences != null) {
                preloadClasses = this.waxMonsterPreferences.isPreloadClasses();
                loadDefaultProject = this.waxMonsterPreferences.isLoadDefaultProject();
                autoStartDefaultProject = this.waxMonsterPreferences.isAutoStartDefaultProject();
                defaultProjectType = this.waxMonsterPreferences.getDefaultProjectType();
                defaultProjectPath = this.waxMonsterPreferences.getDefaultProjectPath();
            }
            this.getChckbxPreloadClasses().setSelected(preloadClasses);
            this.getChckbxLoadDefaultProject().setSelected(loadDefaultProject);
            this.getChckbxAutostartDefaultProject().setSelected(autoStartDefaultProject);
            this.getTextFieldDefaultProject().setText(defaultProjectPath == null ? "" : defaultProjectPath);
            switch (defaultProjectType) {
                case 0: {
                    this.getRdbtnNone().setSelected(true);
                    return;
                }
                case 1: {
                    this.getRdbtnEmptyProject().setSelected(true);
                    return;
                }
                case 3: {
                    this.getRdbtnDefaultProject().setSelected(true);
                    return;
                }
                default: {
                    this.getRdbtnLastProject().setSelected(true);
                    return;
                }
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void apply() {
        if (this.waxMonsterPreferences == null) {
            return;
        }
        this.waxMonsterPreferences.setPreloadClasses(this.getChckbxPreloadClasses().isSelected());
        this.waxMonsterPreferences.setDefaultProjectPath(this.getTextFieldDefaultProject().getText());
        int defaultProjectType = -1;
        if (this.getRdbtnNone().isSelected()) {
            defaultProjectType = 0;
        }
        if (this.getRdbtnEmptyProject().isSelected()) {
            defaultProjectType = 1;
        }
        if (this.getRdbtnLastProject().isSelected()) {
            defaultProjectType = 2;
        }
        if (this.getRdbtnDefaultProject().isSelected()) {
            defaultProjectType = 3;
        }
        this.waxMonsterPreferences.setDefaultProjectType(defaultProjectType);
        this.waxMonsterPreferences.setLoadDefaultProject(this.getChckbxLoadDefaultProject().isSelected());
        this.waxMonsterPreferences.setAutoStartDefaultProject(this.getChckbxAutostartDefaultProject().isSelected());
    }

    protected JButton getBtnBrowseProject() {
        return this.btnBrowseProject;
    }

    protected JTextField getTextFieldDefaultProject() {
        return this.textFieldDefaultProject;
    }

    protected JRadioButton getRdbtnDefaultProject() {
        return this.rdbtnDefaultProject;
    }

    protected JRadioButton getRdbtnLastProject() {
        return this.rdbtnLastProject;
    }

    protected JRadioButton getRdbtnEmptyProject() {
        return this.rdbtnEmptyProject;
    }

    protected JRadioButton getRdbtnNone() {
        return this.rdbtnNone;
    }

    protected JCheckBox getChckbxLoadDefaultProject() {
        return this.chckbxLoadDefaultProject;
    }

    protected JCheckBox getChckbxAutostartDefaultProject() {
        return this.chckbxAutostartDefaultProject;
    }

    protected void checkEnableDefaultProject() {
        boolean loadDef = this.getChckbxLoadDefaultProject().isSelected();
        this.getRdbtnNone().setEnabled(loadDef);
        this.getRdbtnEmptyProject().setEnabled(loadDef);
        this.getRdbtnLastProject().setEnabled(loadDef);
        this.getRdbtnDefaultProject().setEnabled(loadDef);
        this.getTextFieldDefaultProject().setEnabled(loadDef && this.getRdbtnDefaultProject().isSelected());
        this.getBtnBrowseProject().setEnabled(loadDef && this.getRdbtnDefaultProject().isSelected());
        this.getChckbxAutostartDefaultProject().setEnabled(loadDef);
    }

    protected void actionBrowseDefaultProject() {
        int rc;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select Default Project");
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter((FileFilter)new StudioPanel.StudioFileFilter());
        File dataDir = Platform.getInstance().getDataDir();
        if (dataDir != null) {
            chooser.setCurrentDirectory(dataDir);
        }
        if ((rc = chooser.showOpenDialog(this)) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        String path = file == null ? null : file.getPath();
        this.getTextFieldDefaultProject().setText(path == null ? "" : path);
    }

    protected JLabel getLblVersioninfo() {
        return this.lblVersioninfo;
    }

    protected void actionJavaRuntimeWizard() {
        new WaxMonsterJavaRuntimeWizard().showJavaRuntimeWizardDialog(this);
    }
}

