/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.plugin;

import com.waxmonster.studio.plugin.WaxMonsterTemplate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WaxMonsterTemplateChooser
extends JPanel {
    private static final long serialVersionUID = -3171959149565570866L;
    public static final String KEY_SEPARATOR = ".";
    private WaxMonsterTemplate[] templates;
    private boolean includeEmptyTemplate;
    private WaxMonsterTemplate emptyTemplate;
    private DefaultListModel templateListModel;
    private WaxMonsterTemplate selectedTemplate;
    private JList listTemplates;
    private JTextArea textAreaComment;

    public WaxMonsterTemplateChooser() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel panelTemplates = new JPanel();
        panelTemplates.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Templates", 4, 2, null, null));
        this.add((Component)panelTemplates, "Center");
        GridBagLayout gbl_panelTemplates = new GridBagLayout();
        gbl_panelTemplates.columnWidths = new int[]{0, 0};
        gbl_panelTemplates.rowHeights = new int[]{0, 0};
        gbl_panelTemplates.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panelTemplates.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        panelTemplates.setLayout(gbl_panelTemplates);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.insets = new Insets(4, 4, 4, 4);
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        panelTemplates.add((Component)scrollPane, gbc_scrollPane);
        this.listTemplates = new JList();
        this.listTemplates.setSelectionMode(0);
        this.listTemplates.setOpaque(false);
        this.listTemplates.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                WaxMonsterTemplateChooser.this.handleTemplateSelectionChanged();
            }
        });
        scrollPane.setViewportView(this.listTemplates);
        JPanel panelDetails = new JPanel();
        panelDetails.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Template Details", 4, 2, null, new Color(51, 51, 51)));
        this.add((Component)panelDetails, "South");
        GridBagLayout gbl_panelDetails = new GridBagLayout();
        gbl_panelDetails.columnWidths = new int[]{0, 0};
        gbl_panelDetails.rowHeights = new int[]{0, 0};
        gbl_panelDetails.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelDetails.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelDetails.setLayout(gbl_panelDetails);
        JScrollPane scrollPane_2 = new JScrollPane();
        scrollPane_2.setOpaque(false);
        GridBagConstraints gbc_scrollPane_2 = new GridBagConstraints();
        gbc_scrollPane_2.weighty = 1.0;
        gbc_scrollPane_2.weightx = 1.0;
        gbc_scrollPane_2.insets = new Insets(4, 4, 4, 4);
        gbc_scrollPane_2.fill = 1;
        gbc_scrollPane_2.gridx = 0;
        gbc_scrollPane_2.gridy = 0;
        panelDetails.add((Component)scrollPane_2, gbc_scrollPane_2);
        this.textAreaComment = new JTextArea();
        this.textAreaComment.setLineWrap(true);
        this.textAreaComment.setWrapStyleWord(true);
        this.textAreaComment.setEditable(false);
        this.textAreaComment.setOpaque(false);
        scrollPane_2.setViewportView(this.textAreaComment);
        this.textAreaComment.setRows(4);
        this.initWaxMonsterTemplateChooser();
    }

    protected void initWaxMonsterTemplateChooser() {
        this.emptyTemplate = new WaxMonsterTemplate();
        this.emptyTemplate.setPath(null);
        this.emptyTemplate.setName("emptyStudioProject");
        this.emptyTemplate.setTitle("Empty Project");
        this.emptyTemplate.setComment("Empty Studio Project");
        this.templateListModel = new DefaultListModel();
        this.listTemplates.setModel(this.templateListModel);
        this.listTemplates.setCellRenderer(new TemplateListCellRenderer());
    }

    public synchronized void refresh() {
        WaxMonsterTemplate[] temps;
        this.templateListModel.clear();
        if (this.includeEmptyTemplate) {
            this.templateListModel.addElement(this.emptyTemplate);
        }
        int templateCount = (temps = this.getTemplates()) == null ? 0 : temps.length;
        for (int i = 0; i < templateCount; ++i) {
            WaxMonsterTemplate template = temps[i];
            if (template == null) continue;
            this.templateListModel.addElement(template);
        }
        this.refreshDetails();
    }

    protected void refreshDetails() {
        String comment = null;
        WaxMonsterTemplate template = this.getSelectedTemplate();
        if (template != null) {
            comment = template.getComment();
        }
        if (comment == null) {
            comment = "";
        }
        this.getTextAreaComment().setText(comment);
        this.getTextAreaComment().setCaretPosition(0);
    }

    protected JList getListTemplates() {
        return this.listTemplates;
    }

    protected JTextArea getTextAreaComment() {
        return this.textAreaComment;
    }

    public boolean showDialog(Component parent, String title) {
        WaxMonsterTemplateChooser message = this;
        int optionType = 2;
        int messageType = -1;
        int rc = JOptionPane.showConfirmDialog(parent, message, title, optionType, messageType);
        return rc == 0;
    }

    public WaxMonsterTemplate[] getTemplates() {
        return this.templates;
    }

    public void setTemplates(WaxMonsterTemplate[] templates) {
        this.templates = templates;
        this.refresh();
    }

    public boolean isIncludeEmptyTemplate() {
        return this.includeEmptyTemplate;
    }

    public void setIncludeEmptyTemplate(boolean includeEmptyTemplate) {
        this.includeEmptyTemplate = includeEmptyTemplate;
        this.refresh();
    }

    public WaxMonsterTemplate getSelectedTemplate() {
        return this.selectedTemplate;
    }

    protected void setSelectedTemplate(WaxMonsterTemplate selectedTemplate) {
        this.selectedTemplate = selectedTemplate;
    }

    protected void handleTemplateSelectionChanged() {
        WaxMonsterTemplate sel;
        this.selectedTemplate = sel = (WaxMonsterTemplate)this.listTemplates.getSelectedValue();
        this.refreshDetails();
    }

    protected static class TemplateInfo {
        private URL indexURL;
        private String name;
        private String path;

        protected TemplateInfo() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public URL getIndexURL() {
            return this.indexURL;
        }

        public void setIndexURL(URL indexURL) {
            this.indexURL = indexURL;
        }
    }

    protected class TemplateListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1228353739618875871L;

        protected TemplateListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            WaxMonsterTemplate template;
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String text = null;
            if (value != null && value instanceof WaxMonsterTemplate && ((text = (template = (WaxMonsterTemplate)value).getTitle()) == null || text.length() < 1) && (text = template.getName()) == null) {
                text = String.valueOf(template);
            }
            if (text == null) {
                text = "";
            }
            this.setText(text);
            return comp;
        }
    }
}

