/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.presets;

import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.midi.common.MidiMappingUtil;
import com.waxmonster.studio.Preset;
import com.waxmonster.studio.presets.AbstractStudioPresetProvider;
import com.waxmonster.studio.presets.NovationDicerMidiConst;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public class NovationDicerScratchDeckPresetProvider
extends AbstractStudioPresetProvider
implements NovationDicerMidiConst {
    public NovationDicerScratchDeckPresetProvider() {
        super("Novation Dicer");
    }

    public Preset[] getPresets() {
        return new Preset[]{this.createDicerPreset(true), this.createDicerPreset(false)};
    }

    protected Preset createDicerPreset(boolean leftDeck) {
        String event;
        int note;
        int i;
        int i2;
        int autoLoopChannel;
        int loopRollChannel;
        int cuePointChannel;
        String name = "NovationDicer-";
        if (leftDeck) {
            name = name + "LeftDeck";
            cuePointChannel = 10;
            loopRollChannel = 11;
            autoLoopChannel = 12;
        } else {
            name = name + "RightDeck";
            cuePointChannel = 13;
            loopRollChannel = 14;
            autoLoopChannel = 15;
        }
        int buttonCount = 5;
        LinkedList<MidiMapping> midiMappingList = new LinkedList<MidiMapping>();
        for (i2 = 0; i2 < buttonCount; ++i2) {
            midiMappingList.add(this.createCuePointMidiMapping(cuePointChannel, i2, true));
        }
        for (i2 = 0; i2 < buttonCount; ++i2) {
            midiMappingList.add(this.createCuePointMidiMapping(cuePointChannel, i2, false));
        }
        for (i2 = 0; i2 < buttonCount; ++i2) {
            midiMappingList.add(this.createLoopRollMidiMapping(loopRollChannel, i2));
        }
        for (i2 = 0; i2 < buttonCount; ++i2) {
            midiMappingList.add(this.createAutoLoopMidiMapping(autoLoopChannel, i2));
        }
        int skipPrevNote = 65;
        midiMappingList.add(this.createNoteMidiMapping("SkipPrev", autoLoopChannel, skipPrevNote));
        int skipNextNote = 69;
        midiMappingList.add(this.createNoteMidiMapping("SkipNext", autoLoopChannel, skipNextNote));
        int beatJumpBwdNote = 66;
        midiMappingList.add(this.createNoteMidiMapping("BeatJumpBackward", autoLoopChannel, beatJumpBwdNote));
        int beatJumpFwdNote = 68;
        midiMappingList.add(this.createNoteMidiMapping("BeatJumpForward", autoLoopChannel, beatJumpFwdNote));
        int censorNote = 67;
        midiMappingList.add(this.createNoteMidiMapping("Censor", autoLoopChannel, censorNote));
        LinkedList<MidiTrigger> midiTriggerList = new LinkedList<MidiTrigger>();
        int colorOff = 0;
        int colorRedFull = 15;
        int colorRedLow = 2;
        int colorGreenFull = 127;
        int colorGreenLow = 114;
        int colorYellowFull = 95;
        int colorYellowLow = 82;
        for (i = 0; i < buttonCount; ++i) {
            midiTriggerList.add(this.createCuePointMidiTrigger(cuePointChannel, i, colorRedFull, true, false));
            midiTriggerList.add(this.createCuePointMidiTrigger(cuePointChannel, i, colorRedFull, true, true));
        }
        for (i = 0; i < buttonCount; ++i) {
            midiTriggerList.add(this.createCuePointMidiTrigger(cuePointChannel, i, colorRedLow, false, false));
            midiTriggerList.add(this.createCuePointMidiTrigger(cuePointChannel, i, colorRedLow, false, true));
        }
        for (i = 0; i < buttonCount; ++i) {
            note = 60 + i;
            event = "LoopRollStarted-" + (i + 1);
            midiTriggerList.add(this.createNoteMidiTrigger(event, loopRollChannel, note, colorGreenFull));
            event = "LoopRollStopped-" + (i + 1);
            midiTriggerList.add(this.createNoteMidiTrigger(event, loopRollChannel, note, colorGreenLow));
        }
        for (i = 0; i < buttonCount; ++i) {
            note = 60 + i;
            event = "AutoLoopStarted-" + (i + 1);
            midiTriggerList.add(this.createNoteMidiTrigger(event, autoLoopChannel, note, colorYellowFull));
            event = "AutoLoopStopped-" + (i + 1);
            midiTriggerList.add(this.createNoteMidiTrigger(event, autoLoopChannel, note, colorYellowLow));
        }
        if (skipPrevNote >= 0) {
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStarted", autoLoopChannel, skipPrevNote, colorGreenFull));
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStopped", autoLoopChannel, skipPrevNote, colorOff));
        }
        if (skipNextNote >= 0) {
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStarted", autoLoopChannel, skipNextNote, colorGreenFull));
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStopped", autoLoopChannel, skipNextNote, colorOff));
        }
        if (beatJumpBwdNote >= 0) {
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStarted", autoLoopChannel, beatJumpBwdNote, colorYellowFull));
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStopped", autoLoopChannel, beatJumpBwdNote, colorOff));
        }
        if (beatJumpFwdNote >= 0) {
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStarted", autoLoopChannel, beatJumpFwdNote, colorYellowFull));
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStopped", autoLoopChannel, beatJumpFwdNote, colorOff));
        }
        if (censorNote >= 0) {
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStarted", autoLoopChannel, censorNote, colorRedFull));
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStopped", autoLoopChannel, censorNote, colorOff));
        }
        MidiMapping[] midiMappings = midiMappingList.toArray(new MidiMapping[midiMappingList.size()]);
        Properties midiMappingProps = MidiMappingUtil.formatPresetMidiMappings((MidiMapping[])midiMappings);
        MidiTrigger[] midiTriggers = midiTriggerList.toArray(new MidiTrigger[midiTriggerList.size()]);
        Properties midiTriggerProps = MidiMappingUtil.formatPresetMidiTriggers((MidiTrigger[])midiTriggers);
        Preset preset = new Preset();
        preset.setPresetName(name);
        preset.setDeviceName("WaxLabScratchDeck");
        preset.setProviderName(this.getClass().getName());
        Properties props = new Properties();
        props.putAll((Map<?, ?>)midiMappingProps);
        props.putAll((Map<?, ?>)midiTriggerProps);
        preset.setProperties(props);
        return preset;
    }

    protected MidiMapping createCuePointMidiMapping(int channel, int buttonIndex, boolean addOrRemove) {
        String action;
        int note;
        String suffix = Integer.toString(buttonIndex + 1);
        if (addOrRemove) {
            note = 60 + buttonIndex;
            action = "JumpOrSetCuePoint-" + suffix;
        } else {
            note = 65 + buttonIndex;
            action = "RemoveCuePoint-" + suffix;
        }
        return new MidiMapping(channel, 144, note, action);
    }

    protected MidiMapping createLoopRollMidiMapping(int channel, int buttonIndex) {
        int note = 60 + buttonIndex;
        String action = "LoopRoll-" + (buttonIndex + 1);
        return new MidiMapping(channel, 144, note, action);
    }

    protected MidiMapping createAutoLoopMidiMapping(int channel, int buttonIndex) {
        int note = 60 + buttonIndex;
        String action = "AutoLoop-" + (buttonIndex + 1);
        return new MidiMapping(channel, 144, note, action);
    }

    protected MidiTrigger createCuePointMidiTrigger(int channel, int buttonIndex, int color, boolean addedOrRemoved, boolean shiftMode) {
        String suffix = Integer.toString(buttonIndex + 1);
        String event = addedOrRemoved ? "CuePointAdded-" + suffix : "CuePointRemoved-" + suffix;
        int note = shiftMode ? 65 + buttonIndex : 60 + buttonIndex;
        return new MidiTrigger(event, channel, 144, note, color);
    }
}

