/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.presets;

import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.midi.common.MidiMappingUtil;
import com.waxmonster.studio.Preset;
import com.waxmonster.studio.presets.AbstractStudioPresetProvider;
import com.waxmonster.studio.presets.NovationLaunchControlMidiConst;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public class NovationLaunchControlAudioPlayerPresetProvider
extends AbstractStudioPresetProvider
implements NovationLaunchControlMidiConst {
    public static final String PROVIDER_NAME = "NovationLaunchControlAudioPlayer";

    public NovationLaunchControlAudioPlayerPresetProvider() {
        super(PROVIDER_NAME);
    }

    public Preset[] getPresets() {
        return new Preset[]{this.createLaunchControlPreset()};
    }

    protected Preset createLaunchControlPreset() {
        String name = "NovationLaunchControl";
        int audioPlayerControlChannel = 0;
        LinkedList<MidiMapping> midiMappingList = new LinkedList<MidiMapping>();
        LinkedList midiTriggerList = new LinkedList();
        int channel = audioPlayerControlChannel;
        midiMappingList.add(this.createNoteMidiMapping("TogglePauseResume", channel, 28));
        midiMappingList.add(this.createControlMidiMapping("SkipPrev", channel, 116));
        midiMappingList.add(this.createControlMidiMapping("SkipNext", channel, 117));
        midiMappingList.add(this.createControlMidiMapping("IncrementRating", channel, 114));
        midiMappingList.add(this.createControlMidiMapping("DecrementRating", channel, 115));
        midiMappingList.add(this.createNoteMidiMapping("AddMarker", channel, 9));
        MidiMapping[] midiMappings = midiMappingList.toArray(new MidiMapping[midiMappingList.size()]);
        Properties midiMappingProps = MidiMappingUtil.formatPresetMidiMappings((MidiMapping[])midiMappings);
        MidiTrigger[] midiTriggers = midiTriggerList.toArray(new MidiTrigger[midiTriggerList.size()]);
        Properties midiTriggerProps = MidiMappingUtil.formatPresetMidiTriggers((MidiTrigger[])midiTriggers);
        Preset preset = new Preset();
        preset.setPresetName(name);
        preset.setDeviceName("AudioPlayerMidiControl");
        preset.setProviderName(this.getClass().getName());
        Properties props = new Properties();
        props.putAll((Map<?, ?>)midiMappingProps);
        props.putAll((Map<?, ?>)midiTriggerProps);
        preset.setProperties(props);
        return preset;
    }
}

