/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.presets;

import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.midi.common.MidiMappingUtil;
import com.waxmonster.studio.Preset;
import com.waxmonster.studio.presets.AbstractStudioPresetProvider;
import com.waxmonster.studio.presets.NovationLaunchControlMidiConst;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class NovationLaunchControlScratchDeckPresetProvider
extends AbstractStudioPresetProvider
implements NovationLaunchControlMidiConst {
    public static final String PROVIDER_NAME = "NovationLaunchControlScratchDeck";

    public NovationLaunchControlScratchDeckPresetProvider() {
        super(PROVIDER_NAME);
    }

    public Preset[] getPresets() {
        return new Preset[]{this.createLaunchControlPreset(true), this.createLaunchControlPreset(false)};
    }

    protected Preset createLaunchControlPreset(boolean leftDeck) {
        int autoLoopNote;
        int loopRollNote;
        int cuePointNote;
        String suffix;
        int i;
        int firstSingleDeckChannel;
        String name = "NovationLaunchControl-";
        name = leftDeck ? name + "Deck1" : name + "Deck2";
        int cuePointCount = 8;
        int beatSliceCount = 8;
        int loopRollCount = 5;
        int autoLoopCount = 6;
        int singleDeckCuePointsChannel = firstSingleDeckChannel = leftDeck ? 1 : 9;
        int singleDeckLoopRollsChannel = firstSingleDeckChannel + 1;
        int singleDeckAutoLoopsChannel = firstSingleDeckChannel + 2;
        int singleDeckBeatSlicerChannel = firstSingleDeckChannel + 3;
        int multiDeckAutoLoopsChannel = 5;
        int multiDeckLoopRollsChannel = 6;
        int multiDeckCuePointsChannel = 7;
        int multiDeckScratchPitchModeChannel = 14;
        int multiDeckTrackControlChannel = 15;
        int[] usedChannels = new int[]{singleDeckCuePointsChannel, singleDeckLoopRollsChannel, singleDeckAutoLoopsChannel, singleDeckBeatSlicerChannel, multiDeckAutoLoopsChannel, multiDeckLoopRollsChannel, multiDeckCuePointsChannel, multiDeckScratchPitchModeChannel, multiDeckTrackControlChannel};
        int shiftRemoveCuePointIndex = 116;
        int toggleSlipModeControlIndex = leftDeck ? 114 : 115;
        LinkedList<MidiMapping> midiMappingList = new LinkedList<MidiMapping>();
        LinkedList<MidiTrigger> midiTriggerList = new LinkedList<MidiTrigger>();
        int postFaderVolumeControlIndex = leftDeck ? 21 : 28;
        int preFaderVolumeControlIndex = leftDeck ? 41 : 48;
        int pitchFactorControlIndex = leftDeck ? 22 : 27;
        int pitchTuneControlIndex = leftDeck ? 42 : 47;
        midiMappingList.add(this.createTemplateChangedMidiMapping("RefreshDeckLighting"));
        for (i = 0; i < usedChannels.length; ++i) {
            midiMappingList.add(this.createControlMidiMapping("PostFaderVolumeControl", usedChannels[i], postFaderVolumeControlIndex));
        }
        for (i = 0; i < usedChannels.length; ++i) {
            midiMappingList.add(this.createControlMidiMapping("PreFaderVolumeControl", usedChannels[i], preFaderVolumeControlIndex));
        }
        for (i = 0; i < usedChannels.length; ++i) {
            midiMappingList.add(this.createControlMidiMapping("PitchFactorControl", usedChannels[i], pitchFactorControlIndex));
        }
        for (i = 0; i < usedChannels.length; ++i) {
            midiMappingList.add(this.createControlMidiMapping("PitchTuneControl", usedChannels[i], pitchTuneControlIndex));
        }
        int channel = singleDeckCuePointsChannel;
        midiMappingList.add(this.createControlMidiMapping("ShiftRemoveCuePoint", channel, shiftRemoveCuePointIndex));
        midiTriggerList.add(this.createControlMidiTrigger("DeckStarted", channel, shiftRemoveCuePointIndex, 13));
        for (i = 0; i < cuePointCount; ++i) {
            suffix = Integer.toString(i + 1);
            cuePointNote = this.getLaunchControlPadNote(i);
            midiMappingList.add(this.createNoteMidiMapping("JumpOrSetOrRemoveCuePoint-" + suffix, channel, cuePointNote));
            this.createCuePointMidiTriggers(channel, cuePointNote, suffix, midiTriggerList);
        }
        midiMappingList.add(this.createControlMidiMapping("ToggleSlipMode", channel, toggleSlipModeControlIndex));
        this.createSlipModeMidiTriggers(channel, toggleSlipModeControlIndex, midiTriggerList);
        channel = multiDeckCuePointsChannel;
        midiMappingList.add(this.createControlMidiMapping("ShiftRemoveCuePoint", channel, shiftRemoveCuePointIndex));
        midiTriggerList.add(this.createControlMidiTrigger("DeckStarted", channel, shiftRemoveCuePointIndex, 13));
        for (i = 0; i < 4; ++i) {
            suffix = Integer.toString(i + 1);
            cuePointNote = this.getLaunchControlPadNote(leftDeck ? i : i + 4);
            midiMappingList.add(this.createNoteMidiMapping("JumpOrSetOrRemoveCuePoint-" + suffix, channel, cuePointNote));
            this.createCuePointMidiTriggers(channel, cuePointNote, suffix, midiTriggerList);
        }
        midiMappingList.add(this.createControlMidiMapping("ToggleSlipMode", channel, toggleSlipModeControlIndex));
        this.createSlipModeMidiTriggers(channel, toggleSlipModeControlIndex, midiTriggerList);
        channel = singleDeckLoopRollsChannel;
        for (i = 0; i < loopRollCount; ++i) {
            suffix = Integer.toString(i + 1);
            loopRollNote = this.getLaunchControlPadNote(i);
            midiMappingList.add(this.createNoteMidiMapping("LoopRoll-" + suffix, channel, loopRollNote));
            this.createLoopRollMidiTriggers(channel, loopRollNote, suffix, midiTriggerList);
        }
        midiMappingList.add(this.createControlMidiMapping("ToggleSlipMode", channel, toggleSlipModeControlIndex));
        this.createSlipModeMidiTriggers(channel, toggleSlipModeControlIndex, midiTriggerList);
        channel = multiDeckLoopRollsChannel;
        for (i = 0; i < 4; ++i) {
            suffix = Integer.toString(i + 1);
            loopRollNote = this.getLaunchControlPadNote(leftDeck ? i : i + 4);
            midiMappingList.add(this.createNoteMidiMapping("LoopRoll-" + suffix, channel, loopRollNote));
            this.createLoopRollMidiTriggers(channel, loopRollNote, suffix, midiTriggerList);
        }
        midiMappingList.add(this.createControlMidiMapping("ToggleSlipMode", channel, toggleSlipModeControlIndex));
        this.createSlipModeMidiTriggers(channel, toggleSlipModeControlIndex, midiTriggerList);
        channel = singleDeckAutoLoopsChannel;
        for (i = 0; i < autoLoopCount; ++i) {
            suffix = Integer.toString(i + 1);
            autoLoopNote = this.getLaunchControlPadNote(i);
            midiMappingList.add(this.createNoteMidiMapping("AutoLoop-" + suffix, channel, autoLoopNote));
            this.createAutoLoopMidiTriggers(channel, autoLoopNote, suffix, midiTriggerList);
        }
        midiMappingList.add(this.createControlMidiMapping("ToggleSlipMode", channel, toggleSlipModeControlIndex));
        this.createSlipModeMidiTriggers(channel, toggleSlipModeControlIndex, midiTriggerList);
        channel = multiDeckAutoLoopsChannel;
        for (i = 0; i < 4; ++i) {
            suffix = Integer.toString(i + 1);
            autoLoopNote = this.getLaunchControlPadNote(leftDeck ? i : i + 4);
            midiMappingList.add(this.createNoteMidiMapping("AutoLoop-" + suffix, channel, autoLoopNote));
            this.createAutoLoopMidiTriggers(channel, autoLoopNote, suffix, midiTriggerList);
        }
        midiMappingList.add(this.createControlMidiMapping("ToggleSlipMode", channel, toggleSlipModeControlIndex));
        this.createSlipModeMidiTriggers(channel, toggleSlipModeControlIndex, midiTriggerList);
        channel = singleDeckBeatSlicerChannel;
        int beatSlicerToggleIndex = 116;
        int beatSlicerLoopToggleIndex = 117;
        int beatSlicerDoubleLengthIndex = 114;
        int beatSlicerHalfLengthIndex = 115;
        if (beatSlicerToggleIndex >= 0) {
            midiMappingList.add(this.createControlMidiMapping("SlicerToggle", channel, beatSlicerToggleIndex));
            midiTriggerList.add(this.createControlMidiTrigger("BeatSlicerStarted", channel, beatSlicerToggleIndex, 15));
            midiTriggerList.add(this.createControlMidiTrigger("BeatSlicerStopped", channel, beatSlicerToggleIndex, 13));
            midiTriggerList.add(this.createControlMidiTrigger("DeckStopped", channel, beatSlicerToggleIndex, 12));
        }
        if (beatSlicerLoopToggleIndex >= 0) {
            midiMappingList.add(this.createControlMidiMapping("SlicerLoopModeToggle", channel, beatSlicerLoopToggleIndex));
            midiTriggerList.add(this.createControlMidiTrigger("BeatSlicerLoopActivated", channel, beatSlicerLoopToggleIndex, 15));
            midiTriggerList.add(this.createControlMidiTrigger("BeatSlicerLoopDeactivated", channel, beatSlicerLoopToggleIndex, 13));
            midiTriggerList.add(this.createControlMidiTrigger("DeckStopped", channel, beatSlicerLoopToggleIndex, 12));
        }
        if (beatSlicerDoubleLengthIndex >= 0) {
            midiMappingList.add(this.createControlMidiMapping("SetSliceLengthDouble", channel, beatSlicerDoubleLengthIndex));
            midiTriggerList.add(this.createControlMidiTrigger("DeckStarted", channel, beatSlicerDoubleLengthIndex, 13));
            midiTriggerList.add(this.createControlMidiTrigger("DeckStopped", channel, beatSlicerDoubleLengthIndex, 12));
        }
        if (beatSlicerHalfLengthIndex >= 0) {
            midiMappingList.add(this.createControlMidiMapping("SetSliceLengthHalf", channel, beatSlicerHalfLengthIndex));
            midiTriggerList.add(this.createControlMidiTrigger("DeckStarted", channel, beatSlicerHalfLengthIndex, 13));
            midiTriggerList.add(this.createControlMidiTrigger("DeckStopped", channel, beatSlicerHalfLengthIndex, 12));
        }
        for (int i2 = 0; i2 < beatSliceCount; ++i2) {
            String suffix2 = Integer.toString(i2 + 1);
            int beatSlicerJumpNote = this.getLaunchControlPadNote(i2);
            midiMappingList.add(this.createNoteMidiMapping("SlicerJump-" + suffix2, channel, beatSlicerJumpNote));
            midiTriggerList.add(this.createNoteMidiTrigger("BeatSliceActivated-" + suffix2, channel, beatSlicerJumpNote, 60));
            midiTriggerList.add(this.createNoteMidiTrigger("BeatSliceEntered-" + suffix2, channel, beatSlicerJumpNote, 63));
            midiTriggerList.add(this.createNoteMidiTrigger("BeatSliceExited-" + suffix2, channel, beatSlicerJumpNote, 12));
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStopped", channel, beatSlicerJumpNote, 12));
        }
        channel = multiDeckScratchPitchModeChannel;
        int shiftToggleModesIndex = 116;
        int toggleScratchModeNote = this.getLaunchControlPadNote(leftDeck ? 0 : 7);
        int togglePitchModeNote = this.getLaunchControlPadNote(leftDeck ? 1 : 6);
        int censorNote = this.getLaunchControlPadNote(leftDeck ? 2 : 5);
        if (toggleScratchModeNote >= 0) {
            midiMappingList.add(this.createNoteMidiMapping("ScratchModeNext", channel, toggleScratchModeNote));
            midiTriggerList.add(this.createNoteMidiTrigger("ScratchModeActivated-Absolute", channel, toggleScratchModeNote, 28));
            midiTriggerList.add(this.createNoteMidiTrigger("ScratchModeActivated-Relative", channel, toggleScratchModeNote, 15));
            midiTriggerList.add(this.createNoteMidiTrigger("ScratchModeActivated-Splatter", channel, toggleScratchModeNote, 62));
            midiTriggerList.add(this.createNoteMidiTrigger("ScratchModeActivated-Ultimate", channel, toggleScratchModeNote, 60));
            midiTriggerList.add(this.createNoteMidiTrigger("ScratchModeActivated-Internal", channel, toggleScratchModeNote, 13));
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStopped", channel, toggleScratchModeNote, 12));
        }
        if (togglePitchModeNote >= 0) {
            midiMappingList.add(this.createNoteMidiMapping("PitchModeNext", channel, togglePitchModeNote));
            midiTriggerList.add(this.createNoteMidiTrigger("PitchModeActivated-Normal", channel, togglePitchModeNote, 28));
            midiTriggerList.add(this.createNoteMidiTrigger("PitchModeActivated-Custom", channel, togglePitchModeNote, 15));
            midiTriggerList.add(this.createNoteMidiTrigger("PitchModeActivated-Deck", channel, togglePitchModeNote, 62));
            midiTriggerList.add(this.createNoteMidiTrigger("PitchModeActivated-BPM", channel, togglePitchModeNote, 60));
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStopped", channel, togglePitchModeNote, 12));
        }
        if (censorNote >= 0) {
            midiMappingList.add(this.createNoteMidiMapping("Censor", channel, censorNote));
            midiTriggerList.add(this.createNoteMidiTrigger("CensorActivated", channel, censorNote, 15));
            midiTriggerList.add(this.createNoteMidiTrigger("CensorDeactivated", channel, censorNote, 13));
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStarted", channel, censorNote, 13));
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStopped", channel, censorNote, 12));
        }
        if (shiftToggleModesIndex >= 0) {
            midiMappingList.add(this.createControlMidiMapping("ShiftScratchMode", channel, shiftToggleModesIndex));
            midiMappingList.add(this.createControlMidiMapping("ShiftPitchMode", channel, shiftToggleModesIndex));
            midiMappingList.add(this.createControlMidiMapping("ShiftCensorGoofy", channel, shiftToggleModesIndex));
            midiTriggerList.add(this.createControlMidiTrigger("DeckStarted", channel, shiftToggleModesIndex, 13));
        }
        channel = multiDeckTrackControlChannel;
        int beatJumpDoubleIndex = 114;
        int beatJumpHalfIndex = 115;
        int shiftLiveFeedIndex = 117;
        int shiftInstantDoubleIndex = 116;
        int trackPrevNote = this.getLaunchControlPadNote(leftDeck ? 0 : 6);
        int trackNextNote = this.getLaunchControlPadNote(leftDeck ? 1 : 7);
        int beatJumpBwdNote = this.getLaunchControlPadNote(leftDeck ? 2 : 4);
        int beatJumpFwdNote = this.getLaunchControlPadNote(leftDeck ? 3 : 5);
        if (trackPrevNote >= 0) {
            midiMappingList.add(this.createNoteMidiMapping("SkipPrev", channel, trackPrevNote));
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStarted", channel, trackPrevNote, 60));
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStopped", channel, trackPrevNote, 12));
        }
        if (trackNextNote >= 0) {
            midiMappingList.add(this.createNoteMidiMapping("SkipNext", channel, trackNextNote));
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStarted", channel, trackNextNote, 60));
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStopped", channel, trackNextNote, 12));
        }
        if (shiftLiveFeedIndex >= 0) {
            midiMappingList.add(this.createControlMidiMapping("ShiftLiveFeed", channel, shiftLiveFeedIndex));
            midiTriggerList.add(this.createControlMidiTrigger("DeckStarted", channel, shiftLiveFeedIndex, 13));
        }
        if (shiftInstantDoubleIndex >= 0) {
            midiMappingList.add(this.createControlMidiMapping("ShiftInstantDouble", channel, shiftInstantDoubleIndex));
            midiTriggerList.add(this.createControlMidiTrigger("DeckStarted", channel, shiftInstantDoubleIndex, 13));
        }
        if (beatJumpBwdNote >= 0) {
            midiMappingList.add(this.createNoteMidiMapping("BeatJumpBackward", channel, beatJumpBwdNote));
            midiTriggerList.add(this.createNoteMidiTrigger("BeatJumpEnabled", channel, beatJumpBwdNote, 62));
            midiTriggerList.add(this.createNoteMidiTrigger("BeatJumpDisabled", channel, beatJumpBwdNote, 12));
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStopped", channel, beatJumpBwdNote, 12));
        }
        if (beatJumpFwdNote >= 0) {
            midiMappingList.add(this.createNoteMidiMapping("BeatJumpForward", channel, beatJumpFwdNote));
            midiTriggerList.add(this.createNoteMidiTrigger("BeatJumpEnabled", channel, beatJumpFwdNote, 62));
            midiTriggerList.add(this.createNoteMidiTrigger("BeatJumpDisabled", channel, beatJumpFwdNote, 12));
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStopped", channel, beatJumpFwdNote, 12));
        }
        if (beatJumpDoubleIndex >= 0) {
            midiMappingList.add(this.createControlMidiMapping("SetBeatJumpDouble", channel, beatJumpDoubleIndex));
            midiTriggerList.add(this.createControlMidiTrigger("BeatJumpEnabled", channel, beatJumpDoubleIndex, 15));
            midiTriggerList.add(this.createControlMidiTrigger("BeatJumpDisabled", channel, beatJumpDoubleIndex, 12));
        }
        if (beatJumpHalfIndex >= 0) {
            midiMappingList.add(this.createControlMidiMapping("SetBeatJumpHalf", channel, beatJumpHalfIndex));
            midiTriggerList.add(this.createControlMidiTrigger("BeatJumpEnabled", channel, beatJumpHalfIndex, 15));
            midiTriggerList.add(this.createControlMidiTrigger("BeatJumpDisabled", channel, beatJumpHalfIndex, 12));
        }
        int resetLaunchControlIndex = 0;
        int resetLaunchControlValue = 0;
        for (int i3 = 0; i3 < usedChannels.length; ++i3) {
            midiTriggerList.add(this.createControlMidiTrigger("DeckStopped", usedChannels[i3], resetLaunchControlIndex, resetLaunchControlValue));
        }
        MidiMapping[] midiMappings = midiMappingList.toArray(new MidiMapping[midiMappingList.size()]);
        Properties midiMappingProps = MidiMappingUtil.formatPresetMidiMappings((MidiMapping[])midiMappings);
        MidiTrigger[] midiTriggers = midiTriggerList.toArray(new MidiTrigger[midiTriggerList.size()]);
        Properties midiTriggerProps = MidiMappingUtil.formatPresetMidiTriggers((MidiTrigger[])midiTriggers);
        Preset preset = new Preset();
        preset.setPresetName(name);
        preset.setDeviceName("WaxLabScratchDeck");
        preset.setProviderName(this.getClass().getName());
        Properties props = new Properties();
        props.putAll((Map<?, ?>)midiMappingProps);
        props.putAll((Map<?, ?>)midiTriggerProps);
        preset.setProperties(props);
        return preset;
    }

    protected int getLaunchControlPadNote(int pad) {
        switch (pad) {
            case 0: {
                return 9;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 25;
            }
            case 5: {
                return 26;
            }
            case 6: {
                return 27;
            }
            case 7: {
                return 28;
            }
        }
        return -1;
    }

    protected MidiMapping createTemplateChangedMidiMapping(String action) {
        return new MidiMapping(-1, 240, 0, action);
    }

    protected void createSlipModeMidiTriggers(int channel, int toggleSlipModeControlIndex, List midiTriggerList) {
        midiTriggerList.add(this.createControlMidiTrigger("SlipModeEnabled", channel, toggleSlipModeControlIndex, 15));
        midiTriggerList.add(this.createControlMidiTrigger("SlipModeDisabled", channel, toggleSlipModeControlIndex, 13));
        midiTriggerList.add(this.createControlMidiTrigger("DeckStopped", channel, toggleSlipModeControlIndex, 12));
    }

    protected void createCuePointMidiTriggers(int channel, int cuePointNote, String cuePointSuffix, List midiTriggerList) {
        midiTriggerList.add(this.createNoteMidiTrigger("CuePointAdded-" + cuePointSuffix, channel, cuePointNote, 15));
        midiTriggerList.add(this.createNoteMidiTrigger("CuePointRemoved-" + cuePointSuffix, channel, cuePointNote, 13));
        midiTriggerList.add(this.createNoteMidiTrigger("DeckStopped", channel, cuePointNote, 12));
    }

    protected void createLoopRollMidiTriggers(int channel, int loopRollNote, String loopRollSuffix, List midiTriggerList) {
        midiTriggerList.add(this.createNoteMidiTrigger("LoopRollStarted-" + loopRollSuffix, channel, loopRollNote, 60));
        midiTriggerList.add(this.createNoteMidiTrigger("LoopRollStopped-" + loopRollSuffix, channel, loopRollNote, 28));
        midiTriggerList.add(this.createNoteMidiTrigger("DeckStopped", channel, loopRollNote, 12));
    }

    protected void createAutoLoopMidiTriggers(int channel, int autoLoopNote, String autoLoopSuffix, List midiTriggerList) {
        midiTriggerList.add(this.createNoteMidiTrigger("AutoLoopStarted-" + autoLoopSuffix, channel, autoLoopNote, 62));
        midiTriggerList.add(this.createNoteMidiTrigger("AutoLoopStopped-" + autoLoopSuffix, channel, autoLoopNote, 29));
        midiTriggerList.add(this.createNoteMidiTrigger("DeckStopped", channel, autoLoopNote, 12));
    }
}

