/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.presets;

import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.midi.common.MidiMappingUtil;
import com.waxmonster.studio.Preset;
import com.waxmonster.studio.presets.AbstractStudioPresetProvider;
import com.waxmonster.studio.presets.NovationLaunchControlMidiConst;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public class NovationLaunchControlWaxLabPresetProvider
extends AbstractStudioPresetProvider
implements NovationLaunchControlMidiConst {
    public static final String PROVIDER_NAME = "NovationLaunchControlWaxLab";

    public NovationLaunchControlWaxLabPresetProvider() {
        super(PROVIDER_NAME);
    }

    public Preset[] getPresets() {
        return new Preset[]{this.createLaunchControlPreset()};
    }

    protected Preset createLaunchControlPreset() {
        String name = "NovationLaunchControl";
        int waxLabControlChannel = 8;
        LinkedList<MidiMapping> midiMappingList = new LinkedList<MidiMapping>();
        LinkedList<MidiTrigger> midiTriggerList = new LinkedList<MidiTrigger>();
        int channel = waxLabControlChannel;
        midiMappingList.add(this.createNoteMidiMapping("Start", channel, 9));
        midiMappingList.add(this.createNoteMidiMapping("Pause", channel, 10));
        midiMappingList.add(this.createNoteMidiMapping("Stop", channel, 11));
        midiMappingList.add(this.createTemplateChangedMidiMapping("RefreshLighting"));
        channel = waxLabControlChannel;
        midiTriggerList.add(this.createNoteMidiTrigger("Started", channel, 9, 28));
        midiTriggerList.add(this.createNoteMidiTrigger("Started", channel, 10, 63));
        midiTriggerList.add(this.createNoteMidiTrigger("Started", channel, 11, 15));
        midiTriggerList.add(this.createNoteMidiTrigger("Stopped", channel, 9, 60));
        midiTriggerList.add(this.createNoteMidiTrigger("Stopped", channel, 10, 29));
        midiTriggerList.add(this.createNoteMidiTrigger("Stopped", channel, 11, 13));
        MidiMapping[] midiMappings = midiMappingList.toArray(new MidiMapping[midiMappingList.size()]);
        Properties midiMappingProps = MidiMappingUtil.formatPresetMidiMappings((MidiMapping[])midiMappings);
        MidiTrigger[] midiTriggers = midiTriggerList.toArray(new MidiTrigger[midiTriggerList.size()]);
        Properties midiTriggerProps = MidiMappingUtil.formatPresetMidiTriggers((MidiTrigger[])midiTriggers);
        Preset preset = new Preset();
        preset.setPresetName(name);
        preset.setDeviceName("WaxLabMidiControl");
        preset.setProviderName(this.getClass().getName());
        Properties props = new Properties();
        props.putAll((Map<?, ?>)midiMappingProps);
        props.putAll((Map<?, ?>)midiTriggerProps);
        preset.setProperties(props);
        return preset;
    }

    protected MidiMapping createTemplateChangedMidiMapping(String action) {
        return new MidiMapping(-1, 240, 0, action);
    }
}

