/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.presets;

import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.midi.common.MidiMappingUtil;
import com.waxmonster.studio.Preset;
import com.waxmonster.studio.presets.AbstractStudioPresetProvider;
import com.waxmonster.studio.presets.Rane12MidiConst;
import java.awt.Color;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public class Rane12ScratchDeckPresetProvider
extends AbstractStudioPresetProvider
implements Rane12MidiConst {
    public static final String PROVIDER_NAME = "RANE Twelve";

    public Rane12ScratchDeckPresetProvider() {
        super(PROVIDER_NAME);
    }

    public Preset[] getPresets() {
        return new Preset[]{this.createRane12Preset(1), this.createRane12Preset(2), this.createRane12Preset(3), this.createRane12Preset(4)};
    }

    protected Preset createRane12Preset(int deck) {
        int i;
        String name = "Rane12-Deck" + deck;
        int channelNavigate = 15;
        int channelDeck = this.getMidiChannelForRane12Deck(deck);
        int channelCue = this.getMidiChannelForRane12Cue(deck);
        int cuePointCount = 8;
        int colorOff = 0;
        int colorRedFull = Rane12ScratchDeckPresetProvider.getRane12ValueForColor(3, 0, 0);
        int colorRedLow = Rane12ScratchDeckPresetProvider.getRane12ValueForColor(1, 0, 0);
        LinkedList<MidiMapping> midiMappingList = new LinkedList<MidiMapping>();
        LinkedList<MidiTrigger> midiTriggerList = new LinkedList<MidiTrigger>();
        midiMappingList.add(this.createControlMidiMapping("NavigateMove", channelNavigate, 0));
        midiMappingList.add(this.createNoteMidiMapping("NavigateBack", channelNavigate, 7));
        midiMappingList.add(this.createNoteMidiMapping("NavigatePush", channelDeck, 2));
        midiTriggerList.add(this.createStartMotorTrigger("DeckStarted", channelDeck));
        midiTriggerList.add(this.createStopMotorTrigger("DeckStopped", channelDeck));
        for (i = 0; i < cuePointCount; ++i) {
            String suffix = Integer.toString(i + 1);
            int cueButtonNote = 20 + i;
            int cueDeleteNote = 28 + i;
            midiMappingList.add(this.createNoteMidiMapping("JumpOrSetCuePoint-" + suffix, channelCue, cueButtonNote));
            midiMappingList.add(this.createNoteMidiMapping("RemoveCuePoint-" + suffix, channelCue, cueDeleteNote));
            midiTriggerList.add(this.createNoteMidiTrigger("CuePointAdded-" + suffix, channelCue, cueButtonNote, colorRedFull));
            midiTriggerList.add(this.createNoteMidiTrigger("CuePointRemoved-" + suffix, channelCue, cueButtonNote, colorRedLow));
        }
        for (i = 0; i < cuePointCount; ++i) {
            int cuePointNote = 20 + i;
            midiTriggerList.add(this.createNoteMidiTrigger("DeckStopped", channelCue, cuePointNote, colorOff));
        }
        MidiMapping[] midiMappings = midiMappingList.toArray(new MidiMapping[midiMappingList.size()]);
        Properties midiMappingProps = MidiMappingUtil.formatPresetMidiMappings((MidiMapping[])midiMappings);
        MidiTrigger[] midiTriggers = midiTriggerList.toArray(new MidiTrigger[midiTriggerList.size()]);
        Properties midiTriggerProps = MidiMappingUtil.formatPresetMidiTriggers((MidiTrigger[])midiTriggers);
        Preset preset = new Preset();
        preset.setPresetName(name);
        preset.setDeviceName("WaxLabScratchDeck");
        preset.setProviderName(this.getClass().getName());
        Properties props = new Properties();
        props.putAll((Map<?, ?>)midiMappingProps);
        props.putAll((Map<?, ?>)midiTriggerProps);
        preset.setProperties(props);
        return preset;
    }

    protected MidiTrigger createStartMotorTrigger(String event, int channel) {
        return new MidiTrigger(event, channel, 176, 67, 127);
    }

    protected MidiTrigger createStopMotorTrigger(String event, int channel) {
        return new MidiTrigger(event, channel, 176, 68, 127);
    }

    protected int getMidiChannelForRane12Deck(int twelveDeck) {
        switch (twelveDeck) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return -1;
    }

    protected int getMidiChannelForRane12Cue(int twelveDeck) {
        switch (twelveDeck) {
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 7;
            }
        }
        return -1;
    }

    public static final int getRane12ValueForColor(Color color) {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        int vR = Math.round(r * 3.0f) & 3;
        int vG = Math.round(g * 3.0f) & 3;
        int vB = Math.round(b * 3.0f) & 3;
        return Rane12ScratchDeckPresetProvider.getRane12ValueForColor(vR, vG, vB);
    }

    private static final int getRane12ValueForColor(int vR, int vG, int vB) {
        return vR << 4 | vG << 2 | vB << 0;
    }
}

