/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.presets;

import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.midi.common.MidiMappingUtil;
import com.waxmonster.studio.Preset;
import com.waxmonster.studio.presets.AbstractStudioPresetProvider;
import com.waxmonster.studio.presets.Rane62MidiConst;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public class Rane62ScratchDeckPresetProvider
extends AbstractStudioPresetProvider
implements Rane62MidiConst {
    public static final String PROVIDER_NAME = "Rane62ScratchDeck";

    public Rane62ScratchDeckPresetProvider() {
        super(PROVIDER_NAME);
    }

    public Preset[] getPresets() {
        return new Preset[]{this.createRanePreset(true), this.createRanePreset(false)};
    }

    protected Preset createRanePreset(boolean leftDeck) {
        int i;
        String name = "Rane62-";
        name = leftDeck ? name + "LeftDeck" : name + "RightDeck";
        int deckChannel = 0;
        int buttonCount = 5;
        LinkedList<MidiMapping> midiMappingList = new LinkedList<MidiMapping>();
        midiMappingList.add(this.createRaneScrollControlMidiMapping(leftDeck, deckChannel));
        midiMappingList.add(this.createRaneScrollPushMidiMapping(leftDeck, deckChannel));
        midiMappingList.add(this.createRaneScrollBackMidiMapping(leftDeck, deckChannel));
        midiMappingList.add(this.createRaneShiftDeleteMidiMapping(leftDeck, deckChannel));
        for (int i2 = 0; i2 < buttonCount; ++i2) {
            midiMappingList.add(this.createRaneCueMidiMapping(leftDeck, deckChannel, i2));
        }
        midiMappingList.add(this.createRaneInstantDoubleMidiMapping(leftDeck, deckChannel));
        MidiMapping[] midiMappings = midiMappingList.toArray(new MidiMapping[midiMappingList.size()]);
        Properties midiMappingProps = MidiMappingUtil.formatPresetMidiMappings((MidiMapping[])midiMappings);
        LinkedList<MidiTrigger> midiTriggerList = new LinkedList<MidiTrigger>();
        for (i = 0; i < buttonCount; ++i) {
            midiTriggerList.add(this.createRaneCueMidiTrigger(leftDeck, deckChannel, i, true));
        }
        for (i = 0; i < buttonCount; ++i) {
            midiTriggerList.add(this.createRaneCueMidiTrigger(leftDeck, deckChannel, i, false));
        }
        MidiTrigger[] midiTriggers = midiTriggerList.toArray(new MidiTrigger[midiTriggerList.size()]);
        Properties midiTriggerProps = MidiMappingUtil.formatPresetMidiTriggers((MidiTrigger[])midiTriggers);
        Preset preset = new Preset();
        preset.setPresetName(name);
        preset.setDeviceName("WaxLabScratchDeck");
        preset.setProviderName(this.getClass().getName());
        Properties props = new Properties();
        props.putAll((Map<?, ?>)midiMappingProps);
        props.putAll((Map<?, ?>)midiTriggerProps);
        preset.setProperties(props);
        return preset;
    }

    protected MidiMapping createRaneInstantDoubleMidiMapping(boolean leftDeck, int channel) {
        String action = "DoubleClickInstantDouble";
        int note = leftDeck ? 44 : 55;
        return new MidiMapping(channel, 144, note, action);
    }

    protected MidiMapping createRaneShiftDeleteMidiMapping(boolean leftDeck, int channel) {
        String action = "ShiftRemoveCuePoint";
        int note = leftDeck ? 19 : 79;
        return new MidiMapping(channel, 144, note, action);
    }

    protected MidiMapping createRaneCueMidiMapping(boolean leftDeck, int channel, int buttonIndex) {
        String suffix = Integer.toString(buttonIndex + 1);
        String action = "JumpOrSetOrRemoveCuePoint-" + suffix;
        int note = this.getRaneCuePointNote(leftDeck, buttonIndex);
        if (note < 0) {
            return null;
        }
        return new MidiMapping(channel, 144, note, action);
    }

    protected MidiTrigger createRaneCueMidiTrigger(boolean leftDeck, int channel, int buttonIndex, boolean addedOrRemoved) {
        int value;
        String event;
        String suffix = Integer.toString(buttonIndex + 1);
        int note = this.getRaneCuePointNote(leftDeck, buttonIndex);
        if (note < 0) {
            return null;
        }
        if (addedOrRemoved) {
            event = "CuePointAdded-" + suffix;
            value = 48;
        } else {
            event = "CuePointRemoved-" + suffix;
            value = 0;
        }
        return new MidiTrigger(event, channel, 144, note, value);
    }

    protected int getRaneCuePointNote(boolean leftDeck, int buttonIndex) {
        if (leftDeck) {
            switch (buttonIndex) {
                case 0: {
                    return 18;
                }
                case 1: {
                    return 23;
                }
                case 2: {
                    return 22;
                }
                case 3: {
                    return 21;
                }
                case 4: {
                    return 20;
                }
            }
            return -1;
        }
        switch (buttonIndex) {
            case 0: {
                return 78;
            }
            case 1: {
                return 73;
            }
            case 2: {
                return 74;
            }
            case 3: {
                return 75;
            }
            case 4: {
                return 76;
            }
        }
        return -1;
    }

    protected MidiMapping createRaneScrollControlMidiMapping(boolean leftDeck, int channel) {
        String action = "NavigateMove";
        int index = leftDeck ? 16 : 18;
        return new MidiMapping(channel, 176, index, action);
    }

    protected MidiMapping createRaneScrollPushMidiMapping(boolean leftDeck, int channel) {
        String action = "NavigatePush";
        int index = leftDeck ? 44 : 55;
        return new MidiMapping(channel, 144, index, action);
    }

    protected MidiMapping createRaneScrollBackMidiMapping(boolean leftDeck, int channel) {
        String action = "NavigateBack";
        int index = leftDeck ? 43 : 52;
        return new MidiMapping(channel, 144, index, action);
    }
}

