/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.waxmonster.midi.MidiMappable;
import com.waxmonster.midi.MidiMapper;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.common.AbstractMidiMapper;
import com.waxmonster.swing.ColorButton;
import com.waxmonster.swing.ColorButtonStyle;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.ScratchLine;
import com.waxmonster.waxlab.dvs.DvsBorderPanel;
import com.waxmonster.waxlab.dvs.Scalable;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;

public abstract class AbstractControlElementPanel
extends DvsBorderPanel
implements Scalable,
MidiMappable {
    private static final long serialVersionUID = 5881860970888439828L;
    protected MidiMapperImpl midiMapper = new MidiMapperImpl();
    protected ScratchDeck scratchDeck;
    protected WaxLabViewSettings viewSettings;
    protected ColorButtonStyle defaultButtonStyle;
    protected double variableFactor;

    public ScratchDeck getScratchDeck() {
        return this.scratchDeck;
    }

    public void setScratchDeck(ScratchDeck scratchDeck) {
        this.scratchDeck = scratchDeck;
        this.refreshScratchDeck();
    }

    protected abstract void refreshScratchDeck();

    public WaxLabViewSettings getViewSettings() {
        return this.viewSettings;
    }

    public void setViewSettings(WaxLabViewSettings viewSettings) {
        this.viewSettings = viewSettings;
        this.refreshViewSettings();
    }

    protected abstract void refreshViewSettings();

    public ColorButtonStyle getDefaultButtonStyle() {
        return this.defaultButtonStyle;
    }

    public void setDefaultButtonStyle(ColorButtonStyle defaultButtonStyle) {
        this.defaultButtonStyle = defaultButtonStyle;
        this.refreshViewSettings();
    }

    protected ColorButtonStyle createColorButtonStyle(Color color) {
        ColorButtonStyle style = new ColorButtonStyle(color);
        style.setRolloverBackground(null);
        style.setPressedBackground(null);
        return style;
    }

    protected ColorButton createDvsColorButton(String name, String text, ColorButtonStyle style) {
        ColorButton button = new ColorButton();
        button.setName(name);
        button.setText(text);
        button.setRolloverEnabled(true);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setColorButtonStyle(style);
        button.setMinimumSize(new Dimension(10, 10));
        return button;
    }

    @Override
    public double getVariableFactor() {
        return this.variableFactor;
    }

    @Override
    public void setVariableFactor(double variableFactor) {
        this.variableFactor = variableFactor;
    }

    protected void resizeComponents(JComponent[] comps, double variableFactor) {
        int num = comps == null ? 0 : comps.length;
        for (int i = 0; i < num; ++i) {
            this.resizeComponent(comps[i], variableFactor);
        }
    }

    protected void resizeComponent(JComponent comp, double variableFactor) {
        if (comp == null) {
            return;
        }
        Dimension dim = comp.getMinimumSize();
        comp.setPreferredSize(new Dimension(dim.width + (int)variableFactor, dim.height + (int)variableFactor));
    }

    public MidiMapper getMidiMapper() {
        return this.midiMapper;
    }

    protected class MidiMapperImpl
    extends AbstractMidiMapper {
        protected MidiMapperImpl() {
        }

        public MidiMapping[] getMidiMappings(Object component) {
            ScratchDeck scratchDeck = AbstractControlElementPanel.this.getScratchDeck();
            if (scratchDeck == null) {
                return null;
            }
            ScratchLine scratchLine = scratchDeck.getScratchLine();
            if (scratchLine == null) {
                return null;
            }
            return scratchLine.getMidiMappings();
        }

        public void setMidiMappings(Object component, MidiMapping[] mappings) {
            ScratchDeck scratchDeck = AbstractControlElementPanel.this.getScratchDeck();
            if (scratchDeck == null) {
                return;
            }
            ScratchLine scratchLine = scratchDeck.getScratchLine();
            if (scratchLine == null) {
                return;
            }
            scratchLine.setMidiMappings(mappings);
        }
    }
}

