/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.waxmonster.swing.ColorButton;
import com.waxmonster.swing.ColorButtonAdapter;
import com.waxmonster.swing.ColorButtonListener;
import com.waxmonster.swing.ColorButtonStyle;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.dvs.AbstractControlElementPanel;
import com.waxmonster.waxlab.dvs.DvsButtonsPanel;
import com.waxmonster.waxlab.dvs.ScalableWeight;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class DeckAutoLoopsPanel
extends AbstractControlElementPanel {
    private static final long serialVersionUID = 3646179249154503745L;
    private static final Logger logger = Logger.getLogger(DeckAutoLoopsPanel.class.getName());
    private ColorButtonStyle styleAutoLoop;
    private ColorButton[] autoLoopButtons = new ColorButton[0];
    private DvsButtonsPanel buttonsPanel;

    public DeckAutoLoopsPanel() {
        this.setLayout(new GridLayout(1, 1));
        this.setTitle("Auto Loop");
        this.buttonsPanel = new DvsButtonsPanel();
        this.add(this.buttonsPanel);
    }

    @Override
    public void getVariableWeight(ScalableWeight dst) {
        dst.width = this.autoLoopButtons.length;
        dst.height = 1.0;
    }

    @Override
    public void setVariableFactor(double variableFactor) {
        super.setVariableFactor(variableFactor);
        this.resizeComponents((JComponent[])this.autoLoopButtons, variableFactor);
        this.buttonsPanel.invalidate();
    }

    @Override
    protected synchronized void refreshScratchDeck() {
        int oldCount;
        ScratchDeck scratchDeck = this.scratchDeck;
        int newCount = 0;
        if (scratchDeck != null) {
            newCount = scratchDeck.getAutoLoopCount();
        }
        if (newCount != (oldCount = this.autoLoopButtons.length)) {
            ColorButton[] arr = new ColorButton[newCount];
            int num = Math.min(oldCount, newCount);
            System.arraycopy(this.autoLoopButtons, 0, arr, 0, num);
            for (int i = num; i < newCount; ++i) {
                ColorButton button = this.createDvsColorButton("AutoLoop#" + i, "", this.styleAutoLoop);
                button.addColorButtonListener((ColorButtonListener)new AutoLoopButtonHandler(i));
                button.setToolTipText("Auto-Loop " + button.getText());
                button.setToolTipEnabled(false);
                button.setDisarmed(true);
                button.setRequestFocusEnabled(false);
                arr[i] = button;
            }
            this.autoLoopButtons = arr;
        }
        this.buttonsPanel.setButtons((Component[])this.autoLoopButtons);
    }

    @Override
    protected synchronized void refreshViewSettings() {
        WaxLabViewSettings viewSettings = this.getViewSettings();
        if (viewSettings == null) {
            return;
        }
        Color col = viewSettings.getDvsAutoLoopColor();
        this.styleAutoLoop = col == null ? this.defaultButtonStyle : this.createColorButtonStyle(col);
        ColorButton[] buttons = this.autoLoopButtons;
        if (buttons != null) {
            for (int i = 0; i < buttons.length; ++i) {
                this.refreshAutoLoopButton(i);
            }
        }
    }

    protected void refreshAutoLoopButton(int index) {
        ColorButton button;
        ColorButton[] buttons = this.autoLoopButtons;
        if (index >= 0 && index < buttons.length && (button = buttons[index]) != null) {
            ColorButtonStyle style = this.styleAutoLoop;
            if (style == null) {
                style = this.defaultButtonStyle;
            }
            button.setColorButtonStyle(style);
            this.midiMapper.registerMidiAction(button, "AutoLoop-" + String.valueOf(index + 1));
        }
    }

    protected void handleAutoLoopPressed(int index) {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleAutoLoopPressed: #" + index);
        }
        if ((deck = this.scratchDeck) != null) {
            deck.toggleAutoLoop(index);
        }
    }

    protected void handleAutoLoopReleased(int index) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleAutoLoopReleased: #" + index);
        }
    }

    public void autoLoopStarted(ScratchDeck deck, int index) {
        ColorButton[] buttons = this.autoLoopButtons;
        if (index >= 0 && index < buttons.length) {
            buttons[index].setSelected(true);
        }
    }

    public void autoLoopStopped(ScratchDeck deck, int index) {
        ColorButton[] buttons = this.autoLoopButtons;
        if (index >= 0 && index < buttons.length) {
            buttons[index].setSelected(false);
        }
    }

    protected class AutoLoopButtonHandler
    extends ColorButtonAdapter {
        private int autoLoopIndex;

        public AutoLoopButtonHandler(int autoLoopIndex) {
            this.autoLoopIndex = autoLoopIndex;
        }

        public void buttonPressed(ActionEvent event) {
            super.buttonPressed(event);
            DeckAutoLoopsPanel.this.handleAutoLoopPressed(this.autoLoopIndex);
        }

        public void buttonPressed(MouseEvent event) {
            super.buttonPressed(event);
            DeckAutoLoopsPanel.this.handleAutoLoopPressed(this.autoLoopIndex);
        }

        public void buttonReleased(ActionEvent event) {
            super.buttonReleased(event);
            DeckAutoLoopsPanel.this.handleAutoLoopReleased(this.autoLoopIndex);
        }

        public void buttonReleased(MouseEvent event) {
            super.buttonReleased(event);
            DeckAutoLoopsPanel.this.handleAutoLoopReleased(this.autoLoopIndex);
        }
    }
}

