/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.spacekiller.util.Tools;
import com.waxmonster.swing.ColorButton;
import com.waxmonster.swing.ColorButtonAdapter;
import com.waxmonster.swing.ColorButtonListener;
import com.waxmonster.swing.ColorButtonStyle;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.dvs.AbstractControlElementPanel;
import com.waxmonster.waxlab.dvs.BeatsLabel;
import com.waxmonster.waxlab.dvs.DvsButtonsPanel;
import com.waxmonster.waxlab.dvs.DvsDeckControlPanel;
import com.waxmonster.waxlab.dvs.ScalableWeight;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class DeckBeatJumpPanel
extends AbstractControlElementPanel {
    private static final long serialVersionUID = 1828933310843110110L;
    private static final Logger logger = Logger.getLogger(DeckBeatJumpPanel.class.getName());
    private ColorButtonStyle styleBeatJump;
    private ColorButton jumpBackwardButton;
    private ColorButton jumpForwardButton;
    private BeatsLabel jumpBeatsLabel;
    private ColorButton jumpIncreaseButton;
    private ColorButton jumpDecreaseButton;
    private DvsButtonsPanel buttonsPanel;

    public DeckBeatJumpPanel() {
        this.setLayout(new GridLayout(1, 1));
        this.setTitle("Beat Jump");
        this.buttonsPanel = new DvsButtonsPanel();
        this.add(this.buttonsPanel);
    }

    @Override
    public void getVariableWeight(ScalableWeight dst) {
        dst.width = 5.0;
        dst.height = 1.0;
    }

    @Override
    public void setVariableFactor(double variableFactor) {
        super.setVariableFactor(variableFactor);
        this.resizeComponent((JComponent)this.jumpBackwardButton, variableFactor);
        this.resizeComponent((JComponent)this.jumpForwardButton, variableFactor);
        this.resizeComponent((JComponent)this.jumpIncreaseButton, variableFactor);
        this.resizeComponent((JComponent)this.jumpDecreaseButton, variableFactor);
        this.buttonsPanel.invalidate();
    }

    @Override
    protected synchronized void refreshScratchDeck() {
        ColorButton button;
        ScratchDeck scratchDeck = this.scratchDeck;
        if (this.jumpBackwardButton == null) {
            button = this.createDvsColorButton("BeatJumpBackward", "", this.styleBeatJump);
            button.addColorButtonListener((ColorButtonListener)new JumpBackwardButtonHandler());
            button.setToolTipText("Jump backward");
            button.setToolTipEnabled(false);
            button.setDisarmed(true);
            button.setRequestFocusEnabled(false);
            button.setIcon(Tools.getIcon(DvsDeckControlPanel.class, (String)"/com/waxmonster/waxlab/dvs/icons/beatjump_backward_icon16.png"));
            this.midiMapper.registerMidiAction(button, "BeatJumpBackward");
            this.jumpBackwardButton = button;
        }
        if (this.jumpForwardButton == null) {
            button = this.createDvsColorButton("BeatJumpForward", "", this.styleBeatJump);
            button.addColorButtonListener((ColorButtonListener)new JumpForwardButtonHandler());
            button.setToolTipText("Jump forward");
            button.setToolTipEnabled(false);
            button.setDisarmed(true);
            button.setRequestFocusEnabled(false);
            button.setIcon(Tools.getIcon(DvsDeckControlPanel.class, (String)"/com/waxmonster/waxlab/dvs/icons/beatjump_forward_icon16.png"));
            this.midiMapper.registerMidiAction(button, "BeatJumpForward");
            this.jumpForwardButton = button;
        }
        if (this.jumpIncreaseButton == null) {
            button = this.createDvsColorButton("BeatJumpIncrease", "", this.styleBeatJump);
            button.addColorButtonListener((ColorButtonListener)new JumpIncreaseButtonHandler());
            button.setToolTipText("Increase");
            button.setToolTipEnabled(false);
            button.setDisarmed(true);
            button.setRequestFocusEnabled(false);
            button.setIcon(Tools.getIcon(DvsDeckControlPanel.class, (String)"/com/waxmonster/waxlab/dvs/icons/beatjump_increase_icon16.png"));
            this.midiMapper.registerMidiAction(button, "SetBeatJumpDouble");
            this.jumpIncreaseButton = button;
        }
        if (this.jumpDecreaseButton == null) {
            button = this.createDvsColorButton("BeatJumpDecrease", "", this.styleBeatJump);
            button.addColorButtonListener((ColorButtonListener)new JumpDecreaseButtonHandler());
            button.setToolTipText("Decrease");
            button.setToolTipEnabled(false);
            button.setDisarmed(true);
            button.setRequestFocusEnabled(false);
            button.setIcon(Tools.getIcon(DvsDeckControlPanel.class, (String)"/com/waxmonster/waxlab/dvs/icons/beatjump_decrease_icon16.png"));
            this.midiMapper.registerMidiAction(button, "SetBeatJumpHalf");
            this.jumpDecreaseButton = button;
        }
        if (this.jumpBeatsLabel == null) {
            BeatsLabel label = new BeatsLabel();
            label.setHorizontalAlignment(0);
            this.jumpBeatsLabel = label;
        }
        Component[] arr = new Component[]{this.jumpBackwardButton, this.jumpForwardButton, this.jumpBeatsLabel, this.jumpIncreaseButton, this.jumpDecreaseButton};
        this.buttonsPanel.setButtons(arr);
        this.jumpBeatsChanged(scratchDeck);
    }

    @Override
    protected synchronized void refreshViewSettings() {
        WaxLabViewSettings viewSettings = this.getViewSettings();
        if (viewSettings == null) {
            return;
        }
        Color col = viewSettings.getDvsBeatJumpColor();
        this.styleBeatJump = col == null ? this.defaultButtonStyle : this.createColorButtonStyle(col);
        this.jumpBackwardButton.setColorButtonStyle(this.styleBeatJump);
        this.jumpForwardButton.setColorButtonStyle(this.styleBeatJump);
        this.jumpIncreaseButton.setColorButtonStyle(this.styleBeatJump);
        this.jumpDecreaseButton.setColorButtonStyle(this.styleBeatJump);
        this.jumpBeatsLabel.setForeground(viewSettings.getDvsBeatLengthColor());
    }

    protected void handleJumpBackwardPressed() {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleJumpBackwardPressed");
        }
        if ((deck = this.scratchDeck) != null) {
            deck.beatJumpBackward();
        }
    }

    protected void handleJumpBackwardReleased() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleJumpBackwardReleased");
        }
    }

    protected void handleJumpForwardPressed() {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleJumpForwardPressed");
        }
        if ((deck = this.scratchDeck) != null) {
            deck.beatJumpForward();
        }
    }

    protected void handleJumpForwardReleased() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleJumpForwardReleased");
        }
    }

    protected void handleJumpIncreasePressed() {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleJumpIncreasePressed");
        }
        if ((deck = this.scratchDeck) != null) {
            deck.getBeatJumpControl().setDoubleBeatJump();
        }
    }

    protected void handleJumpIncreaseReleased() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleJumpIncreaseReleased");
        }
    }

    protected void handleJumpDecreasePressed() {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleJumpDecreasePressed");
        }
        if ((deck = this.scratchDeck) != null) {
            deck.getBeatJumpControl().setHalfBeatJump();
        }
    }

    protected void handleJumpDecreaseReleased() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleJumpDecreaseReleased");
        }
    }

    public void beatJumpEnabled(ScratchDeck deck) {
        this.jumpBackwardButton.setEnabled(true);
        this.jumpForwardButton.setEnabled(true);
    }

    public void beatJumpDisabled(ScratchDeck deck) {
        this.jumpBackwardButton.setEnabled(false);
        this.jumpForwardButton.setEnabled(false);
    }

    public void jumpBeatsChanged(ScratchDeck deck) {
        double jumpBeats = deck == null ? 0.0 : deck.getBeatJumpControl().getDouble();
        this.jumpBeatsLabel.setBeats(jumpBeats);
    }

    protected class JumpDecreaseButtonHandler
    extends ColorButtonAdapter {
        protected JumpDecreaseButtonHandler() {
        }

        public void buttonPressed(ActionEvent event) {
            super.buttonPressed(event);
            DeckBeatJumpPanel.this.handleJumpDecreasePressed();
        }

        public void buttonPressed(MouseEvent event) {
            super.buttonPressed(event);
            DeckBeatJumpPanel.this.handleJumpDecreasePressed();
        }

        public void buttonReleased(ActionEvent event) {
            super.buttonReleased(event);
            DeckBeatJumpPanel.this.handleJumpDecreaseReleased();
        }

        public void buttonReleased(MouseEvent event) {
            super.buttonReleased(event);
            DeckBeatJumpPanel.this.handleJumpDecreaseReleased();
        }
    }

    protected class JumpIncreaseButtonHandler
    extends ColorButtonAdapter {
        protected JumpIncreaseButtonHandler() {
        }

        public void buttonPressed(ActionEvent event) {
            super.buttonPressed(event);
            DeckBeatJumpPanel.this.handleJumpIncreasePressed();
        }

        public void buttonPressed(MouseEvent event) {
            super.buttonPressed(event);
            DeckBeatJumpPanel.this.handleJumpIncreasePressed();
        }

        public void buttonReleased(ActionEvent event) {
            super.buttonReleased(event);
            DeckBeatJumpPanel.this.handleJumpIncreaseReleased();
        }

        public void buttonReleased(MouseEvent event) {
            super.buttonReleased(event);
            DeckBeatJumpPanel.this.handleJumpIncreaseReleased();
        }
    }

    protected class JumpForwardButtonHandler
    extends ColorButtonAdapter {
        protected JumpForwardButtonHandler() {
        }

        public void buttonPressed(ActionEvent event) {
            super.buttonPressed(event);
            DeckBeatJumpPanel.this.handleJumpForwardPressed();
        }

        public void buttonPressed(MouseEvent event) {
            super.buttonPressed(event);
            DeckBeatJumpPanel.this.handleJumpForwardPressed();
        }

        public void buttonReleased(ActionEvent event) {
            super.buttonReleased(event);
            DeckBeatJumpPanel.this.handleJumpForwardReleased();
        }

        public void buttonReleased(MouseEvent event) {
            super.buttonReleased(event);
            DeckBeatJumpPanel.this.handleJumpForwardReleased();
        }
    }

    protected class JumpBackwardButtonHandler
    extends ColorButtonAdapter {
        protected JumpBackwardButtonHandler() {
        }

        public void buttonPressed(ActionEvent event) {
            super.buttonPressed(event);
            DeckBeatJumpPanel.this.handleJumpBackwardPressed();
        }

        public void buttonPressed(MouseEvent event) {
            super.buttonPressed(event);
            DeckBeatJumpPanel.this.handleJumpBackwardPressed();
        }

        public void buttonReleased(ActionEvent event) {
            super.buttonReleased(event);
            DeckBeatJumpPanel.this.handleJumpBackwardReleased();
        }

        public void buttonReleased(MouseEvent event) {
            super.buttonReleased(event);
            DeckBeatJumpPanel.this.handleJumpBackwardReleased();
        }
    }
}

