/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.spacekiller.util.Tools;
import com.waxmonster.swing.ColorButton;
import com.waxmonster.swing.ColorButtonAdapter;
import com.waxmonster.swing.ColorButtonListener;
import com.waxmonster.swing.ColorButtonStyle;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.dvs.AbstractControlElementPanel;
import com.waxmonster.waxlab.dvs.BeatsLabel;
import com.waxmonster.waxlab.dvs.DvsButtonsPanel;
import com.waxmonster.waxlab.dvs.DvsDeckControlPanel;
import com.waxmonster.waxlab.dvs.ScalableWeight;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;

public class DeckBeatSlicerPanel
extends AbstractControlElementPanel {
    private static final long serialVersionUID = -5125655369284225951L;
    private static final Logger logger = Logger.getLogger(DeckBeatSlicerPanel.class.getName());
    private ColorButtonStyle styleBeatSlicer;
    private ColorButton beatSlicerToggleButton;
    private ColorButton beatSlicerLoopToggleButton;
    private BeatsLabel sliceBeatsLabel;
    private ColorButton sliceIncreaseButton;
    private ColorButton sliceDecreaseButton;
    private DvsButtonsPanel buttonsPanel;
    private Icon beatSlicerStartIcon;
    private Icon beatSlicerStopIcon;

    public DeckBeatSlicerPanel() {
        this.setLayout(new GridLayout(1, 1));
        this.setTitle("Beat Slicer");
        this.buttonsPanel = new DvsButtonsPanel();
        this.add(this.buttonsPanel);
        this.beatSlicerStartIcon = Tools.getIcon(DvsDeckControlPanel.class, (String)"/com/waxmonster/waxlab/dvs/icons/slicer_start_icon16.png");
        this.beatSlicerStopIcon = Tools.getIcon(DvsDeckControlPanel.class, (String)"/com/waxmonster/waxlab/dvs/icons/slicer_stop_icon16.png");
    }

    @Override
    public void getVariableWeight(ScalableWeight dst) {
        dst.width = 2.0;
        dst.height = 1.0;
    }

    @Override
    public void setVariableFactor(double variableFactor) {
        super.setVariableFactor(variableFactor);
        this.resizeComponent((JComponent)this.beatSlicerToggleButton, variableFactor);
        this.resizeComponent((JComponent)this.beatSlicerLoopToggleButton, variableFactor);
        this.buttonsPanel.invalidate();
    }

    @Override
    protected synchronized void refreshScratchDeck() {
        ColorButton button;
        ScratchDeck scratchDeck = this.scratchDeck;
        if (this.beatSlicerToggleButton == null) {
            button = this.createDvsColorButton("ToggleBeatSlicer", "", this.styleBeatSlicer);
            button.addColorButtonListener((ColorButtonListener)new BeatSlicerToggleButtonHandler());
            button.setToolTipText("Start/Stop Beat-Slicer");
            button.setToolTipEnabled(false);
            button.setDisarmed(true);
            button.setRequestFocusEnabled(false);
            button.setIcon(this.beatSlicerStartIcon);
            this.midiMapper.registerMidiAction(button, "SlicerToggle");
            this.beatSlicerToggleButton = button;
        }
        if (this.beatSlicerLoopToggleButton == null) {
            button = this.createDvsColorButton("ToggleBeatSlicerLoop", "", this.styleBeatSlicer);
            button.addColorButtonListener((ColorButtonListener)new BeatSlicerLoopButtonHandler());
            button.setToolTipText("Toggle Loop-Mode");
            button.setToolTipEnabled(false);
            button.setDisarmed(true);
            button.setRequestFocusEnabled(false);
            button.setIcon(Tools.getIcon(DvsDeckControlPanel.class, (String)"/com/waxmonster/waxlab/dvs/icons/slicer_loop_icon16.png"));
            this.midiMapper.registerMidiAction(button, "SlicerLoopModeToggle");
            this.beatSlicerLoopToggleButton = button;
        }
        if (this.sliceIncreaseButton == null) {
            button = this.createDvsColorButton("BeatSliceIncrease", "", this.styleBeatSlicer);
            button.addColorButtonListener((ColorButtonListener)new SliceIncreaseButtonHandler());
            button.setToolTipText("Increase");
            button.setToolTipEnabled(false);
            button.setDisarmed(true);
            button.setRequestFocusEnabled(false);
            button.setIcon(Tools.getIcon(DvsDeckControlPanel.class, (String)"/com/waxmonster/waxlab/dvs/icons/beatjump_increase_icon16.png"));
            this.midiMapper.registerMidiAction(button, "SetSliceLengthDouble");
            this.sliceIncreaseButton = button;
        }
        if (this.sliceDecreaseButton == null) {
            button = this.createDvsColorButton("BeatSliceDecrease", "", this.styleBeatSlicer);
            button.addColorButtonListener((ColorButtonListener)new SliceDecreaseButtonHandler());
            button.setToolTipText("Decrease");
            button.setToolTipEnabled(false);
            button.setDisarmed(true);
            button.setRequestFocusEnabled(false);
            button.setIcon(Tools.getIcon(DvsDeckControlPanel.class, (String)"/com/waxmonster/waxlab/dvs/icons/beatjump_decrease_icon16.png"));
            this.midiMapper.registerMidiAction(button, "SetSliceLengthHalf");
            this.sliceDecreaseButton = button;
        }
        if (this.sliceBeatsLabel == null) {
            BeatsLabel label = new BeatsLabel();
            label.setText("1");
            label.setHorizontalAlignment(0);
            this.sliceBeatsLabel = label;
        }
        Component[] arr = new Component[]{this.beatSlicerToggleButton, this.beatSlicerLoopToggleButton, this.sliceBeatsLabel, this.sliceIncreaseButton, this.sliceDecreaseButton};
        this.buttonsPanel.setButtons(arr);
        this.sliceBeatsChanged(scratchDeck);
    }

    @Override
    protected synchronized void refreshViewSettings() {
        WaxLabViewSettings viewSettings = this.getViewSettings();
        if (viewSettings == null) {
            return;
        }
        Color col = viewSettings.getDvsDefaultButtonColor();
        this.styleBeatSlicer = col == null ? this.defaultButtonStyle : this.createColorButtonStyle(col);
        this.beatSlicerToggleButton.setColorButtonStyle(this.styleBeatSlicer);
        this.beatSlicerLoopToggleButton.setColorButtonStyle(this.styleBeatSlicer);
        this.sliceIncreaseButton.setColorButtonStyle(this.styleBeatSlicer);
        this.sliceDecreaseButton.setColorButtonStyle(this.styleBeatSlicer);
        this.sliceBeatsLabel.setForeground(viewSettings.getDvsBeatLengthColor());
    }

    protected void handleBeatSlicePressed(int index) {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleBeatSlicePressed: #" + index);
        }
        if ((deck = this.scratchDeck) != null) {
            deck.beatSliceTriggered(index);
        }
    }

    protected void handleBeatSliceReleased(int index) {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleBeatSliceReleased: #" + index);
        }
        if ((deck = this.scratchDeck) != null) {
            deck.beatSliceReleased(index);
        }
    }

    protected void handleBeatSlicerTogglePressed() {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleBeatSlicerTogglePressed");
        }
        if ((deck = this.scratchDeck) != null) {
            if (deck.isBeatSlicerActive()) {
                deck.stopBeatSlicer();
            } else {
                deck.startBeatSlicer();
            }
        }
    }

    protected void handleBeatSlicerToggleReleased() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleBeatSlicerToggleReleased");
        }
    }

    protected void handleBeatSlicerLoopPressed() {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleBeatSlicerLoopPressed");
        }
        if ((deck = this.scratchDeck) != null) {
            deck.setBeatSlicerLoopMode(!deck.isBeatSlicerLoopMode());
        }
    }

    protected void handleBeatSlicerLoopReleased() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleBeatSlicerLoopReleased");
        }
    }

    protected void handleSliceIncreasePressed() {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleSliceIncreasePressed");
        }
        if ((deck = this.scratchDeck) != null) {
            deck.getBeatSliceControl().setDoubleBeatSlice();
        }
    }

    protected void handleSliceIncreaseReleased() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleSliceIncreaseReleased");
        }
    }

    protected void handleSliceDecreasePressed() {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleSliceDecreasePressed");
        }
        if ((deck = this.scratchDeck) != null) {
            deck.getBeatSliceControl().setHalfBeatSlice();
        }
    }

    protected void handleSliceDecreaseReleased() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleSliceDecreaseReleased");
        }
    }

    public void beatSlicerEnabled(ScratchDeck deck) {
        this.beatSlicerToggleButton.setEnabled(true);
    }

    public void beatSlicerDisabled(ScratchDeck deck) {
        this.beatSlicerToggleButton.setEnabled(false);
    }

    public void beatSlicerStarted(ScratchDeck deck) {
        this.beatSlicerToggleButton.setSelected(true);
        this.beatSlicerToggleButton.setIcon(this.beatSlicerStopIcon);
    }

    public void beatSlicerStopped(ScratchDeck deck) {
        this.beatSlicerToggleButton.setSelected(false);
        this.beatSlicerToggleButton.setIcon(this.beatSlicerStartIcon);
    }

    public void beatSlicerLoopModeChanged(ScratchDeck deck, boolean loopMode) {
        this.beatSlicerLoopToggleButton.setSelected(loopMode);
    }

    public void sliceBeatsChanged(ScratchDeck deck) {
        double sliceBeats = deck == null ? 0.0 : deck.getBeatSliceControl().getDouble();
        this.sliceBeatsLabel.setBeats(sliceBeats);
    }

    protected class SliceDecreaseButtonHandler
    extends ColorButtonAdapter {
        protected SliceDecreaseButtonHandler() {
        }

        public void buttonPressed(ActionEvent event) {
            super.buttonPressed(event);
            DeckBeatSlicerPanel.this.handleSliceDecreasePressed();
        }

        public void buttonPressed(MouseEvent event) {
            super.buttonPressed(event);
            DeckBeatSlicerPanel.this.handleSliceDecreasePressed();
        }

        public void buttonReleased(ActionEvent event) {
            super.buttonReleased(event);
            DeckBeatSlicerPanel.this.handleSliceDecreaseReleased();
        }

        public void buttonReleased(MouseEvent event) {
            super.buttonReleased(event);
            DeckBeatSlicerPanel.this.handleSliceDecreaseReleased();
        }
    }

    protected class SliceIncreaseButtonHandler
    extends ColorButtonAdapter {
        protected SliceIncreaseButtonHandler() {
        }

        public void buttonPressed(ActionEvent event) {
            super.buttonPressed(event);
            DeckBeatSlicerPanel.this.handleSliceIncreasePressed();
        }

        public void buttonPressed(MouseEvent event) {
            super.buttonPressed(event);
            DeckBeatSlicerPanel.this.handleSliceIncreasePressed();
        }

        public void buttonReleased(ActionEvent event) {
            super.buttonReleased(event);
            DeckBeatSlicerPanel.this.handleSliceIncreaseReleased();
        }

        public void buttonReleased(MouseEvent event) {
            super.buttonReleased(event);
            DeckBeatSlicerPanel.this.handleSliceIncreaseReleased();
        }
    }

    protected class BeatSlicerLoopButtonHandler
    extends ColorButtonAdapter {
        protected BeatSlicerLoopButtonHandler() {
        }

        public void buttonPressed(ActionEvent event) {
            super.buttonPressed(event);
            DeckBeatSlicerPanel.this.handleBeatSlicerLoopPressed();
        }

        public void buttonPressed(MouseEvent event) {
            super.buttonPressed(event);
            DeckBeatSlicerPanel.this.handleBeatSlicerLoopPressed();
        }

        public void buttonReleased(ActionEvent event) {
            super.buttonReleased(event);
            DeckBeatSlicerPanel.this.handleBeatSlicerLoopReleased();
        }

        public void buttonReleased(MouseEvent event) {
            super.buttonReleased(event);
            DeckBeatSlicerPanel.this.handleBeatSlicerLoopReleased();
        }
    }

    protected class BeatSlicerToggleButtonHandler
    extends ColorButtonAdapter {
        protected BeatSlicerToggleButtonHandler() {
        }

        public void buttonPressed(ActionEvent event) {
            super.buttonPressed(event);
            DeckBeatSlicerPanel.this.handleBeatSlicerTogglePressed();
        }

        public void buttonPressed(MouseEvent event) {
            super.buttonPressed(event);
            DeckBeatSlicerPanel.this.handleBeatSlicerTogglePressed();
        }

        public void buttonReleased(ActionEvent event) {
            super.buttonReleased(event);
            DeckBeatSlicerPanel.this.handleBeatSlicerToggleReleased();
        }

        public void buttonReleased(MouseEvent event) {
            super.buttonReleased(event);
            DeckBeatSlicerPanel.this.handleBeatSlicerToggleReleased();
        }
    }
}

